;MSP430G2202 music player
;2014-06-28 Jens Bjrnhager

	.cdecls C,LIST,"msp430.h"

STACKENTRY .struct
count	.word
offset	.word
STACKENTRYL .endstruct

STACK	.struct
music	.word
delay	.word
curpos	.word
index	.word
stack	.tag STACKENTRY,9
STACKL	.endstruct

REFERENCE .struct
offset	.field 9	;$01ff
count	.field 6	;$7e00
flag	.field 1	;$8000
REFERENCEL .endstruct

RAM	.equ 0x0200

SAMPLE0	.equ r4
SAMPLE1	.equ r5
SAMPLE2	.equ r6
FREQ0	.equ r7
FREQ1	.equ r8
FREQ2	.equ r9
OSC0	.equ r10
OSC1	.equ r11
OSC2	.equ r12
TICK	.equ r13

;-------------------------------------------------------------------------------
	.sect 	".bss"
stack0	.tag	STACK
stack0	.space	STACKL
stack1	.tag	STACK
stack1	.space	STACKL
stack2	.tag	STACK
stack2	.space	STACKL
;-------------------------------------------------------------------------------
        .text
        .retain
        .retainrefs
	.global	reset
	.include two-bit_crook.mid.inc

reset   mov	#XT2OFF+13,&BCSCTL1	;dco freq
	mov	#__STACK_END,SP		;init stack

	clr	r4
clrmem	clr	RAM(r4)
	incd.b	r4
	jnc	clrmem

	clr	SAMPLE1
	clr	SAMPLE2
	;clr	TICK
	mov	#music0,stack0.music
	mov	#music1,stack1.music
	mov	#music2,stack2.music

	mov.b	#-1,&P1DIR		;P1=output
	mov   	#WDT_MDLY_0_064,&WDTCTL	;64 s interval=15.625 kHz
	bis	#WDTIE,IE1		;enable watchdog interrupt
	mov.b	#BIT2,&P1SEL		;select ta output on p1.2
	mov	#2,&TACCR0		;pcm period
	mov	#OUTMOD_7,&TACCTL1	;reset/set
	mov	#TASSEL_2+MC_1,&TACTL	;SMCLK, up mode
	bis	#CPUOFF+GIE,sr		;LPM0+int
stop
	bis	#SCG1+SCG0+OSCOFF+CPUOFF,sr	;LPM4
;-------------------------------------------------------------------------------
wdt_isr					;generate
	add	FREQ0,OSC0
	jnc	$+4
	xor	#BIT0,SAMPLE0
	add	FREQ1,OSC1
	jnc	$+4
	xor	#BIT0,SAMPLE1
	add	FREQ2,OSC2
	jnc	$+4
	xor	#BIT0,SAMPLE2
	mov	SAMPLE0,r14		;mix samples
	add	SAMPLE1,r14
	add	SAMPLE2,r14
	mov	r14,&TACCR1		;output sample
	dec	TICK
	jl	donote
	reti
;-------------------------------------------------------------------------------
donote					;advance
	push	r12			;curpos
	push	r11			;stp

	mov	#stack0,r11
	dec.b	STACK.delay(r11)
	jc	$+10
	call	#traverse
	mov	freq(r13),FREQ0

	mov	#stack1,r11
	dec.b	STACK.delay(r11)
	jc	$+10
	call	#traverse
	mov	freq(r13),FREQ1

	mov	#stack2,r11
	dec.b	STACK.delay(r11)
	jc	$+10
	call	#traverse
	mov	freq(r13),FREQ2

	pop	r11
	pop	r12
	mov	#TEMPO,TICK
	reti
;-------------------------------------------------------------------------------
traverse						;unpack
	mov	STACK.curpos(r11),r12	;r11=stack curpos->r12

	mov	#0,r13			;r13=index
decloop
	mov	r11,r14			;stack->r14
	add	r13,r14			;stack+index->r14
	dec	STACK.stack+STACKENTRY.count(r14)	;stack[r14].count--
	jnz	notz

	mov	STACK.stack+STACKENTRY.offset(r14),r12	;ret->curpos
	incd	r12			;ret+2->curpos
	sub	#4,r13			;index--
	mov	r13,STACK.index(r11)	;pop upper elements
	jmp	refloop			;Exit loop

notz
	add	#4,r13			;index++
	cmp	r13,STACK.index(r11)	;finished?
	jge	decloop			;continue

refloop
	mov	STACK.music(r11),r15	;music->r15
	add	r12,r15			;music+curpos->r15
	mov	@r15,r13		;music[curpos]->r13
	mov	r13,r14			;data->r14
	bit	#0x8000,r13		;reference?
	jz	refloopout		;no

	cmp	#0xffff,r13		;end?
	jeq	stop			;yes

	add	#4,STACK.index(r11)	;new reference
	mov	STACK.index(r11),r15	;new index
	add	r11,r15			;stack
	mov	r12,STACK.stack+STACKENTRY.offset(r15)	;curpos si

	and	#0x7e00,r13		;data
	swpb	r13
	clrc
	rrc	r13
	incd	r13
	mov	r13,STACK.stack+STACKENTRY.count(r15)	;count si

	and	#0x01ff,r14		;offset
	clrc
	rlc	r14
	mov	r14,r12			;offset curpos
	jmp	refloop

refloopout
	incd	r12			;curpos++, c=0
	mov	r12,STACK.curpos(r11)

	mov.b	r13,STACK.delay(r11)
	swpb	r13
	rlc.b	r13
	ret
;-------------------------------------------------------------------------------
	.global __STACK_END
	.sect 	.stack
	.sect   ".reset"
	.word  reset
	.sect	".int10"
	.word	wdt_isr
