//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using
using System.IO;

namespace Framefield.Core.ID0948afa7_a2c6_4724_905d_187d73805eef
{
    public class Class_LoadImage : OperatorPart.Function
    {
        //>>> _inputids
        private enum InputId
        {
            ImagePath = 0
        }
        //<<< _inputids

        //>>> _outputids
        private enum OutputId
        {
            Image = 0,
            SizeX = 1,
            SizeY = 2
        }
        //<<< _outputids

        public override void Dispose() {
            Utilities.DisposeObj(ref _imageResource);
            Utilities.DisposeObj(ref _depthImageResource);
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var ImagePath = inputs[(int)InputId.ImagePath].Eval(context).Text;
            //<<< _params

            if (ImagePath == _lastImage)
                Changed = false;

            _lastImage = ImagePath;

            if (Changed)
            {
                Dispose();
                if (File.Exists(ImagePath))
                {
                    _imageResource = ResourceManager.ReadImage(ImagePath);
                    _size = new Vector2(_imageResource.Image.Description.Width, _imageResource.Image.Description.Height); 
                }
                else
                {
                    Logger.Error(this,"Imagefile not found '{0}'", ImagePath);
                }

                //somehow this will cause an exception
                //FileInfo fi = new FileInfo(ImagePath);
                //var depthFilename = fi.DirectoryName + "\\" + Path.GetFileNameWithoutExtension(fi.Name) + "_depth.dds";
                //Logger.Error(this,"'{0}'", depthFilename);
                //if (File.Exists(depthFilename))
                //{
                //    _depthImageResource = ResourceManager.ReadImage(depthFilename);
                //}
                Changed = false;
            }

            if (_imageResource != null)
            {
                switch ((OutputId)outputIdx)
                {
                    case OutputId.Image:
                        context.Image = _imageResource.Image;
                        if (_depthImageResource != null)
                            context.DepthImage = _depthImageResource.Image;
                        break;
                    case OutputId.SizeX:
                        context.Value = _size.X;
                        break;
                    case OutputId.SizeY:
                        context.Value = _size.Y;
                        break;
                }
            }
            else
            {
                switch (outputIdx)
                {
                    case (int)OutputId.Image:
                        context.Image = null;
                        context.DepthImage = null;
                        break;
                    case (int)OutputId.SizeX:
                        context.Value = 0;
                        break;
                    case (int)OutputId.SizeY:
                        context.Value = 0;
                        break;
                }
            }

            return context;
        }

        ImageResource _imageResource;
        ImageResource _depthImageResource;
        Vector2 _size;
        String _lastImage = String.Empty;
    }
}

