//=============================================================================================================================================================
function showCurveAndClear(){
    log("SHOWING CURVE W CLEAR ============================================");
    fadeOutAllCanvasExcept("waveform");
    showCurve();
}

function addCurve(){
    log("ADDING CURVE============================================");
    fadeInCanvas("waveform");
    showCurve();
}

function showCurve(){

    var
        audio = document.getElementById( 'audio' ),
        waveform = document.getElementById( 'waveform' ),
        ctx = waveform.getContext( '2d' ),
        kick, height=1;

    //$("#waveform").fadeIn();


    kick = dancer.createKick({
        //threshold: 5,
        //decay: 1,
        //frequency: [0,1],
        onKick: function () {
            height++;
            //log("up",height)
            ctx.strokeStyle = '#ff0077';
        },
        offKick: function () {
            height--;
            //log("down",height)
            ctx.strokeStyle = '#666';
        }
    }).on();

    log("trying to bind song to waveform",song);
    song.waveform( waveform, { strokeStyle: '#666', strokeWidth: 2 });

    Dancer.isSupported() || loaded();
    !dancer.isLoaded() ? dancer.bind( 'loaded', loaded ) : loaded();

    /*
     * Loading
     */

    function loaded () {
        var
            loading = document.getElementById( 'loading' ),
            anchor  = document.createElement('A'),
            supported = Dancer.isSupported(),
            p;

        anchor.appendChild( document.createTextNode( supported ? 'Play!' : 'Close' ) );
        anchor.setAttribute( 'href', '#' );
        loading.innerHTML = '';
        loading.appendChild( anchor );

        if ( !supported ) {
            p = document.createElement('P');
            p.appendChild( document.createTextNode( 'Your browser does not currently support either Web Audio API or Audio Data API. The audio may play, but the visualizers will not move to the music; check out the latest Chrome or Firefox browsers!' ) );
            loading.appendChild( p );
        }

        anchor.addEventListener( 'click', function () {
            dancer.play();
            document.getElementById('loading').style.display = 'none';
        });
    }

    // For debugging
    window.dancer = dancer;

}
