/*

--------
|SKRUZD|
--------

The MIT License

Copyright (c) 2006 Inko Illarramendi

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/


#include <physicallayer/pl.h>
#include <behaviourlayer/bl.h>
#include <behaviourlayer/behave.h>
#include <propclass/actormove.h>
#include <propclass/meshsel.h>
#include <propclass/mesh.h>
#include <propclass/camera.h>
#include <propclass/inv.h>

#include <propclass/mover.h>

    /// The iPcSpawn property sends an message to this beaviour telling
    ///that the new entity has been created, so we will create properties
    ///for this entity and put it in game.
    /// Also, each period of time it will check the killed enemies to
    ///respawn them.
class BehaviourSpawner : public BehaviourCommon
{
private:

    csStringID id_pctimer_wakeup;
    csStringID id_pcspawn_newentity;

public:
    BehaviourSpawner (iCelEntity* entity, BehaviourLayer* bl, iCelPlLayer* pl);

    virtual ~BehaviourSpawner ()
    { }

    virtual const char* GetName () const
    {
        return "Spawner_behave";
    }
    virtual bool SendMessage (csStringID msg_id,
                              iCelPropertyClass* pc,
                              celData& ret, iCelParameterBlock* params, va_list arg);
};
