// Vertex shader input structure
struct VS_INPUT
{
    float4 Position   : POSITION;
    float4 Normal     : NORMAL;
    float2 Texture    : TEXCOORD0;
    float4 Tangent    : TANGENT;
    float4 BiTangent  : BINORMAL;
};


// Vertex shader output structure
struct VS_OUTPUT
{
    float4 Position   : POSITION;
    //float3 Normal     : TEXCOORD1;
    float2 Texture    : TEXCOORD0;
    float4 Pos	      : TEXCOORD2;
    //float3 Tangent    : TEXCOORD3;
    //float3 BiTangent  : TEXCOORD4;
};


// Global variables
float4x4 WorldView;
float4x4 ModelMat;
//float4x4 NormalMat;
float4x4 Proj;

float4 lightPosUT;

VS_OUTPUT vs_main( in VS_INPUT In )
{
    VS_OUTPUT Out;
    float4 mvPos;                     //create an output vertex

    mvPos = mul(In.Position,
                       WorldView);  //apply vertex transformation

    Out.Position = mul(mvPos, Proj);
    
    Out.Texture = In.Texture;

    Out.Pos = mul(In.Position, ModelMat) - lightPosUT;// - lpos;
    return Out;                         //return output vertex
}
