#version 330

in vec2 texcoord;
out vec4 FragColor;

uniform float t;
uniform sampler2D cam1;
uniform sampler2D cam2;
uniform sampler2D layer;
uniform int selector;

vec4 blue = vec4(0.0, 0.0, 0.2, 1.0);
ivec2 size = textureSize(cam1, 0);
vec2 d = 1.0 / size;

const float weight[8] = float[8](0.1994711402, 0.1760326634, 0.1209853623, 0.0647587978, 0.0269954833, 0.0087641502, 0.0022159242, 0.0004363413);

vec4 gauss(int kernelsize){
   vec4 sum = texture(cam2, texcoord) * weight[0];

   for(int i = 1; i < kernelsize; i++){
      sum += texture(cam2, texcoord + vec2(0.0, i)*d.x) * weight[i];
      sum += texture(cam2, texcoord - vec2(0.0, i)*d.x) * weight[i];
      sum += texture(cam2, texcoord + vec2(i, 0.0)*d.y) * weight[i];
      sum += texture(cam2, texcoord - vec2(i, 0.0)*d.y) * weight[i];
   }

   return(sum);
}

float vignette(){
   float d = distance(texcoord, vec2(0.5, 0.5));
   return(smoothstep(1.0, 0.0, d));
}


vec4 tvstripes(vec4 color){
   if(int(texcoord.y / d.y) % 3 == 0){
      return(vec4(0.0, 0.0, 0.0, 1.0));
   }

   return(color);
}

vec4 filmerror(vec4 color){
   int mod = int(texcoord.x / d.x) % 70;

   if( mod < 35){
      return(mix(color, blue, 0.05));
   }

   return(color);
}

vec4 chromatic(float offset){

   float r = texture(cam2, texcoord + vec2(offset, 0.0) * d.x).r;
   float g = texture(cam2, texcoord).g;
   float b = texture(cam2, texcoord - vec2(offset, 0.0) * d.x).b;

   return(vec4(r,g,b,1.0));
}

void main(void){
   vec4 img2;

   vec4 img1 = texture(cam1, texcoord);
   if(selector == 1){
      img2 = chromatic(4);
   }else if(selector == 2){
      img2 = tvstripes(texture(cam2, texcoord));
   }else if(selector == 3){
      img2 = filmerror(texture(cam2, texcoord));
   }else{
      img2 = gauss(2);
   }

   vec4 img3 = texture(layer, texcoord);
   FragColor = mix(mix(img1, img2, t), img3, img3.a) * vignette();
}
