#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <GL/glew.h>
#include <math.h>
#include "dv.h"
#include "shader.h"
#include "mesh3d.h"
#include "texture.h"
#include "matrix.h"
//#include "fade.h"

Mesh3D *hexa;
Mesh3D *hexa2;
Mesh3D *cross;
Mesh3D *stave;
Mesh3D *ring1;
Mesh3D *ring2;
Mesh3D *ring3;
Mesh3D *ring4;
Mesh3D *ring5;
Mesh3D *floorobj;
Mesh3D *column;

GLuint greys;
GLuint cubetex;
GLuint credits;
GLuint texts;
GLuint logo;
GLuint zero;

GLuint hexash[2], hexaprg;
GLuint postsh[2], postprg;

float pmatrix[16];
float **camanim;

GLuint cameras[3];
GLuint rendertextures[3];
GLuint depth[3];
GLuint quad;
GLuint quadbuff;

void loadCameraAnim(){
	FILE *animfile;
	char line[300];
	int count = 0, i;

	camanim = malloc(2000 * sizeof(float*)); /* We know our data file */

	animfile = fopen("data/cameraposrot.txt", "r");
	while(fgets(line, 300, animfile) != NULL){
		camanim[count] = malloc(6 * sizeof(float));
		camanim[count][0] = atof(strtok(line, " "));
		for(i = 1; i < 6; i++){
			camanim[count][i] = atof(strtok(NULL, " \n"));
		}
		count++;
	}
	fclose(animfile);
}

void initQuad(){
	GLfloat v[] = {-1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f, -1.0f, 1.0f};

	glGenVertexArrays(1, &quad);
	glBindVertexArray(quad);
	glGenBuffers(1, &quadbuff);
	glBindBuffer(GL_ARRAY_BUFFER, quadbuff);
	glBufferData(GL_ARRAY_BUFFER, 8 * sizeof(GLfloat), v, GL_STATIC_DRAW);
	glVertexAttribPointer(0, 2, GL_FLOAT, GL_FALSE, 0, 0);
	glEnableVertexAttribArray(0);

	glBindVertexArray(0);
}

void initDemo(){
	GLenum code;
	GLenum buffers[1] = {GL_COLOR_ATTACHMENT0};
	int i;

	code = glewInit();

	if(code != GLEW_OK){
		printf("Sorry: %s\n", glewGetErrorString(code));
	}

	glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
	glEnable(GL_DEPTH_TEST);

	perspectiveMatrix(pmatrix, 35.0f, 1.777777f, 0.1f, 1500.0f);

	hexash[0] = loadShader(GL_VERTEX_SHADER,   "shaders/hex.vs");
	hexash[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/hex.fs");
	hexaprg   = createProgram(2, hexash);
	postsh[0] = loadShader(GL_VERTEX_SHADER,   "shaders/post.vs");
	postsh[1] = loadShader(GL_FRAGMENT_SHADER, "shaders/post.fs");
	postprg   = createProgram(2, postsh);

	hexa      = loadOBJ("data/hexagon.obj");
	hexa2     = loadOBJ("data/hexagon2.obj");
	stave     = loadOBJ("data/mozgo_lecek.obj");
	cross     = loadOBJ("data/crossroad.obj");
	ring1     = loadOBJ("data/ring1.obj");
	ring2     = loadOBJ("data/ring2.obj");
	ring3     = loadOBJ("data/ring3.obj");
	ring4     = loadOBJ("data/ring4.obj");
	ring5     = loadOBJ("data/ring5.obj");
	floorobj  = loadOBJ("data/floor.obj");
	column    = loadOBJ("data/columns.obj");

	greys     = loadPNGTexture("data/greys.png");
	cubetex   = loadPNGTexture("data/cube.png");
	credits   = loadPNGTexture("data/credits.png");
	texts     = loadPNGTexture("data/texts.png");
	logo      = loadPNGTexture("data/logo.png");
	zero      = loadPNGTexture("data/zero.png");

	loadCameraAnim();

	glGenFramebuffers(3, cameras);
	glGenTextures(3, rendertextures);
	glGenRenderbuffers(3, depth);
	for(i = 0; i < 3; i++){
		glBindFramebuffer(GL_FRAMEBUFFER, cameras[i]);
		glBindTexture(GL_TEXTURE_2D, rendertextures[i]);
		glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, 1280, 720, 0, GL_RGB, GL_UNSIGNED_BYTE, 0);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_NEAREST);
		glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_NEAREST);

		glBindRenderbuffer(GL_RENDERBUFFER, depth[i]);
		glRenderbufferStorage(GL_RENDERBUFFER, GL_DEPTH_COMPONENT, 1280, 720);
		glFramebufferRenderbuffer(GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, GL_RENDERBUFFER, depth[i]);

		glFramebufferTexture(GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, rendertextures[i], 0);
		glDrawBuffers(1, buffers);

		if(glCheckFramebufferStatus(GL_FRAMEBUFFER) != GL_FRAMEBUFFER_COMPLETE){
			printf("Framebuffer not complete: %d\n", i);
		}
	}
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	initQuad();
}

int showDemo(double time){

	if(time < SWITCHTIME){
		renderFirstScene(time);
    }
	else if(time > SWITCHTIME && time < 155.244){ /*The end time of the demo won't change */
		renderSecondScene(time - SWITCHTIME);
	}
	else{
		return 0;
	}
	return 1;
}

void renderFirstScene(double time){
	float pos[3], target[3], up[] = {0.0, 1.0, 0.0}, up2[3];
	float camera[3][16];
	int i, has;
	GLuint tloc, loc1, loc2;
	GLfloat fade;
	GLuint img1, img2;
	double intervals[] = {49.192, 49.546, 49.873, 50.133, 50.488, 50.690, 51.094, 51.344, 51.738, 52.026, 56.717, 56.977, 57.380, 57.563, 57.976, 58.168, 58.611, 58.774, 59.255, 59.408, 64.203, 64.433, 64.846, 65.048, 65.442, 65.615, 66.058, 66.259, 66.701, 66.923, 71.627, 71.887, 72.281, 72.502, 72.867, 73.05, 73.530, 73.713, 74.116, 74.337, 79.092, 79.284, 79.746, 79.909, 80.322, 80.495, 80.954, 81.146, 81.569, 81.790, 86.536, 86.757, 87.180, 87.362, 87.804, 87.929, 88.400, 88.612, 89.035, 89.256};

	/* good for looking
	target[0] = x + sin(rx / 100.0) * cos(ry / 100.0);
	target[1] = y + sin(ry / 100.0);
	target[2] = z + cos(ry / 100.0) * cos(rx / 100.0);
	pos[0]    = x;
	pos[1]    = y;
	pos[2]    = z;

	lookAt(camera[1], pos, target, up);
	*/

	pos[0] =  -0.7035f + time;
	pos[1] =  3.0029f;
	pos[2] =  -13.5945f;

	target[0] = pos[0] + 10.0f;
	target[1] = pos[1];
	target[2] = pos[2];

	up2[0] = 0.0f;
	up2[1] = cosf(time / 6.0f);
	up2[2] = sinf(time / 6.0f);

	lookAt(camera[0], pos, target, up2);

	pos[0]    = 1.07f - 0.7f + time;
	pos[1]    = 7.12f - 6.0f;
	pos[2]    = -9.46f + 2.9f;
	target[0] = 5.688f + time;
	target[1] = -10.509f;
	target[2] = -1.73f;

	lookAt(camera[1], pos, target, up);

	pos[0]    = -2.67f + time;
	pos[1]    =  2.95f;
	pos[2]    = -12.21f;
	target[0] = -0.29f + time;
	target[1] =  0.38f;
	target[2] = -9.76f;

	lookAt(camera[2], pos, target, up);

	/* Render to texture */
	for(i = 0; i < 3; i++){
		glBindFramebuffer(GL_FRAMEBUFFER, cameras[i]);
		glViewport(0,0,1280,720);
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
		firstScene(camera[i], pos);
	}

	/* Render second stage */
	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glViewport(0, 0, 1280, 720);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glUseProgram(postprg);

	for(i = 0; i < 3; i++){
		glActiveTexture(GL_TEXTURE0 + i);
		glBindTexture(GL_TEXTURE_2D, rendertextures[i]);
	}

	glActiveTexture(GL_TEXTURE3);
	glBindTexture(GL_TEXTURE_2D, logo);

	glActiveTexture(GL_TEXTURE4);
	glBindTexture(GL_TEXTURE_2D, texts);

	glActiveTexture(GL_TEXTURE5);
	glBindTexture(GL_TEXTURE_2D, zero);

	tloc = glGetUniformLocation(postprg, "t");
	loc1 = glGetUniformLocation(postprg, "cam1");
	loc2 = glGetUniformLocation(postprg, "cam2");

	/* My fade method not working and I do not have time to fix it */
	if (time > 19.806 && time < 22.10){
		img1 = 1;
		img2 = 2;
		fade = (time - 19.806) / (22.10 - 19.806);
	}
	else if (time > 22.10 && time < 32.0){
		img1 = 1;
		img2 = 2;
		fade = 1.0f;
	}
	else if (time > 32.0 && time < 35.0){
		img1 = 2;
		img2 = 0;
		fade = (time - 32.0) / (35.0 - 32.0);
	}
	else if (time > 35.0 && time < 45.0){
		img1 = 2;
		img2 = 0;
		fade = 1.0;
	}
	else if (time > 45.0 && time < 48.0){
		img1 = 0;
		img2 = 1;
		fade = (time - 45.0) / (48.0 - 45.0);
	}
	else if (time > 48.0 && time < 58.0){
		img1 = 0;
		img2 = 1;
		fade = 1.0;
	}
	else if (time > 58.0 && time < 61.0){
		img1 = 1;
		img2 = 2;
		fade = (time - 58.0) / (61.0 - 58.0);
	}
	else if (time > 61.0 && time < 71.0){
		img1 = 1;
		img2 = 2;
		fade = 1.0;
	}
	else if (time > 71.0 && time < 74.0){
		img1 = 2;
		img2 = 1;
		fade = (time - 71.0) / (74.0 - 71.0);
	}
	else if (time >74.0 && time < 84.0){
		img1 = 2;
		img2 = 1;
		fade = 1.0;
	}
	else if (time > 84.0 && time < 87.0){
		img1 = 1;
		img2 = 0;
		fade = (time - 84.0) / (87.0 - 84.0);
	}
	else if (time > 87.0 && time < 97.0){
		img1 = 1;
		img2 = 0;
		fade = 1.0;
	}
	else if (time > 97.0 && time < 100.0){
		img1 = 0;
		img2 = 2;
		fade = (time - 97.0) / (100.0 - 97.0);
	}
	else if (time > 100.0 && time < 110.0){
		img1 = 0;
		img2 = 2;
		fade = 1.0;
	}
	else if (time > 110.0 && time < 113.0){
		img1 = 2;
		img2 = 1;
		fade = (time - 110.0) / (113.0 - 110.0);
	}
	else if (time > 113.0 && time < 123.0){
		img1 = 2;
		img2 = 1;
		fade = (time - 113.0) - (123.0 - 113.0);
	}
	else if (time > 123.0 && time < 133.0){
		img1 = 1;
		img2 = 2;
		fade = 1.0;
	}
	else if (time > 133.0 && time < 136.0){
		img1 = 2;
		img2 = 0;
		fade = (time - 133.0) / (136.0 - 133.0);
	}
	else if (time > 136.0 && time < 150.244){
		img1 = 2;
		img2 = 0;
		fade = 1.0;
	}
	else{
		img1 = 0;
		img2 = 1;
		fade = 1.0f;
	}

	glUniform1i(loc1, img1);
	glUniform1i(loc2, img2);
	glUniform1f(tloc, fade);

	tloc = glGetUniformLocation(postprg, "layer");
	if (time < 10.0){
		glUniform1i(tloc, 4);
	}
	else if (time > 15.311 && time < 19.806){
		glUniform1i(tloc, 3);
	}
	else{
		glUniform1i(tloc, 5);
	}

	has = 0;
	tloc = glGetUniformLocation(postprg, "selector");
	for (i = 0; i < 30; i++){
		if (time > intervals[i * 2] && time <intervals[i * 2 + 1]){
			glUniform1i(tloc, 3);
			has = 1;
			break;
		}
	}

	if (has == 0){
		if (time > 30.10 && time < 73.0){
			glUniform1i(tloc, 1);
		}
		else{
			glUniform1i(tloc, 0);
		}
	}

	glBindVertexArray(quad);
	glBindBuffer(GL_ARRAY_BUFFER, quadbuff);
	glDrawArrays(GL_TRIANGLE_FAN, 0, 4);
}

void firstScene(float *camera, float *pos){
	float i,j;
	GLuint loc;
	float tr[16];

	glUseProgram(hexaprg);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, cubetex);
	loc = glGetUniformLocation(hexaprg, "tex");
	glUniform1i(loc, 0);
	loc = glGetUniformLocation(hexaprg, "lightpos");
	glUniform3fv(loc, 3, pos);
	loc = glGetUniformLocation(hexaprg, "pm");
	glUniformMatrix4fv(loc, 1, GL_FALSE, pmatrix);
	loc = glGetUniformLocation(hexaprg, "cam");
	glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
	loc = glGetUniformLocation(hexaprg, "model");

	for(i = 0.0; i < 8.0; i++){
		for(j = 0.0; j < 20.0; j++){
			translate(tr, j * 8.0f, 0.0, i * -4.0f);
			glUniformMatrix4fv(loc, 1, GL_FALSE, tr);
			drawMesh3D(floorobj);
			translate(tr, j * 8.0f, 10.0f, i * -4.0f);
			glUniformMatrix4fv(loc, 1, GL_FALSE, tr);
			drawMesh3D(floorobj);
		}
	}

	translate(tr, 0.0f, 0.0f, 0.0f);
	glUniformMatrix4fv(loc, 1, GL_FALSE, tr);
	drawMesh3D(column);
}

void renderSecondScene(double time){
	GLuint loc;

	glBindFramebuffer(GL_FRAMEBUFFER, cameras[0]);
	glViewport(0,0,1280,720);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	secondScene(time);

	glBindFramebuffer(GL_FRAMEBUFFER, 0);
	glViewport(0, 0, 1280, 720);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glUseProgram(postprg);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, rendertextures[0]);
	loc = glGetUniformLocation(postprg, "cam1");
	glUniform1i(loc, 0);
	loc = glGetUniformLocation(postprg, "cam2");
	glUniform1i(loc, 0);
	glActiveTexture(GL_TEXTURE1);
	glBindTexture(GL_TEXTURE_2D, zero);
	glActiveTexture(GL_TEXTURE2);
	glBindTexture(GL_TEXTURE_2D, credits);
	loc = glGetUniformLocation(postprg, "layer");
	if (time > 144.0 - SWITCHTIME){
		glUniform1i(loc, 2);
	}
	else{
		glUniform1i(loc, 1);
	}
	glBindVertexArray(quad);
	glBindBuffer(GL_ARRAY_BUFFER, quadbuff);
	glDrawArrays(GL_TRIANGLE_FAN, 0, 4);

}

void secondScene(double time){
	GLuint loc;
	float camera[16], tr[16], rot[16], model[16], scale[16];
	float *pos;
	float hexpos[] = {0.0, 48.0, 0.0, 
		          -1.39, 48.0, 2.4,
			  -4.1, 48.0, 2.4,
			  -5.57, 48.0, 0.0,
			  -8.35, 48.0, 0.0, 
			  -9.8, 48.0, 2.4,
			  -8.31, 48.0, 4.8,
			  -9.6, 48.0, 7.2,
			  -9.6, 144.0, 7.2,
			  -9.6, 240.0, 7.2,
			  -9.6, 336.0, 7.2,
			  -9.6, 450.0, 7.2
	};
	int htype[] = {0,0,0,0,1,1,1,1,0,1,0,0};
	int i;
	i = (int)(time * 25.0); /* 25fps camera data */
	if(i > 1999) i = 1999; /* prevent sigfault */
	pos = camanim[i];

	/*Thank You! http://www.html5gamedevs.com/topic/3293-camera-rotation-error-during-blender-export/ */
	translate(tr, -pos[0], -pos[2], pos[1]);
	rotate(rot, -pos[3] + 1.570796326794897, -pos[5], pos[4]);
	matrixMultiply4x4(tr, rot, camera);

	glUseProgram(hexaprg);
	loc = glGetUniformLocation(hexaprg, "lightpos");
	glUniform3fv(loc, 3, pos);
	loc = glGetUniformLocation(hexaprg, "pm");
	glUniformMatrix4fv(loc, 1, GL_FALSE, pmatrix);
	loc = glGetUniformLocation(hexaprg, "cam");
	glUniformMatrix4fv(loc, 1, GL_FALSE, camera);
	loc = glGetUniformLocation(hexaprg, "model");
	translate(tr, 0.0f, 0.0f, 0.0f);
	glUniformMatrix4fv(loc, 1, GL_FALSE, tr);
	glActiveTexture(GL_TEXTURE0);
	glBindTexture(GL_TEXTURE_2D, greys);
	loc = glGetUniformLocation(hexaprg, "tex");
	glUniform1i(loc, 0);
	drawMesh3D(cross);

	loc = glGetUniformLocation(hexaprg, "model");

	glBindTexture(GL_TEXTURE_2D, cubetex);
	for(i = 0; i < 12; i++){
		translate(tr, hexpos[i * 3], hexpos[i * 3 + 2], -hexpos[i * 3 + 1]); /*Blender use a different coordinate system*/
		glUniformMatrix4fv(loc, 1, GL_FALSE, tr);

		if(htype[i] == 0){
			drawMesh3D(hexa);
		}
		else{
			drawMesh3D(hexa2);
		}
	}

	glBindTexture(GL_TEXTURE_2D, greys);
	translate(tr, -time * 10.0f, 0.0f, 0.0f);
	glUniformMatrix4fv(loc, 1, GL_FALSE, tr);
	drawMesh3D(stave);

	translate(tr, -166.0f, 7.2f, -390.5f);
	rotate(rot, 0.0f, 0.0f, time);
	matrixMultiply4x4(rot, tr, model);
	glUniformMatrix4fv(loc, 1, GL_FALSE, model);
	drawMesh3D(ring1);

	rotate(rot, time, 0.0f, 0.0f);
	matrixMultiply4x4(rot, tr, model);
	glUniformMatrix4fv(loc, 1, GL_FALSE, model);
	drawMesh3D(ring2);

	uniscale(scale, 0.75f + sinf(time) / 4.0f);
	matrixMultiply4x4(scale, tr, model);
	glUniformMatrix4fv(loc, 1, GL_FALSE, model);
	drawMesh3D(ring3);

	uniscale(scale, 0.75f + cosf(time) / 4.0f);
	matrixMultiply4x4(scale, tr, model);
	glUniformMatrix4fv(loc, 1, GL_FALSE, model);
	drawMesh3D(ring4);

	uniscale(scale, 0.75f + sinf(time - (3.1415f / 4.0f)) / 4.0f);
	matrixMultiply4x4(scale, tr, model);
	glUniformMatrix4fv(loc, 1, GL_FALSE, model);
	drawMesh3D(ring5);
}
