#include <stdio.h>
#include "fade.h"

int fadecount = 0;

cgFade* readFade(char *filename){
   FILE *input;
   char line[LINESIZE];
   cgFade *myfade;

   myfade = malloc(sizeof(cgFade) * MAXFADE); // 300 is big enough for everyone ;-)
   input = fopen(filename, "r");
   while(fgets(line, LINESIZE, input) != NULL){
      myfade[fadecount].start = atof(strtok(line, " "));
      myfade[fadecount].end   = atof(strtok(NULL, " "));
      myfade[fadecount].from  = atoi(strtok(NULL, " "));
      myfade[fadecount].to    = atoi(strtok(NULL, " \n"));
      fadecount++;
      if(fadecount == MAXFADE){
         break;
      }
   }
   fclose(input);

   return(myfade);
}

void chooseFade(cgFade *myfade, float time, GLuint tloc, GLuint pic1, GLuint pic2){
   int i;
   float percentage = 1.0;
   GLuint from;
   GLuint to;

   /* Set to last position */
   from = myfade[fadecount-1].from;
   to   = myfade[fadecount-1].to;

   for(i = 0; i < fadecount; i++){
      if(time >= myfade[i].start && time <= myfade[i].end){
         percentage = (time - myfade[i].start) / (myfade[i].end - myfade[i].start);
         from = myfade[i].from;
         to = myfade[i].to;
         break;
      }
      if(time < myfade[i].start){
         percentage = 0.0;
         from = myfade[i].from;
         to = myfade[i].to;
         break;
      }
   }

   glUniform1i(pic1, from);
   glUniform1i(pic2, to);
   glUniform1f(tloc, percentage);
}
