#include <stdio.h>
#include <stdlib.h>
#include <GL/glew.h>
#include <GLFW/glfw3.h>
#include <math.h>
#include <fmod.h>
#include "dv.h"

float x,y,z,rx,ry;

void key(GLFWwindow *w, int key, int scancode, int action, int mods){
	if(key == GLFW_KEY_ESCAPE && action == GLFW_PRESS){
		glfwSetWindowShouldClose(w, GL_TRUE);
	}
	if(key == GLFW_KEY_W && action == GLFW_PRESS){
		z -= 10.1;
	}
	if(key == GLFW_KEY_S && action == GLFW_PRESS){
		z += 10.1;
	}
	if(key == GLFW_KEY_A && action == GLFW_PRESS){
		x -= 10.1;
	}
	if(key == GLFW_KEY_D && action == GLFW_PRESS){
		x += 10.1;
	}
}

void mouse(GLFWwindow *w, double x, double y){
	rx = 1024.0 / 2.0 - x;
	ry = 768.0  / 2.0 - y;
}

int main(int argc, char **argv){
	GLFWwindow *w;
	FMOD_SYSTEM *sys;
	FMOD_SOUND *music;
	FMOD_CHANNEL *channel = 0;
	FMOD_CHANNELGROUP *chgrp;
	unsigned int ms;
	double time;

	if(!glfwInit()){
		return(EXIT_FAILURE);
	}

	w = glfwCreateWindow(1280, 720, "Domestic violence", glfwGetPrimaryMonitor(), NULL);
        x = 0.0; y = 0.0; z = 0.0; ry = 0.0; rx = 0.0;

	if(w){
		glfwMakeContextCurrent(w);
		glfwSetKeyCallback(w, key);
		glfwSetCursorPosCallback(w, mouse);

		initDemo();
		
		FMOD_System_Create(&sys);
		FMOD_System_Init(sys, 32, FMOD_INIT_NORMAL, NULL);
		FMOD_System_CreateSound(sys, "data/whathappened.mp3", FMOD_DEFAULT, 0, &music);
		FMOD_System_CreateChannelGroup(sys, "channel1", &chgrp);
		FMOD_System_PlaySound(sys, music, chgrp, 0, &channel);

		while(!glfwWindowShouldClose(w)){
			FMOD_System_Update(sys);
			FMOD_Channel_GetPosition(channel, &ms, FMOD_TIMEUNIT_MS);
			time = (double)ms / 1000.0;
			if (showDemo(time/*, x, y, z, rx, ry*/) == 0){
				glfwSetWindowShouldClose(w, GL_TRUE);
			}
			glfwSwapBuffers(w);
			glfwPollEvents();
		}
		glfwDestroyWindow(w);

		FMOD_Sound_Release(music);
		FMOD_System_Close(sys);
		FMOD_System_Release(sys);
	}

	glfwTerminate();
	return(EXIT_SUCCESS);
}
