/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.registration;

import com.sun.deploy.config.Config;
import com.sun.deploy.config.Platform;
import com.sun.deploy.config.SecuritySettings;
import com.sun.deploy.registration.InstallCommands;
import com.sun.deploy.registration.InstallHints;
import java.io.File;
import java.io.FileOutputStream;

public class RegisterDeploy {
    private RegisterDeploy() {
    }

    public static final InstallCommands register(InstallHints installHints) {
        InstallCommands installCommands = new InstallCommands();
        if (installHints == null) {
            return installCommands;
        }
        if (installHints.getWebJavaEnabled() != -1 && !RegisterDeploy.setWebJavaEnabled(installHints.getWebJavaEnabled() == 1)) {
            installCommands.setInstallStatus(1);
        }
        if (installHints.getCustomSecurityLevel() != -1 && !RegisterDeploy.setSystemSecurityLevel(installHints.getCustomSecurityLevel())) {
            installCommands.setInstallStatus(1);
        }
        return installCommands;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final boolean hasSystemConfigAccess() {
        boolean bl = false;
        File file = null;
        try {
            try {
                File file2 = new File(Config.getSystemHome());
                file2.mkdirs();
                file = new File(Config.getSystemHome() + File.separator + Config.getPropertiesFilename());
                bl = file.createNewFile();
                new FileOutputStream(file).close();
            }
            catch (Throwable throwable) {
                boolean bl2 = false;
                Object var5_5 = null;
                if (file == null) return bl2;
                if (!bl) return bl2;
                file.delete();
                return bl2;
            }
            Object var5_4 = null;
            if (file == null) return true;
            if (!bl) return true;
            file.delete();
            return true;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (file == null) throw throwable;
            if (!bl) throw throwable;
            file.delete();
            throw throwable;
        }
    }

    private static final boolean setSystemSecurityLevel(int n) {
        if (n < 0 || n >= SecuritySettings.SECURITY_LEVELS.length) {
            System.out.println("unsupported security level: " + n);
            System.out.println("support level is 0 (medium), 1 (high), 2 (very high)");
            return false;
        }
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        SecuritySettings.setInstallerRecommendedSecurityLevel(n);
        return true;
    }

    private static final boolean setWebJavaEnabled(boolean bl) {
        if (!RegisterDeploy.hasSystemConfigAccess()) {
            System.out.println("user has no access to system settings");
            return false;
        }
        Platform.get().getWebJavaSwitch().setWebJavaEnabled(bl);
        return true;
    }
}

