/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.validation;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.SecuritySupport;

class SchemaFactoryFinder {
    private static boolean debug = false;
    private static SecuritySupport ss = new SecuritySupport();
    private static final String DEFAULT_PACKAGE = "com.sun.org.apache.xerces.internal";
    private static Properties cacheProps = new Properties();
    private static volatile boolean firstTime = true;
    private final ClassLoader classLoader;
    private static final Class SERVICE_CLASS;
    private static final String SERVICE_ID;

    private static void debugPrintln(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    public SchemaFactoryFinder(ClassLoader classLoader) {
        this.classLoader = classLoader;
        if (debug) {
            this.debugDisplayClassLoader();
        }
    }

    private void debugDisplayClassLoader() {
        try {
            if (this.classLoader == ss.getContextClassLoader()) {
                SchemaFactoryFinder.debugPrintln("using thread context class loader (" + this.classLoader + ") for search");
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.classLoader == ClassLoader.getSystemClassLoader()) {
            SchemaFactoryFinder.debugPrintln("using system class loader (" + this.classLoader + ") for search");
            return;
        }
        SchemaFactoryFinder.debugPrintln("using class loader (" + this.classLoader + ") for search");
    }

    public SchemaFactory newFactory(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        SchemaFactory schemaFactory = this._newFactory(string);
        if (schemaFactory != null) {
            SchemaFactoryFinder.debugPrintln("factory '" + schemaFactory.getClass().getName() + "' was found for " + string);
        } else {
            SchemaFactoryFinder.debugPrintln("unable to find a factory for " + string);
        }
        return schemaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SchemaFactory _newFactory(String string) {
        Serializable serializable;
        Object object;
        SchemaFactory schemaFactory;
        block19: {
            String string2;
            String string3;
            block18: {
                string3 = SERVICE_CLASS.getName() + ":" + string;
                try {
                    SchemaFactoryFinder.debugPrintln("Looking up system property '" + string3 + "'");
                    string2 = ss.getSystemProperty(string3);
                    if (string2 != null) {
                        SchemaFactoryFinder.debugPrintln("The value is '" + string2 + "'");
                        schemaFactory = this.createInstance(string2, true);
                        if (schemaFactory != null) {
                            return schemaFactory;
                        }
                    } else {
                        SchemaFactoryFinder.debugPrintln("The property is undefined.");
                    }
                }
                catch (Throwable throwable) {
                    if (!debug) break block18;
                    SchemaFactoryFinder.debugPrintln("failed to look up system property '" + string3 + "'");
                    throwable.printStackTrace();
                }
            }
            string2 = ss.getSystemProperty("java.home");
            String string4 = string2 + File.separator + "lib" + File.separator + "jaxp.properties";
            String string5 = null;
            try {
                if (firstTime) {
                    object = cacheProps;
                    synchronized (object) {
                        if (firstTime) {
                            serializable = new File(string4);
                            firstTime = false;
                            if (ss.doesFileExist((File)serializable)) {
                                SchemaFactoryFinder.debugPrintln("Read properties file " + serializable);
                                cacheProps.load(ss.getFileInputStream((File)serializable));
                            }
                        }
                    }
                }
                string5 = cacheProps.getProperty(string3);
                SchemaFactoryFinder.debugPrintln("found " + string5 + " in $java.home/jaxp.properties");
                if (string5 != null && (schemaFactory = this.createInstance(string5, true)) != null) {
                    return schemaFactory;
                }
            }
            catch (Exception exception) {
                if (!debug) break block19;
                exception.printStackTrace();
            }
        }
        object = this.createServiceFileIterator();
        while (object.hasNext()) {
            serializable = (URL)object.next();
            SchemaFactoryFinder.debugPrintln("looking into " + serializable);
            try {
                schemaFactory = this.loadFromService(string, ((URL)serializable).toExternalForm(), ss.getURLInputStream((URL)serializable));
                if (schemaFactory == null) continue;
                return schemaFactory;
            }
            catch (IOException iOException) {
                if (!debug) continue;
                SchemaFactoryFinder.debugPrintln("failed to read " + serializable);
                iOException.printStackTrace();
            }
        }
        if (string.equals("http://www.w3.org/2001/XMLSchema")) {
            SchemaFactoryFinder.debugPrintln("attempting to use the platform default XML Schema validator");
            return this.createInstance("com.sun.org.apache.xerces.internal.jaxp.validation.XMLSchemaFactory", true);
        }
        SchemaFactoryFinder.debugPrintln("all things were tried, but none was found. bailing out.");
        return null;
    }

    private Class createClass(String string) {
        Class<?> clazz;
        boolean bl = false;
        if (System.getSecurityManager() != null && string != null && string.startsWith(DEFAULT_PACKAGE)) {
            bl = true;
        }
        try {
            clazz = this.classLoader != null && !bl ? this.classLoader.loadClass(string) : Class.forName(string);
        }
        catch (Throwable throwable) {
            if (debug) {
                throwable.printStackTrace();
            }
            return null;
        }
        return clazz;
    }

    SchemaFactory createInstance(String string) {
        return this.createInstance(string, false);
    }

    SchemaFactory createInstance(String string, boolean bl) {
        SchemaFactory schemaFactory = null;
        SchemaFactoryFinder.debugPrintln("createInstance(" + string + ")");
        Class clazz = this.createClass(string);
        if (clazz == null) {
            SchemaFactoryFinder.debugPrintln("failed to getClass(" + string + ")");
            return null;
        }
        SchemaFactoryFinder.debugPrintln("loaded " + string + " from " + SchemaFactoryFinder.which(clazz));
        try {
            if (!bl) {
                schemaFactory = (SchemaFactory)SchemaFactoryFinder.newInstanceNoServiceLoader(clazz);
            }
            if (schemaFactory == null) {
                schemaFactory = (SchemaFactory)clazz.newInstance();
            }
        }
        catch (ClassCastException classCastException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                classCastException.printStackTrace();
            }
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }
        catch (InstantiationException instantiationException) {
            SchemaFactoryFinder.debugPrintln("could not instantiate " + clazz.getName());
            if (debug) {
                instantiationException.printStackTrace();
            }
            return null;
        }
        return schemaFactory;
    }

    private static Object newInstanceNoServiceLoader(Class<?> clazz) {
        if (System.getSecurityManager() == null) {
            return null;
        }
        try {
            Method method = clazz.getDeclaredMethod("newXMLSchemaFactoryNoServiceLoader", new Class[0]);
            return method.invoke(null, null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private SchemaFactory loadFromProperty(String string, String string2, InputStream inputStream) throws IOException {
        SchemaFactoryFinder.debugPrintln("Reading " + string2);
        Properties properties = new Properties();
        properties.load(inputStream);
        inputStream.close();
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            SchemaFactoryFinder.debugPrintln("found " + string + " = " + string3);
            return this.createInstance(string3);
        }
        SchemaFactoryFinder.debugPrintln(string + " is not in the property file");
        return null;
    }

    private SchemaFactory loadFromService(String string, String string2, InputStream inputStream) throws IOException {
        SchemaFactory schemaFactory = null;
        Class[] classArray = new Class[]{"".getClass()};
        Object[] objectArray = new Object[]{string};
        String string3 = "isSchemaLanguageSupported";
        SchemaFactoryFinder.debugPrintln("Reading " + string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string4 = null;
        while ((string4 = bufferedReader.readLine()) != null) {
            Class clazz;
            int n = string4.indexOf("#");
            switch (n) {
                case -1: {
                    break;
                }
                case 0: {
                    string4 = "";
                    break;
                }
                default: {
                    string4 = string4.substring(0, n);
                }
            }
            if ((string4 = string4.trim()).length() == 0 || (clazz = this.createClass(string4)) == null) continue;
            try {
                schemaFactory = (SchemaFactory)clazz.newInstance();
            }
            catch (ClassCastException classCastException) {
                schemaFactory = null;
                continue;
            }
            catch (InstantiationException instantiationException) {
                schemaFactory = null;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                schemaFactory = null;
                continue;
            }
            try {
                Method method = clazz.getMethod("isSchemaLanguageSupported", classArray);
                Boolean bl = (Boolean)method.invoke(schemaFactory, objectArray);
                if (bl.booleanValue()) {
                    break;
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            schemaFactory = null;
        }
        bufferedReader.close();
        return schemaFactory;
    }

    private Iterator createServiceFileIterator() {
        if (this.classLoader == null) {
            return new SingleIterator(){

                @Override
                protected Object value() {
                    ClassLoader classLoader = SchemaFactoryFinder.class.getClassLoader();
                    return ss.getResourceAsURL(classLoader, SERVICE_ID);
                }
            };
        }
        try {
            final Enumeration enumeration = ss.getResources(this.classLoader, SERVICE_ID);
            if (!enumeration.hasMoreElements()) {
                SchemaFactoryFinder.debugPrintln("no " + SERVICE_ID + " file was found");
            }
            return new Iterator(){

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return enumeration.hasMoreElements();
                }

                public Object next() {
                    return enumeration.nextElement();
                }
            };
        }
        catch (IOException iOException) {
            SchemaFactoryFinder.debugPrintln("failed to enumerate resources " + SERVICE_ID);
            if (debug) {
                iOException.printStackTrace();
            }
            return new ArrayList().iterator();
        }
    }

    private static String which(Class clazz) {
        return SchemaFactoryFinder.which(clazz.getName(), clazz.getClassLoader());
    }

    private static String which(String string, ClassLoader classLoader) {
        URL uRL;
        String string2 = string.replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((uRL = ss.getResourceAsURL(classLoader, string2)) != null) {
            return uRL.toString();
        }
        return null;
    }

    static {
        try {
            debug = ss.getSystemProperty("jaxp.debug") != null;
        }
        catch (Exception exception) {
            debug = false;
        }
        SERVICE_CLASS = SchemaFactory.class;
        SERVICE_ID = "META-INF/services/" + SERVICE_CLASS.getName();
    }

    private static abstract class SingleIterator
    implements Iterator {
        private boolean seen = false;

        private SingleIterator() {
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final boolean hasNext() {
            return !this.seen;
        }

        public final Object next() {
            if (this.seen) {
                throw new NoSuchElementException();
            }
            this.seen = true;
            return this.value();
        }

        protected abstract Object value();
    }
}

