PFont f = createFont("Arial",16,true);
int h;
int w;
int textheight;
int drawtime;
float angle;
int xx, yy, zz, hxx, hyy, hzz, clx, cly, clz, nlx, nly, nlz;
int[][] numbers = new int[501][3];
int[][] colours = new int[501][3];
int llmulti;
float kickSize, snareSize, hatSize;

import ddf.minim.*;
import ddf.minim.analysis.*;
 
Minim minim;
AudioPlayer player;
AudioMetaData meta;
BeatDetect beat;
BeatListener bl;

boolean sketchFullScreen() {
  return true;
}

class BeatListener implements AudioListener
{
  private BeatDetect beat;
  private AudioPlayer source;
  
  BeatListener(BeatDetect beat, AudioPlayer source)
  {
    this.source = source;
    this.source.addListener(this);
    this.beat = beat;
  }
  
  void samples(float[] samps)
  {
    beat.detect(source.mix);
  }
  
  void samples(float[] sampsL, float[] sampsR)
  {
    beat.detect(source.mix);
  }
}
void setup() {
  size(displayWidth, displayHeight, P3D);
  //ortho();
  //noStroke();
  strokeWeight(8);
  lights();
  xx = 30;
  yy = 100;
  zz = 30;
  hxx = 10;
  hyy = 10;
  hzz = 10;
  llmulti = 1;
  h = height;
  w = width;
  textheight = 12;
  drawtime = 0;
  for (int i = 499; i >= 0; i--) {
    for (int j = 0; j < 2; j++) {
      numbers[i][j] = 0;
    }
  }
  minim = new Minim(this);
  player = minim.loadFile("music1.mp3");
  meta = player.getMetaData();
  beat = new BeatDetect(player.bufferSize(), player.sampleRate());
  beat.setSensitivity(5);  
  player.loop();
  kickSize = snareSize = hatSize = 16;
  bl = new BeatListener(beat, player);  
  //textAlign(RIGHT);
  //textSize(textheight);
  //textMode(MODEL);
  //fill(10, 10, 10);
  //delay(3000);
}

float lastGen = 0.0;
float genTime = 100;

void draw() {  
  if (millis() > 201000) exit();
  beat.detect(player.mix);
  llmulti = 1;
  if ( beat.isKick() ) llmulti = 5;
  //if ( beat.isSnare() ) llmulti = 5;
  //if ( beat.isHat() ) llmulti = 5;
  //if (beat.isOnset()) llmulti = 5;
  //  else llmulti = 1;
  //drawtime++;
  background(255);
  pointLight(200, 60, 30, xx, yy, zz);
  //sphere(28);
  if( (millis()-lastGen) > genTime){
    int genLen = 50;
    if (llmulti < 2) {
      nlx = numbers[0][0] + round(random(genLen));
      nly = numbers[0][1] + round(random(-genLen, genLen));
      nlz = numbers[0][2] + round(random(-genLen, genLen));
    } else {
      nlx = numbers[0][0] + 20 + round(random(genLen)) * llmulti;
      nly = numbers[0][1] + 20 + round(random(-genLen, genLen)) * llmulti;
      nlz = numbers[0][2] + 20 + round(random(-genLen, genLen)) * llmulti;
    }
    int cr,cg,cb;
    cr = round(random(255));
    cg = round(random(255));
    cb = round(random(255));
    
    for (int i = 499; i >= 0; i--) {
      numbers[i+1][0] = numbers[i][0];
      numbers[i+1][1] = numbers[i][1];
      numbers[i+1][2] = numbers[i][2];
      
      colours[i+1][0] = colours[i][0];
      colours[i+1][1] = colours[i][1];
      colours[i+1][2] = colours[i][2];
    }
    numbers[0][0] = nlx;
    numbers[0][1] = nly;
    numbers[0][2] = nlz;
    colours[0][0] = cr;
    colours[0][1] = cg;
    colours[0][2] = cb;
    lastGen = millis();
  }
  for (int i = 0; i < 500; i++) {
    stroke(colours[i][0],colours[i][1],colours[i][2]);
    line(numbers[i][0],numbers[i][1],numbers[i][2], numbers[i+1][0],numbers[i+1][1],numbers[i+1][2]);
       
  }
  
  float cx = lerp(numbers[1][0],numbers[0][0],(millis()-lastGen)/genTime);
  float cy = lerp(numbers[1][1],numbers[0][1],(millis()-lastGen)/genTime);
  float cz = lerp(numbers[1][2],numbers[0][2],(millis()-lastGen)/genTime);
  
  camera(cx + 300, cy, cz, cx, cy,cz, 0, 1, 0);  
  //delay(1);
  //text(drawtime,w-1,h-5);
}

