#include "ConsoleScreen.h"

ConsoleScreen::ConsoleScreen(void)
{
	BufferSize.X=80;
	BufferSize.Y=50;
	BufferCoord.X=0;
	BufferCoord.Y=0;
	WriteRegion.Top=0;
	WriteRegion.Left=0;
	WriteRegion.Right=80;
	WriteRegion.Bottom=50;

	con_handle = GetStdHandle((DWORD)-11);


	GetConsoleScreenBufferInfo(con_handle ,&info);
	SetConsoleScreenBufferSize(con_handle,BufferSize);

}


ConsoleScreen::~ConsoleScreen(void)
{
	WriteConsoleOutput(con_handle,ConsoleBuffer,BufferSize,BufferCoord,&WriteRegion);
}

void ConsoleScreen::SetTitle(char* title)
{
	SetConsoleTitle(title);
}

void* ConsoleScreen::GetBuffer()
{
	return (void*) ConsoleBuffer;
}

void ConsoleScreen::Refresh()
{
	WriteConsoleOutput(con_handle,ConsoleBuffer,BufferSize,BufferCoord,&WriteRegion);
}

void ConsoleScreen::Put(char x, char y, char ch, char co)
{
	CHAR_INFO ci;
	ci.Attributes=co;
	ci.Char.AsciiChar=ch;
	ConsoleBuffer[(x+y*80)&0x3fff]=ci;
}