#pragma once
#include "MyGfx.h"

//this class externds the standard GFX class
//and provides extra functionality to:
// 1. color correct
// 2. convert to textmode format
// 3. print the output to console
class TmdcGfx : public MyGfx
{
	//post processing params
	float c_brighten,c_darken;
	//float c_r_bot,c_r_mid,c_r_top,c_g_bot,c_g_mid,c_g_top,c_b_bot,c_b_mid,c_b_top;
	float c_sharpen;

	float c_r[7],c_g[7],c_b[7];
	int curve_table[4][256];

	bool bCurveChange;

	int Frame32[80*50]; //intermediate buffer
	//int color;

public:

	bool bAntiAlias,bDither;
	
	void Init();

	//void SetColor(int c){color=c;}
	//int GetColor(){return color;}
	
	void PutPixelTmdc(int x, int y) {Frame32[x+y*80]=color;}
	int GetPixelTmdc(int x,int y) {return Frame32[x+y*80];}
	int* GetBufferTmdc() {return Frame32;}

	void PutCharConsole(char x,char y,char chr,char attr);
	void* GetBufferConsole();

	void SetSharpen(float x) {c_sharpen=x;}

	void ColorConverter(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, bool dither);

	void DoBuildIntermediate();
	void DoPostProcess();
	void DoConvertToText();
	void DoOutputToConsole();
	
	void DoTheMagic();

	void SetConsoleWindowTitle(char* title);

	void CalcCurves();
	void SetBrighten(float x){c_brighten=x+1;bCurveChange=true;}
	void SetDarken(float x){c_darken=x*255;bCurveChange=true;}
	void SetRed  (float a,float b, float c, float d,float e);
	void SetGreen(float a,float b, float c, float d,float e);
	void SetBlue (float a,float b, float c, float d,float e);

};

void c_conv(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, int &rerr, int &gerr, int &berr);
void c_conv_big(int in_red,int in_green, int in_blue, int &c_f, int &c_b, int &chr, int &rerr, int &gerr, int &berr);
