uniform mat4 mvp;
uniform mat4 mv;
uniform vec4 instance_positions[50];
uniform vec4 instance_parameters[50];

attribute vec3 in_position;
varying vec2 out_texcoord;
varying vec4 out_color;

void main()
{    
	vec3 up; 
	vec3 right;

	up = vec3( mv[0][1], mv[1][1], mv[2][1]);
	right = vec3( mv[0][0], mv[1][0], mv[2][0]);

	float size = instance_positions[ int(in_position.x)].w;
	vec3 position = instance_positions[ int(in_position.x)].xyz + (in_position.y * right + in_position.z * up) * size;

	gl_Position = mvp * vec4( position, 1.0);
	out_texcoord = in_position.yz * vec2(0.5) + vec2(0.5);
	out_color = instance_parameters[int(in_position.x)];
}
