varying vec2 out_texcoord0;
varying vec2 out_texcoord1;
varying vec4 out_color;

uniform sampler2D color_map;
uniform sampler2D light_map0;
uniform sampler2D emissive_map;
uniform vec2 hdr_params;
uniform vec4 emissive_color;

uniform sampler2D mirror_map;
uniform vec2 inv_resolution;
uniform vec2 mirror_parameters;

void main()
{
	vec4 texel_color = texture2D( color_map, out_texcoord0);
	vec4 lumel = texture2D( light_map0, out_texcoord1);
	vec3 emissive_texel_color = texture2D( emissive_map, out_texcoord0).xyz;

	//texel_color = vec4( 1.0);
	//lumel = vec4( 1.0);

	vec4 result_color = texel_color * lumel;

	vec3 emissive = emissive_texel_color * emissive_color.xyz * emissive_color.w * 0.03125;

	result_color.xyz += emissive;

	expose( result_color.xyz, hdr_params.x, hdr_params.y);

	float max_luminance = dot(vec3(0.30, 0.59, 0.11), result_color.xyz) + dot(vec3(0.333, 0.333, 0.333), emissive_texel_color.xyz) * emissive_color.w;
	max_luminance -= 1.0;
	result_color.w = max_luminance;


#if defined MIRROR
	//vec4 uv = view_matrix * vec4( dir3, 0.0);
	//vec4 uv = vec4( dir3, 0.0) * view_matrix;

	// float fresnel = dot( -view_dir, dir3);
	// fresnel = clamp( fresnel + 0.0, 0.0, 1.0);
	// fresnel *= reflection.w * mirror_parameters.x + mirror_parameters.y;
	
	float mirror_reflection = 0.4;//clamp( fresnel * 10.0, 0.0, 1.0);
	// mirror_reflection *= fresnel;
	
	vec2 mirror_texcoord = gl_FragCoord.xy * inv_resolution;
	//mirror_texcoord.xy += uv.xy * vec2( 0.01);
	//float f = clamp( uv.z, 0.0, 1.0);
	// mirror_texcoord.xy += dir3.xy * vec2( 0.04);
	//f = 1.0;
	vec4 mirror_color = texture2D( mirror_map, mirror_texcoord);
	result_color = result_color + mirror_color * mirror_reflection;
//	result_color.w = 0.0;
#endif


	float l = length( texel_color.xyz);
	
	// if( l < 0.012) discard;
	
	gl_FragColor = result_color;

#if defined TRANSPARENT
	gl_FragColor.w = texel_color.w;
#endif	
}
