varying vec2 out_texcoord0;

uniform sampler2D color_map;
uniform sampler2D mask_map;
uniform sampler2D glow_map0;
uniform sampler2D glow_map1;
uniform sampler2D glow_map2;
uniform sampler2D glow_map3;

uniform sampler2D depth_map;
uniform vec4 depth_parameters;
uniform float focus_distance;
uniform float time;

float rand(vec2 co)
{
	return 0.0 + 0.08 * (fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453));
}

vec3 Sepia( in vec3 color )
{
    vec3 r = vec3(
          clamp(color.r * 0.393 + color.g * 0.769 + color.b * 0.189, 0.0, 1.0)
        , clamp(color.r * 0.349 + color.g * 0.686 + color.b * 0.168, 0.0, 1.0)
        , clamp(color.r * 0.272 + color.g * 0.534 + color.b * 0.131, 0.0, 1.0) );
		
	r = mix( r, color, 0.1);
	return r;
}

void main()
{
#ifdef DOF
	float d = texture2D( depth_map, out_texcoord0).x;
	d = depth_parameters.y / (d - depth_parameters.x);
	float dof = abs( d - focus_distance) * 0.4;

	dof = min( dof, 2.5);
	
	vec4 color = texture2D( color_map, out_texcoord0, dof); 
#else
	vec4 color = texture2D( color_map, out_texcoord0); 
#endif

	vec4 glow0 = texture2D( glow_map0, out_texcoord0); 
	vec4 glow1 = texture2D( glow_map1, out_texcoord0); 
	vec4 glow2 = texture2D( glow_map2, out_texcoord0); 
	vec4 glow3 = texture2D( glow_map3, out_texcoord0); 
	
	vec4 glow = glow0 + glow1 + glow2 + glow3;
	
	float vignette = texture2D( mask_map, out_texcoord0).x;
	vignette = pow( vignette, 2.3);
	float r = rand( out_texcoord0 + vec2( time));
		
#ifdef GL_ES
	r = 0.0;
#endif
		
	gl_FragColor = color + glow - glow * color;
	gl_FragColor.xyz = Sepia( gl_FragColor.xyz + vec3( r));
	gl_FragColor.xyz = mix( gl_FragColor.xyz, (1.0 - gl_FragColor.xyz) * 4.0, vignette);
	//gl_FragColor = color;
	//gl_FragColor = glow;
}
