uniform mat4 mvp;
uniform vec4 emissive_color;
uniform vec3 light_color;

uniform sampler2D color_map;
uniform sampler2D emissive_map;

const vec3 cd0 = vec3( -0.7, -0.4, 0.5789);
const vec3 cd1 = vec3( 0.0, 0.81, 0.5789);
const vec3 cd2 = vec3( 0.7, -0.4, 0.5789);


#ifdef vertex_main

in vec3 in_position;
in vec2 in_texcoord;
in vec4 in_lumex0;
in vec4 in_lumex1;
in vec4 in_lumex2;

out vec2 v_texcoord;
out vec3 out_lumex0;
out vec3 out_lumex1;
out vec3 out_lumex2;

void main()
{	
#ifdef LIGHT
	gl_Position = mvp * vec4( in_position, 1.0);
#else
	gl_Position = mvp * vec4( in_position, 1.0);
	v_texcoord = in_texcoord;

	out_lumex0 = RGBEtoRGB( in_lumex0);
	out_lumex2 = RGBEtoRGB( in_lumex2);
	out_lumex1 = RGBEtoRGB( in_lumex1);

#endif
#ifdef LIGHT
	gl_PointSize = 1.0;
#endif
}

#endif


#ifdef fragment_main

in vec2 v_texcoord;
in vec3 out_lumex0;
in vec3 out_lumex1;
in vec3 out_lumex2;

out vec4 frag_color;

void main()
{	
#ifdef LIGHT
	frag_color = vec4( light_color * 64.0, 1.0);
#else
	vec3 lightmap = texture( color_map, v_texcoord.xy).xyz;

	vec3 lumel0 = out_lumex0;
	vec3 lumel1 = out_lumex1;
	vec3 lumel2 = out_lumex2;
	const vec3 normal = vec3( 0.0, 0.0, 1.0);

	float d0 = clamp( dot( normal, cd0), 0.0, 1.0);
	float d1 = clamp( dot( normal, cd1), 0.0, 1.0);
	float d2 = clamp( dot( normal, cd2), 0.0, 1.0);

	lumel0 *= d0;
	lumel1 *= d1;
	lumel2 *= d2;

	lightmap *= (lumel0 + lumel1 + lumel2);

	vec3 emissive = emissive_color.xyz * emissive_color.w * texture( emissive_map, v_texcoord.xy).xyz;
	
	frag_color = vec4( lightmap + emissive, 1.0);
#endif
}

#endif
