uniform mat4 mvp;
uniform vec4 lightprobe_colors[6];

float expose1( vec3 color, float exposure)
{
	float L = dot(vec3(0.30, 0.59, 0.11), color);
	return 1.0 - exp( -L * exposure);
}


#ifdef vertex_main

layout(location = 0) in vec3 in_position;
layout(location = 2) in vec3 in_normal;

out vec3 v_normal;

void main()
{	
	gl_Position = mvp * vec4( in_position * 0.1, 1.0);
	v_normal = in_normal;
}

#endif


#ifdef fragment_main

in vec3 v_normal;
out vec4 frag_color;

void main()
{	
	ivec3 is_negative;
	vec3 normal2;
	
	//normal2 = abs( normalize( v_normal));
	normal2 = normalize( v_normal);
	normal2 *= normal2;

	is_negative.x = v_normal.x < 0.0 ? 1 : 0;
	is_negative.y = v_normal.y < 0.0 ? 1 : 0;
	is_negative.z = v_normal.z < 0.0 ? 1 : 0;

	vec3 lightmap = 
		normal2.x * lightprobe_colors[ is_negative.x + 0].xyz +
		normal2.y * lightprobe_colors[ is_negative.y + 2].xyz +
		normal2.z * lightprobe_colors[ is_negative.z + 4].xyz;
	
	frag_color.xyz = lightmap;

	//frag_color.xyz = vec3( v_normal);

}

#endif
