uniform mat4 mvp;
uniform mat4 model;
uniform mat4 inv_model;
uniform vec4 bones_x[32];
uniform vec4 bones_y[32];
uniform vec4 bones_z[32];
uniform vec3 view_pos;


attribute vec3 in_position;
attribute vec2 in_texcoord;
attribute vec4 in_color;
attribute vec3 in_normal;
attribute vec3 in_tangent;
attribute vec4 in_bone_indices;
attribute vec4 in_bone_weights;
attribute vec4 in_lumex0;
attribute vec4 in_lumex1;
attribute vec4 in_lumex2;

varying vec2 out_texcoord0;
varying vec4 out_color;
varying vec3 out_normal;
varying vec3 out_tangent;
varying vec3 out_view_dir;
varying vec4 pp;
varying vec3 out_lumex0;
varying vec3 out_lumex1;
varying vec3 out_lumex2;

void main()
{    
#if defined STATIC
	out_normal = in_normal;
	out_tangent = in_tangent;

	gl_Position = mvp * vec4( in_position, 1.0);
#elif defined SKELETAL
	ivec4 bone_indices = ivec4(in_bone_indices);

	mat3 m0 = in_bone_weights.x * mat3( bones_x[bone_indices.x].xyz, bones_y[bone_indices.x].xyz, bones_z[bone_indices.x].xyz);
	mat3 m1 = in_bone_weights.y * mat3( bones_x[bone_indices.y].xyz, bones_y[bone_indices.y].xyz, bones_z[bone_indices.y].xyz);
	mat3 m2 = in_bone_weights.z * mat3( bones_x[bone_indices.z].xyz, bones_y[bone_indices.z].xyz, bones_z[bone_indices.z].xyz);
	mat3 m3 = in_bone_weights.w * mat3( bones_x[bone_indices.w].xyz, bones_y[bone_indices.w].xyz, bones_z[bone_indices.w].xyz);

	vec3 p0 = in_bone_weights.x * vec3( bones_x[bone_indices.x].w, bones_y[bone_indices.x].w, bones_z[bone_indices.x].w);
	vec3 p1 = in_bone_weights.y * vec3( bones_x[bone_indices.y].w, bones_y[bone_indices.y].w, bones_z[bone_indices.y].w);
	vec3 p2 = in_bone_weights.z * vec3( bones_x[bone_indices.z].w, bones_y[bone_indices.z].w, bones_z[bone_indices.z].w);
	vec3 p3 = in_bone_weights.w * vec3( bones_x[bone_indices.w].w, bones_y[bone_indices.w].w, bones_z[bone_indices.w].w);
	
	mat3 m = m0 + m1 + m2 + m3;
	vec3 p = p0 + p1 + p2 + p3;

	vec3 world_position = m * in_position + p;

	out_normal = m * in_normal;
	out_tangent = m * in_tangent;
	out_view_dir = world_position - view_pos;

	gl_Position = mvp * vec4( world_position, 1.0);
#else
	vec4 tmp;
	vec4 world_position = model * vec4( in_position, 1.0);

	tmp = vec4( in_normal, 0.0) * inv_model;
	out_normal = tmp.xyz;
	tmp = vec4( in_tangent, 0.0) * inv_model;
	out_tangent = tmp.xyz;
	out_view_dir = world_position.xyz - view_pos;

	gl_Position = mvp * vec4( in_position, 1.0);
	pp = mvp * vec4( in_position, 1.0);
#endif

	out_texcoord0 = in_texcoord;

#if defined LIGHTMAPPED
	out_lumex0 = RGBEtoRGB( in_lumex0);
	out_lumex1 = RGBEtoRGB( in_lumex1);
	out_lumex2 = RGBEtoRGB( in_lumex2);
#endif
}
