varying vec2 out_texcoord0;
varying vec4 out_color;
varying vec3 out_normal;
varying vec3 out_tangent;
varying vec3 out_view_dir;
varying vec3 out_lumex0;
varying vec3 out_lumex1;
varying vec3 out_lumex2;


uniform sampler2D color_map;
uniform sampler2D normal_map;
uniform sampler2D mask_map;
uniform sampler2D emissive_map;
uniform sampler2D light_map0;
uniform sampler2D light_map1;
uniform sampler2D light_map2;
uniform sampler2D mirror_map;
uniform samplerCube env_map;
uniform vec4 lightprobe_colors[6];
uniform vec4 reflection;
uniform vec4 refraction;
uniform vec3 refraction_eta;
uniform vec3 reflection_fresnel;
uniform vec3 refraction_fresnel;
uniform vec4 emissive_color;
uniform vec2 hdr_params;
uniform vec3 specular_color;
uniform vec3 specular_dir;
uniform vec2 inv_resolution;
uniform vec2 mirror_parameters;

uniform mat4 view_matrix;

varying vec4 pp;

const vec3 cd0 = vec3( -0.7, -0.4, 0.5789);
const vec3 cd1 = vec3( 0.0, 0.81, 0.5789);
const vec3 cd2 = vec3( 0.7, -0.4, 0.5789);


#if 0
vec2 parallax(vec2 uv, vec3 vd)
{
	vec3 v;
	vec3 n = normalize( out_normal);
	vec3 t = normalize( out_tangent);
	vec3 b = normalize( cross( t, n));
	mat3 tbn = mat3( t, b, n);

	tbn = transpose( tbn);

	v = normalize( tbn * vd);
	
	float h = length( texture2D( color_map, uv).xyz);
	
	h -= 0.5;
	h *= 0.05;
	
	return uv + v.xy * h;
}
#endif


// #define USE_GAMMA_CORRECTION

void main()
{
	vec4 result_color;

	vec3 view_dir = normalize( out_view_dir);

	vec4 texel_color = texture2D( color_map, out_texcoord0);
	
#ifdef USE_GAMMA_CORRECTION
	texel_color.xyz = pow( texel_color.xyz, vec3( 2.2));
#endif
	
	vec4 mask = texture2D( mask_map, out_texcoord0);
			
#if 1
	vec3 normal = texture2D( normal_map, out_texcoord0).xyz;
	normal.xy = normal.xy * 2.0 - 1.0;
	// normal.z *= 0.5;
	normal = normalize( normal);

	
	// normal = vec3( 0.0, 0.0, 1.0);
	// texel_color = vec4( 1.0);

	vec3 n = normalize( out_normal);
	vec3 t = normalize( out_tangent);
	vec3 b = normalize( cross( t, n));
	mat3 tbn = mat3( t, b, n);

	vec3 dir3 = normalize( tbn * normal);
	
#if defined LIGHTMAPPED
	vec3 lumel0 = out_lumex0;
	vec3 lumel1 = out_lumex1;
	vec3 lumel2 = out_lumex2;
	
	float d0 = clamp( dot( normal, cd0), 0.0, 1.0);
	float d1 = clamp( dot( normal, cd1), 0.0, 1.0);
	float d2 = clamp( dot( normal, cd2), 0.0, 1.0);

	lumel0 *= d0;
	lumel1 *= d1;
	lumel2 *= d2;

	vec3 lightmap = lumel0 + lumel1 + lumel2;
	
	// lightmap = pow( lightmap, 1.2);
	// lightmap = 1.0;
	
	result_color.xyz = lightmap * texel_color.xyz;
#else
	vec3 diffuse_color = fetch_cube( lightprobe_colors, dir3);// * 2.5;

	result_color.xyz = diffuse_color * texel_color.xyz;
#endif

	//#define SPECULAR
	//#define REFLECTION
	//#define REFRACTION
	//#define CHROMATIC_REFRACTION
	
#if defined SPECULAR
	vec3 dir4 = reflect( view_dir, dir3);
	vec3 reflect_color = fetch_specular_intensity( dir4, dir3, 0.0) * reflection.xyz;
	result_color.xyz = mix( result_color.xyz, reflect_color, reflection.w);
#endif


#if defined REFLECTION
	//float reflect_fresnel = clamp( pow( 1.0 + dot( view_dir, dir3), reflection_fresnel), 0.0, 1.0);
	vec3 dir4 = reflect( view_dir, dir3);
	vec3 reflect_color = fetch_cubemap( env_map, dir4, 1.0 - mask.x) * reflection.xyz;	
#ifndef LIGHTMAPPED
	reflect_color *= diffuse_color;
#endif


#ifdef USE_GAMMA_CORRECTION
	reflect_color.xyz = pow( reflect_color.xyz, vec3( 2.2));
#endif


	result_color.xyz = mix( result_color.xyz, reflect_color, reflection.w * mask.x);
	// result_color.xyz += reflect_color * reflection.w * mask.x;
#endif

#if defined REFRACTION
	//float refract_fresnel = clamp( pow( 1.0 + dot( view_dir, dir3), reraction_fresnel), 0.0, 1.0);
	vec3 dir5 = refract( view_dir, dir3, refraction_eta.x);
	vec3 refract_color = get_specular_color( dir5);
	result_color.xyz = mix( result_color.xyz, refract_color, 1.0);
#endif

#if defined CHROMATIC_REFRACTION
	//float refract_fresnel = clamp( pow( 1.0 + dot( view_dir, dir3), reraction_fresnel), 0.0, 1.0);
	vec3 dir5 = refract( view_dir, dir3, 1.21);
	vec3 dir6 = refract( view_dir, dir3, 1.22);
	vec3 dir7 = refract( view_dir, dir3, 1.23);
	vec3 refract_color = vec3( get_specular_color( dir5).x, get_specular_color( dir6).y, get_specular_color( dir7).z);
	result_color.xyz = mix( result_color.xyz, refract_color, 0.5);
#endif

#if 0
	vec4 uv = view_matrix * vec4( dir3, 0.0);
	uv.xyz = normalize( uv.xyz);
	float f0 = 1.0 - pow( uv.z, 2.0);
	float f1 = max( f0, 0.2);
	float f2 = clamp( f1, 0.0, 1.0);
	vec3 ghost = mix( refraction_fresnel, vec3(0.0,0.0,0.0), f2) * 10.0;
	result_color.xyz = mix( result_color.xyz, ghost, 0.99);
#endif
	
	vec3 emissive_texel_color = texture2D( emissive_map, out_texcoord0).xyz * emissive_color.w;
	vec3 emissive = emissive_texel_color * emissive_color.xyz;

	result_color.xyz += emissive;
	
	expose( result_color.xyz, hdr_params.x, hdr_params.y);
#endif

	float max_luminance = dot(vec3(0.30, 0.59, 0.11), result_color.xyz) + dot(vec3(0.333, 0.333, 0.333), emissive_texel_color);
	max_luminance -= 2.0;
	//max_luminance -= 0.5;
	result_color.w = max_luminance;

	
#if defined MIRROR
	//vec4 uv = view_matrix * vec4( dir3, 0.0);
	//vec4 uv = vec4( dir3, 0.0) * view_matrix;

	float fresnel = dot( -view_dir, dir3);
	fresnel = clamp( fresnel + 0.0, 0.0, 1.0);
	fresnel *= reflection.w * mirror_parameters.x + mirror_parameters.y;
	
	float mirror_reflection = clamp( fresnel * 10.0, 0.0, 1.0);
	mirror_reflection *= fresnel;
	
	vec2 mirror_texcoord = gl_FragCoord.xy * inv_resolution;
	//mirror_texcoord.xy += uv.xy * vec2( 0.01);
	//float f = clamp( uv.z, 0.0, 1.0);
	// mirror_texcoord.xy += dir3.xy * vec2( 0.04);
	//f = 1.0;
	vec4 mirror_color = texture2D( mirror_map, mirror_texcoord);
	result_color = mix( result_color, mirror_color, mirror_reflection);
#endif

	//result_color.xyz = mix( result_color.xyz, vec3(1.0), pp.z * 0.04);

	
#ifdef EDITOR
	{
		vec4 uv = view_matrix * vec4( dir3, 0.0);
		uv.xyz = normalize( uv.xyz);
		float d = pow( uv.z, 1.0); 
		result_color.xyz = mix( vec3(0.25), vec3( 1.0), d) * texel_color.xyz;
	}
#endif
	
#ifdef USE_GAMMA_CORRECTION
	result_color.xyz = pow( result_color.xyz, vec3( 1.0 / 2.2));
#endif
	
	
	gl_FragColor = result_color;

	float l = length( texel_color.xyz);
	
	//if( l < 0.05)		discard;

	// gl_FragColor.xyz = vec3( out_texcoord0.x, out_texcoord0.y, 0.0);
	 // gl_FragColor.xyz = vec3( abs( out_normal));
	// gl_FragColor.xyz = t;
	
	// gl_FragColor.xyz = mask.xxx;
	// gl_FragColor.xyz = vec3( out_texcoord0.xy, 0.0);
}
