ret = ImportMesh( "data://base/models/players/rancor/model.glm", "data://base/models/players/rancor/model_default.skin")

gmat = SearchClass("data://base/models/players/rancor/rancor_body") 
SetGmaterialf( gmat, 0, 0.3,0.15,0.0, 0.07) 

gmat = SearchClass("data://base/models/players/rancor/rancor_head") 
SetGmaterialf( gmat, 0, 0.3,0.15,0.0, 0.07) 


id0 = CreateActor( "rancor", "rancor")
SetActorScriptName( id0, "rancor")

SetActorPosition( id0, -10000, -10000, 1)
SetActorf( id0, 7*4, 4.0) --  radius 
SetActorf( id0, 24, 180)  --suly
SetActorf( id0, 17 * 4, 4.0, 4.0) --sebesseg

s = AddShape( "body", id0, 0)
SetNodePosition( s, 0, 0, -0.2)
SetShapeType( s, "capsule")
SetShapeSize( s, 0.1, 0.1, 1.1)

AddSkeletalControllerToActor( id0, "rancor.gla")

s = SearchActorNode( id0, "L_eyelid")
s = AddShape( "L_eyelid_", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 0.2, 0.2, 0.1)
SetShapeHitFactor( s, 4.0)

s = SearchActorNode( id0, "rhand_tag_bone")
s = AddTriggerShape( "jobb_okol", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 0.2, 0.6, 0.2)

s = SearchActorNode( id0, "L_mid_base")
s = AddTriggerShape( "bal_okol", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 0.6, 0.2, 0.2)

s = SearchActorNode( id0, "head_bone")
s = AddShape( "head_bone_", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 0.75, 0.75, 0.25)
SetShapeHitFactor( s, 0.5)

s = SearchActorNode( id0, "R_calve")
s = AddShape( "R_calve_", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 1.0, 0.25, 0.5)
SetShapeHitFactor( s, 0.25)

s = SearchActorNode( id0, "L_calve")
s = AddShape( "L_calve_", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 1.0, 0.25, 0.5)
SetShapeHitFactor( s, 0.25)

s = SearchActorNode( id0, "upper_spine")
s = AddShape( "upper_spine_", s, 0)
SetShapeType( s, "box")
SetShapeSize( s, 1.25, 0.75, 0.25)
SetShapeHitFactor( s, 0.0)


for i=0, 100 do
	md = SearchClass( "data://base/models/players/rancor/model.glm", i)

	if IsClassInvalid( md) == 1 then
		break
	end

	AddMesh( "m"..i, id0, md)
end

DeactivateSpawn( id0)
