/*
 * Decompiled with CFR 0.152.
 */
package toxi.geom.mesh;

import toxi.geom.IsectData3D;
import toxi.geom.Ray3D;
import toxi.geom.Triangle3D;
import toxi.geom.TriangleIntersector;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.math.Interpolation2D;
import toxi.math.MathUtils;

public class Terrain {
    protected float[] elevation;
    protected Vec3D[] vertices;
    protected int width;
    protected int depth;
    protected float scale;

    public Terrain(int n, int n2, float f) {
        this.width = n;
        this.depth = n2;
        this.scale = f;
        this.elevation = new float[n * n2];
        this.vertices = new Vec3D[this.elevation.length];
        Vec3D vec3D = new Vec3D(n, 0.0f, n2).scaleSelf(0.5f);
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                this.vertices[n3++] = new Vec3D(j, 0.0f, i).subSelf(vec3D).scaleSelf(f);
            }
        }
    }

    public int getDepth() {
        return this.depth;
    }

    public float getHeightAtCell(int n, int n2) {
        return this.elevation[this.getIndex(n, n2)];
    }

    public float getHeightAtPoint(float f, float f2) {
        float f3 = f / this.scale + (float)this.width * 0.5f;
        float f4 = f2 / this.scale + (float)this.depth * 0.5f;
        float f5 = 0.0f;
        if (f3 >= 0.0f && f3 < (float)this.width && f4 >= 0.0f && f4 < (float)this.depth) {
            int n = (int)MathUtils.min(f3 + 1.0f, (float)(this.width - 1));
            int n2 = (int)MathUtils.min(f4 + 1.0f, (float)(this.depth - 1));
            float f6 = this.getHeightAtCell((int)f3, (int)f4);
            float f7 = this.getHeightAtCell(n, (int)f4);
            float f8 = this.getHeightAtCell((int)f3, n2);
            float f9 = this.getHeightAtCell(n, n2);
            f5 = Interpolation2D.bilinear(f3, f4, (int)f3, (int)f4, n, n2, f6, f7, f8, f9);
        }
        return f5;
    }

    protected int getIndex(int n, int n2) {
        int n3 = n2 * this.width + n;
        if (n3 < 0 || n3 > this.elevation.length) {
            throw new IndexOutOfBoundsException("the given terrain cell is invalid: " + n + ";" + n2);
        }
        return n3;
    }

    protected Vec3D getVertexAtCell(int n, int n2) {
        return this.vertices[this.getIndex(n, n2)];
    }

    public int getWidth() {
        return this.width;
    }

    public IsectData3D intersectAtPoint(float f, float f2) {
        float f3 = f / this.scale + (float)this.width * 0.5f;
        float f4 = f2 / this.scale + (float)this.depth * 0.5f;
        IsectData3D isectData3D = new IsectData3D();
        if (f3 >= 0.0f && f3 < (float)this.width && f4 >= 0.0f && f4 < (float)this.depth) {
            Ray3D ray3D;
            int n = (int)MathUtils.min(f3 + 1.0f, (float)(this.width - 1));
            int n2 = (int)MathUtils.min(f4 + 1.0f, (float)(this.depth - 1));
            Vec3D vec3D = this.getVertexAtCell((int)f3, (int)f4);
            Vec3D vec3D2 = this.getVertexAtCell(n, (int)f4);
            Vec3D vec3D3 = this.getVertexAtCell(n, n2);
            Vec3D vec3D4 = this.getVertexAtCell((int)f3, n2);
            TriangleIntersector triangleIntersector = new TriangleIntersector(new Triangle3D(vec3D, vec3D2, vec3D4));
            if (triangleIntersector.intersectsRay(ray3D = new Ray3D(new Vec3D(f, 10000.0f, f2), new Vec3D(0.0f, -1.0f, 0.0f)))) {
                isectData3D = triangleIntersector.getIntersectionData();
            } else {
                triangleIntersector.setTriangle(new Triangle3D(vec3D2, vec3D3, vec3D4));
                triangleIntersector.intersectsRay(ray3D);
                isectData3D = triangleIntersector.getIntersectionData();
            }
        }
        return isectData3D;
    }

    public Terrain setElevation(float[] fArray) {
        if (this.elevation.length == fArray.length) {
            for (int i = 0; i < fArray.length; ++i) {
                this.vertices[i].y = this.elevation[i] = fArray[i];
            }
        } else {
            throw new IllegalArgumentException("the given elevation array size does not match terrain");
        }
        return this;
    }

    public Terrain setHeightAtCell(int n, int n2, float f) {
        int n3 = this.getIndex(n, n2);
        this.elevation[n3] = f;
        this.vertices[n3].y = f;
        return this;
    }

    public Mesh3D toMesh() {
        return this.toMesh(null);
    }

    public Mesh3D toMesh(float f) {
        return this.toMesh(null, f);
    }

    public Mesh3D toMesh(Mesh3D mesh3D) {
        if (mesh3D == null) {
            mesh3D = new TriangleMesh("terrain", this.vertices.length, this.vertices.length * 2);
        }
        for (int i = 1; i < this.depth; ++i) {
            for (int j = 1; j < this.width; ++j) {
                mesh3D.addFace(this.vertices[(i - 1) * this.width + (j - 1)], this.vertices[(i - 1) * this.width + j], this.vertices[i * this.width + (j - 1)]);
                mesh3D.addFace(this.vertices[(i - 1) * this.width + j], this.vertices[i * this.width + j], this.vertices[i * this.width + (j - 1)]);
            }
        }
        return mesh3D;
    }

    public Mesh3D toMesh(Mesh3D mesh3D, float f) {
        Vec3D vec3D;
        Vec3D vec3D2;
        int n;
        mesh3D = this.toMesh(mesh3D);
        Vec3D vec3D3 = new Vec3D(this.width, 0.0f, this.depth).scaleSelf(0.5f);
        float f2 = -vec3D3.x * this.scale;
        float f3 = -vec3D3.z * this.scale;
        float f4 = ((float)(this.width - 1) - vec3D3.x) * this.scale;
        float f5 = ((float)(this.depth - 1) - vec3D3.z) * this.scale;
        for (n = 1; n < this.depth; ++n) {
            vec3D2 = new Vec3D(f2, f, ((float)(n - 1) - vec3D3.z) * this.scale);
            vec3D = new Vec3D(f2, f, ((float)n - vec3D3.z) * this.scale);
            mesh3D.addFace(this.getVertexAtCell(0, n - 1), this.getVertexAtCell(0, n), vec3D2);
            mesh3D.addFace(this.getVertexAtCell(0, n), vec3D, vec3D2);
            vec3D2.x = vec3D.x = f4;
            mesh3D.addFace(this.getVertexAtCell(this.width - 1, n), this.getVertexAtCell(this.width - 1, n - 1), vec3D);
            mesh3D.addFace(this.getVertexAtCell(this.width - 1, n - 1), vec3D2, vec3D);
        }
        for (n = 1; n < this.width; ++n) {
            vec3D2 = new Vec3D(((float)(n - 1) - vec3D3.x) * this.scale, f, f3);
            vec3D = new Vec3D(((float)n - vec3D3.x) * this.scale, f, f3);
            mesh3D.addFace(this.getVertexAtCell(n, 0), this.getVertexAtCell(n - 1, 0), vec3D);
            mesh3D.addFace(this.getVertexAtCell(n - 1, 0), vec3D2, vec3D);
            vec3D2.z = vec3D.z = f5;
            mesh3D.addFace(this.getVertexAtCell(n - 1, this.depth - 1), this.getVertexAtCell(n, this.depth - 1), vec3D2);
            mesh3D.addFace(this.getVertexAtCell(n, this.depth - 1), vec3D, vec3D2);
        }
        for (n = 1; n < this.depth; ++n) {
            for (int i = 1; i < this.width; ++i) {
                vec3D = this.getVertexAtCell(i - 1, n - 1).copy();
                Vec3D vec3D4 = this.getVertexAtCell(i, n - 1).copy();
                Vec3D vec3D5 = this.getVertexAtCell(i - 1, n).copy();
                Vec3D vec3D6 = this.getVertexAtCell(i, n).copy();
                vec3D.y = f;
                vec3D4.y = f;
                vec3D5.y = f;
                vec3D6.y = f;
                mesh3D.addFace(vec3D, vec3D5, vec3D6);
                mesh3D.addFace(vec3D, vec3D6, vec3D4);
            }
        }
        return mesh3D;
    }
}

