/*
 * Decompiled with CFR 0.152.
 */
package toxi.math;

import toxi.math.CircularInterpolation;
import toxi.math.InterpolateStrategy;
import toxi.math.MathUtils;

public class ZoomLensInterpolation
implements InterpolateStrategy {
    protected CircularInterpolation leftImpl = new CircularInterpolation();
    protected CircularInterpolation rightImpl = new CircularInterpolation();
    protected float lensPos;
    protected float lensStrength;
    protected float absStrength;

    public ZoomLensInterpolation() {
        this(0.5f, 1.0f);
    }

    public ZoomLensInterpolation(float f, float f2) {
        this.lensPos = f;
        this.lensStrength = f2;
        this.absStrength = MathUtils.abs(f2);
        this.leftImpl.setFlipped(f2 > 0.0f);
        this.rightImpl.setFlipped(f2 < 0.0f);
    }

    public float interpolate(float f, float f2, float f3) {
        float f4 = f + (f2 - f) * f3;
        f4 = f3 < this.lensPos ? (f4 += (this.leftImpl.interpolate(f, f + (f2 - f) * this.lensPos, f3 / this.lensPos) - f4) * this.absStrength) : (f4 += (this.rightImpl.interpolate(f + (f2 - f) * this.lensPos, f2, (f3 - this.lensPos) / (1.0f - this.lensPos)) - f4) * this.absStrength);
        return f4;
    }

    public void setLensPos(float f, float f2) {
        this.lensPos += (MathUtils.clipNormalized(f) - this.lensPos) * f2;
    }

    public void setLensStrength(float f, float f2) {
        this.lensStrength += (MathUtils.clip(f, -1.0f, 1.0f) - this.lensStrength) * f2;
        this.absStrength = MathUtils.abs(this.lensStrength);
        this.leftImpl.setFlipped(this.lensStrength > 0.0f);
        this.rightImpl.setFlipped(this.lensStrength < 0.0f);
    }
}

