/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.MultiChannelBuffer;
import ddf.minim.analysis.FFT;
import java.util.Arrays;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PShape;
import processing.core.PVector;
import processing.opengl.PShader;

public class demo
extends PApplet {
    Moonlander moonlander;
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    PShape s;
    PShape b;
    PShader oceanShader;
    float currentTime;
    float lastTime = 0.0f;
    float[][] points;
    float mindist = 250.0f;
    int ptnum = 400;
    PFont font;
    float lastSec = 0.0f;
    String tempStr = "";
    int windowsize = 4096;
    int rate = 44100;
    Hexagon hex;
    FFT fft;
    float[] sampledata;
    MultiChannelBuffer buffers;
    AudioPlayer audioplayer;
    Minim minim;

    public int getStrPos(String[] stringArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            if (n < n2 + stringArray[n3].length()) {
                return n3;
            }
            n2 += stringArray[n3].length();
            ++n3;
        }
        return -1;
    }

    public int getIndPos(String[] stringArray, int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < 8) {
            if (n < n2 + stringArray[n3].length()) {
                return n - n2;
            }
            n2 += stringArray[n3].length();
            ++n3;
        }
        return -1;
    }

    public void rec(int n, Hexagon hexagon) {
        if (n > 0) {
            hexagon.display();
            if (n > 1) {
                int n2 = 0;
                while (n2 < 6) {
                    this.pushMatrix();
                    PVector pVector = hexagon.getVertex(n2);
                    this.translate(pVector.x * 2.0f * demo.sin((float)((float)this.moonlander.getCurrentTime())), pVector.y * 2.0f * demo.sin((float)((float)this.moonlander.getCurrentTime())));
                    this.rec(n - 1, hexagon);
                    this.popMatrix();
                    ++n2;
                }
            }
        }
    }

    public int player_samplepos() {
        float f = (float)this.moonlander.getCurrentTime();
        int n = (int)(f * (float)this.rate);
        n -= this.windowsize / 2;
        n = demo.max((int)n, (int)0);
        n = demo.min((int)n, (int)(this.sampledata.length - this.windowsize));
        return n;
    }

    public void analyze() {
        int n = this.player_samplepos();
        float[] fArray = Arrays.copyOfRange(this.sampledata, n, n + this.windowsize);
        this.fft.forward(fArray);
    }

    public void setup() {
        this.frameRate(60.0f);
        this.minim = new Minim((Object)this);
        this.buffers = new MultiChannelBuffer(2, 2);
        this.minim.loadFileIntoBuffer("graffa.wav", this.buffers);
        this.sampledata = this.buffers.getChannel(0);
        this.fft = new FFT(this.windowsize, (float)this.rate);
        this.fft.window(FFT.HAMMING);
        this.randomSeed(42L);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"graffa.wav", (int)89, (int)4);
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics3D");
        this.rectMode(3);
        this.noStroke();
        this.colorMode(1, 1.0f);
        this.b = this.loadShape("bubble.obj");
        this.perspective(1.0471976f, (float)this.width / (float)this.height, 1.0f, 100000.0f);
        this.s = this.loadShape("flatgrid.obj");
        this.oceanShader = this.loadShader("toonFrag.glsl", "toonVert.glsl");
        this.oceanShader.set("fraction", 1.0f);
        this.oceanShader.set("color1", 1.0f);
        this.oceanShader.set("color2", 0.9f);
        this.oceanShader.set("color3", 0.8f);
        this.oceanShader.set("color4", 0.7f);
        this.oceanShader.set("color5", 0.6f);
        this.oceanShader.set("color6", 0.5f);
        this.oceanShader.set("color7", 0.4f);
        this.oceanShader.set("color8", 0.3f);
        this.oceanShader.set("color_treshold1", 1.0f);
        this.oceanShader.set("color_treshold2", 0.9f);
        this.oceanShader.set("color_treshold3", 0.8f);
        this.oceanShader.set("color_treshold4", 0.7f);
        this.oceanShader.set("color_treshold5", 0.6f);
        this.oceanShader.set("color_treshold6", 0.5f);
        this.oceanShader.set("color_treshold7", 0.4f);
        this.hex = new Hexagon(100.0f, 255);
        this.points = new float[this.ptnum][3];
        int n = 0;
        while (n < this.ptnum) {
            this.points[n][0] = this.random(20.0f, this.width);
            this.points[n][1] = this.random(20.0f, this.height);
            this.points[n][2] = this.random(20.0f, this.width);
            ++n;
        }
        this.font = this.createFont("FreeMonoBold.otf", 42.0f, true);
        this.textFont(this.font);
        this.moonlander.start();
    }

    public String scramble(String string, int n) {
        char[] cArray = string.toCharArray();
        int n2 = n;
        while (n2 < string.length()) {
            cArray[n2] = (char)this.random(33.0f, 126.0f);
            ++n2;
        }
        return new String(cArray);
    }

    public void draw() {
        this.moonlander.update();
        this.currentTime = (float)this.moonlander.getCurrentTime();
        this.analyze();
        int n = (int)this.moonlander.getValue("scene");
        float f = 0.0f;
        float f2 = 0.0f;
        int n2 = 0;
        while (n2 < (int)this.moonlander.getValue("beat1_band")) {
            f += this.fft.getBand(n2);
            ++n2;
        }
        n2 = (int)this.moonlander.getValue("beat2_band");
        while (n2 < (int)this.moonlander.getValue("beat2_band")) {
            f2 += this.fft.getBand(n2);
            ++n2;
        }
        f /= 300.0f;
        f2 /= 300.0f;
        if (n == 1 || n == 2 || n == 3) {
            this.oceanShader.set("baseColor", (float)this.moonlander.getValue("water_R"), (float)this.moonlander.getValue("water_G"), (float)this.moonlander.getValue("water_B"), (float)this.moonlander.getValue("water_alpha"));
            this.background((float)this.moonlander.getValue("bg_R"), (float)this.moonlander.getValue("bg_G"), (float)this.moonlander.getValue("bg_B"));
            this.directionalLight(255.0f, 255.0f, 255.0f, 0.0f, 1.0f, 0.0f);
            this.pushMatrix();
            this.translate((float)this.moonlander.getValue("camera_x"), (float)this.moonlander.getValue("camera_y"), (float)this.moonlander.getValue("camera_z"));
            this.rotateX(demo.radians((float)((float)this.moonlander.getValue("rotate_x"))));
            this.rotateZ(demo.radians((float)((float)this.moonlander.getValue("rotate_z"))));
            this.rotateY(demo.radians((float)((float)this.moonlander.getValue("rotate_y"))));
            this.scale(500.0f);
            this.shader(this.oceanShader);
            n2 = 0;
            while (n2 < this.s.getChildCount()) {
                PShape pShape = this.s.getChild(n2);
                int n3 = 0;
                while (n3 < pShape.getVertexCount()) {
                    PVector pVector = pShape.getVertex(n3);
                    pVector.y = (float)this.moonlander.getValue("wave1") * (demo.sin((float)(pVector.x * (float)this.moonlander.getValue("wave1_spd") + (float)this.moonlander.getCurrentTime())) + demo.cos((float)(pVector.z * (float)this.moonlander.getValue("wave1_spd") + (float)this.moonlander.getCurrentTime())));
                    pVector.y += (float)this.moonlander.getValue("wave2") * (demo.sin((float)(pVector.x * (float)this.moonlander.getValue("wave2_spd") + (float)this.moonlander.getCurrentTime())) + demo.cos((float)(pVector.z * (float)this.moonlander.getValue("wave2_spd") + (float)this.moonlander.getCurrentTime())));
                    pVector.y += demo.max((float)0.5f, (float)demo.min((float)f2, (float)1.0f)) * (float)this.moonlander.getValue("wave3") * (demo.sin((float)(pVector.x * (float)this.moonlander.getValue("wave3_spd") + (float)this.moonlander.getCurrentTime())) + demo.cos((float)(pVector.z * (float)this.moonlander.getValue("wave3_spd") + (float)this.moonlander.getCurrentTime())));
                    pVector.y += demo.max((float)0.5f, (float)demo.min((float)f, (float)1.0f)) * (float)this.moonlander.getValue("wave4") * ((pVector.x * pVector.x + pVector.z * pVector.z * pVector.z) % 20.0f);
                    pShape.setVertex(n3, pVector);
                    ++n3;
                }
                ++n2;
            }
            this.shape(this.s);
            if (n == 2) {
                float f3 = (float)this.moonlander.getValue("SphereX");
                float f4 = (float)this.moonlander.getValue("SphereY");
                float f5 = (float)this.moonlander.getValue("SphereZ");
                this.oceanShader.set("baseColor", (float)this.moonlander.getValue("sphere_R"), (float)this.moonlander.getValue("sphere_G"), (float)this.moonlander.getValue("sphere_B"), (float)this.moonlander.getValue("sphere_alpha"));
                this.pushMatrix();
                this.translate(f3, f4, f5);
                this.shape(this.s);
                this.popMatrix();
            }
            this.resetShader();
            this.popMatrix();
        }
        if (n == 3 || n == 4) {
            int n4;
            int n5 = (int)this.moonlander.getValue("Recursion level");
            if (n == 4) {
                this.hint(2);
                this.fill(0, 20.0f);
                this.rect(0.0f, 0.0f, this.width * 2, this.height * 2);
                this.hint(-2);
            }
            this.hint(2);
            this.colorMode(1, 255.0f);
            this.stroke(100.0f, 100.0f, 0.0f);
            float f6 = (float)this.moonlander.getValue("rectRed");
            float f7 = (float)this.moonlander.getValue("rectGreen");
            float f8 = (float)this.moonlander.getValue("rectBlue");
            int n6 = (int)this.moonlander.getValue("Rectangel #");
            if (n6 > 1) {
                n4 = 0;
                while (n4 < n6) {
                    this.fill(f6, f7, f8);
                    this.rect(0.0f, this.CANVAS_HEIGHT / n6 * n4, (float)this.CANVAS_WIDTH * 1.5f, this.CANVAS_HEIGHT / (n6 - 1));
                    ++n4;
                }
            }
            this.pushMatrix();
            this.translate(this.CANVAS_WIDTH / 2, this.CANVAS_HEIGHT / 2);
            this.scale(demo.max((float)1.0f, (float)(f / 3.0f)));
            this.fill((float)this.moonlander.getValue("hexRed"), (float)this.moonlander.getValue("hexGreen"), (float)this.moonlander.getValue("hexBlue"), (float)this.moonlander.getValue("hexAlpha"));
            this.stroke(1.0f, 0.0f, 0.0f);
            this.strokeWeight(2.0f);
            n4 = (int)this.moonlander.getValue("Rotate");
            if (n4 == 1 && this.lastTime != this.currentTime) {
                int n7 = 0;
                while (n7 < this.hex.getVertexCount()) {
                    PVector pVector = this.hex.getVertex(n7);
                    pVector.x += demo.cos((float)((float)Math.PI * (float)this.millis() / 1000.0f));
                    pVector.y += demo.sin((float)((float)Math.PI * (float)this.millis() / 1000.0f));
                    this.hex.setVertex(n7, pVector);
                    ++n7;
                }
            }
            this.rotateZ(this.currentTime);
            this.rotateY(this.currentTime);
            this.rec(n5, this.hex);
            this.popMatrix();
            this.lastTime = this.currentTime;
            this.hint(-2);
        } else if (n == 5) {
            float f9 = (float)this.moonlander.getValue("lineScale");
            float f10 = (float)this.moonlander.getValue("lineRotMult");
            float f11 = (float)this.moonlander.getValue("sphereScale");
            if (f < 2.0f) {
                this.background(0);
            }
            this.colorMode(1, 255.0f);
            this.hint(2);
            this.fill(0, 2.0f);
            this.rect(0.0f, 0.0f, this.width * 2, this.height * 2);
            this.hint(-2);
            this.pushMatrix();
            this.translate(this.width / 2, this.height / 2, 0.0f);
            this.pushMatrix();
            this.rotateZ(demo.radians((float)(f10 * this.currentTime * 30.0f * 3.0f)));
            this.scale(demo.radians((float)f9));
            int n8 = 0;
            while (n8 < this.ptnum) {
                float[] fArray = this.points[n8];
                fArray[0] = fArray[0] + demo.sin((float)(demo.radians((float)(this.currentTime * 30.0f)) * this.noise(this.points[n8][0] + 50.0f))) * this.random(-2.0f, 2.0f);
                float[] fArray2 = this.points[n8];
                fArray2[1] = fArray2[1] + demo.cos((float)(demo.radians((float)(this.currentTime * 30.0f)) * this.noise(this.points[n8][1] + 13.0f))) * this.random(-2.0f, 2.0f);
                float[] fArray3 = this.points[n8];
                fArray3[2] = fArray3[2] + demo.cos((float)(demo.radians((float)(this.currentTime * 30.0f)) * this.noise(this.points[n8][2]))) * this.random(-2.0f, 2.0f);
                ++n8;
            }
            this.fill(255);
            this.stroke(255, 15.0f);
            this.blendMode(1);
            n8 = 0;
            while (n8 < this.ptnum) {
                int n9 = 0;
                while (n9 < this.ptnum) {
                    float f12 = demo.dist((float)this.points[n8][0], (float)this.points[n8][1], (float)this.points[n8][2], (float)this.points[n9][0], (float)this.points[n9][1], (float)this.points[n9][2]);
                    if (f12 < this.mindist) {
                        this.line(this.points[n8][0], this.points[n8][1], this.points[n8][2], this.points[n9][0], this.points[n9][1], this.points[n9][2]);
                    }
                    ++n9;
                }
                ++n8;
            }
            this.popMatrix();
            this.rotateY(demo.radians((float)(this.currentTime * 30.0f * 4.0f)));
            this.directionalLight(255.0f, 255.0f, 255.0f, 0.0f, 1.0f, 0.0f);
            this.noStroke();
            this.fill(155);
            this.scale(f11);
            this.sphere(10.0f);
            this.popMatrix();
        }
        if (n == 6) {
            this.colorMode(3, 255.0f);
            this.background(0);
            this.colorMode(1, 255.0f);
            this.fill(0.0f, 200.0f, 0.0f);
            String[] stringArray = new String[]{"#Graffathon demokomp00000 ", "Demo made by group ", "Ihan sama, joo ", "Members ", "Pingviinituutti ", "FruitieX ", "Craas ", "Huutoja kaikille, jooko? "};
            this.text(stringArray[0], 0.0f, 100.0f);
            int n10 = (int)this.moonlander.getValue("CredPos");
            this.tempStr = this.scramble(stringArray[this.getStrPos(stringArray, n10)], this.getIndPos(stringArray, n10));
            this.lastSec = (int)this.currentTime;
            this.text(this.tempStr, 0.0f, 150.0f);
        }
        if (n == 10) {
            this.exit();
        }
        this.hint(2);
        this.fill((float)this.moonlander.getValue("fadecolorR"), (float)this.moonlander.getValue("fadecolorG"), (float)this.moonlander.getValue("fadecolorB"), (float)this.moonlander.getValue("fade"));
        this.rect(0.0f, 0.0f, this.width * 2, this.height * 2);
        this.hint(-2);
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Hexagon {
        PShape h;

        Hexagon(float f, int n) {
            this.h = demo.this.createShape();
            this.h.beginShape();
            float f2 = demo.cos((float)0.5235988f) * f;
            this.h.vertex(-f, 0.0f);
            this.h.vertex(-f / 2.0f, -f2);
            this.h.vertex(f / 2.0f, -f2);
            this.h.vertex(f, 0.0f);
            this.h.vertex(f / 2.0f, f2);
            this.h.vertex(-f / 2.0f, f2);
            this.h.endShape(2);
            this.h.disableStyle();
        }

        public PVector getVertex(int n) {
            return this.h.getVertex(n);
        }

        public int getVertexCount() {
            return this.h.getVertexCount();
        }

        public void setVertex(int n, PVector pVector) {
            this.h.setVertex(n, pVector);
        }

        public void display() {
            demo.this.shape(this.h);
        }
    }
}

