/*
 * Decompiled with CFR 0.152.
 */
package toxi.processing;

import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import processing.core.PApplet;
import processing.core.PGraphics;
import processing.core.PImage;
import toxi.geom.AABB;
import toxi.geom.AxisAlignedCylinder;
import toxi.geom.Cone;
import toxi.geom.Ellipse;
import toxi.geom.Line2D;
import toxi.geom.Line3D;
import toxi.geom.Matrix4x4;
import toxi.geom.Plane;
import toxi.geom.Polygon2D;
import toxi.geom.Ray2D;
import toxi.geom.Ray3D;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.ReadonlyVec3D;
import toxi.geom.Rect;
import toxi.geom.Sphere;
import toxi.geom.Triangle2D;
import toxi.geom.Triangle3D;
import toxi.geom.Vec2D;
import toxi.geom.Vec3D;
import toxi.geom.mesh.Face;
import toxi.geom.mesh.Mesh3D;
import toxi.geom.mesh.TriangleMesh;
import toxi.geom.mesh.Vertex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToxiclibsSupport {
    protected static final Logger logger = Logger.getLogger(ToxiclibsSupport.class.getName());
    protected PApplet app;
    protected PGraphics gfx;
    private Matrix4x4 normalMap = new Matrix4x4().translateSelf(128.0, 128.0, 128.0).scaleSelf(127.0);

    public ToxiclibsSupport(PApplet pApplet) {
        this(pApplet, pApplet.g);
    }

    public ToxiclibsSupport(PApplet pApplet, PGraphics pGraphics) {
        this.app = pApplet;
        this.gfx = pGraphics;
    }

    public final void box(AABB aABB) {
        this.mesh(aABB.toMesh(), false, 0.0f);
    }

    public final void box(AABB aABB, boolean bl) {
        Mesh3D mesh3D = aABB.toMesh();
        if (bl) {
            mesh3D.computeVertexNormals();
        }
        this.mesh(mesh3D, bl, 0.0f);
    }

    public final void circle(Vec2D vec2D, float f) {
        this.gfx.ellipse(vec2D.x, vec2D.y, f, f);
    }

    public final void cone(Cone cone) {
        this.mesh(cone.toMesh(null, 6, 0.0f, true, true), false, 0.0f);
    }

    public final void cone(Cone cone, boolean bl, boolean bl2) {
        this.mesh(cone.toMesh(null, 6, 0.0f, bl, bl2), false, 0.0f);
    }

    public final void cone(Cone cone, int n, boolean bl) {
        this.cone(cone, n, true, true, bl);
    }

    public final void cone(Cone cone, int n, boolean bl, boolean bl2, boolean bl3) {
        Mesh3D mesh3D = cone.toMesh(n);
        if (bl3) {
            mesh3D.computeVertexNormals();
        }
        this.mesh(mesh3D, bl3, 0.0f);
    }

    public final void cylinder(AxisAlignedCylinder axisAlignedCylinder) {
        this.mesh(axisAlignedCylinder.toMesh(), false, 0.0f);
    }

    public final void cylinder(AxisAlignedCylinder axisAlignedCylinder, int n, boolean bl) {
        Mesh3D mesh3D = axisAlignedCylinder.toMesh(n, 0.0f);
        if (bl) {
            mesh3D.computeVertexNormals();
        }
        this.mesh(mesh3D, bl, 0.0f);
    }

    public final void ellipse(Ellipse ellipse) {
        Vec2D vec2D = ellipse.getRadii();
        switch (this.gfx.ellipseMode) {
            case 3: {
                this.gfx.ellipse(ellipse.x, ellipse.y, vec2D.x * 2.0f, vec2D.y * 2.0f);
                break;
            }
            case 2: {
                this.gfx.ellipse(ellipse.x, ellipse.y, vec2D.x, vec2D.y);
                break;
            }
            case 0: 
            case 1: {
                this.gfx.ellipse(ellipse.x - vec2D.x, ellipse.y - vec2D.y, vec2D.x * 2.0f, vec2D.y * 2.0f);
                break;
            }
            default: {
                logger.warning("invalid ellipse mode: " + this.gfx.ellipseMode);
            }
        }
    }

    public final PGraphics getGraphics() {
        return this.gfx;
    }

    public final void line(Line2D line2D) {
        this.gfx.line(line2D.a.x, line2D.a.y, line2D.b.x, line2D.b.y);
    }

    public final void line(Line3D line3D) {
        this.gfx.line(line3D.a.x, line3D.a.y, line3D.a.z, line3D.b.x, line3D.b.y, line3D.b.z);
    }

    public final void line(ReadonlyVec2D readonlyVec2D, ReadonlyVec2D readonlyVec2D2) {
        this.gfx.line(readonlyVec2D.x(), readonlyVec2D.y(), readonlyVec2D2.x(), readonlyVec2D2.y());
    }

    public final void line(ReadonlyVec3D readonlyVec3D, ReadonlyVec3D readonlyVec3D2) {
        this.gfx.line(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z(), readonlyVec3D2.x(), readonlyVec3D2.y(), readonlyVec3D2.z());
    }

    public final void line(Vec2D vec2D, Vec2D vec2D2) {
        this.gfx.line(vec2D.x, vec2D.y, vec2D2.x, vec2D2.y);
    }

    public final void line(Vec3D vec3D, Vec3D vec3D2) {
        this.gfx.line(vec3D.x, vec3D.y, vec3D.z, vec3D2.x, vec3D2.y, vec3D2.z);
    }

    public final void lineStrip2D(List<? extends Vec2D> list) {
        boolean bl = this.gfx.fill;
        this.gfx.fill = false;
        this.processVertices2D(list.iterator(), 20, false);
        this.gfx.fill = bl;
    }

    public final void lineStrip3D(List<? extends Vec3D> list) {
        boolean bl = this.gfx.fill;
        this.gfx.fill = false;
        this.processVertices3D(list.iterator(), 20, false);
        this.gfx.fill = bl;
    }

    public final void mesh(Mesh3D mesh3D) {
        this.mesh(mesh3D, false, 0.0f);
    }

    public final void mesh(Mesh3D mesh3D, boolean bl) {
        this.mesh(mesh3D, bl, 0.0f);
    }

    public final void mesh(Mesh3D mesh3D, boolean bl, float f) {
        this.gfx.beginShape(9);
        if (bl) {
            for (Face face : mesh3D.getFaces()) {
                this.gfx.normal(face.a.normal.x, face.a.normal.y, face.a.normal.z);
                this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                this.gfx.normal(face.b.normal.x, face.b.normal.y, face.b.normal.z);
                this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                this.gfx.normal(face.c.normal.x, face.c.normal.y, face.c.normal.z);
                this.gfx.vertex(face.c.x, face.c.y, face.c.z);
            }
        } else {
            for (Face face : mesh3D.getFaces()) {
                this.gfx.normal(face.normal.x, face.normal.y, face.normal.z);
                this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                this.gfx.vertex(face.c.x, face.c.y, face.c.z);
            }
        }
        this.gfx.endShape();
        if (f > 0.0f) {
            int n = 0;
            boolean bl2 = this.gfx.stroke;
            if (bl2) {
                n = this.gfx.strokeColor;
            }
            if (bl) {
                for (Vertex vertex : mesh3D.getVertices()) {
                    Vec3D vec3D = vertex.add(vertex.normal.scale(f));
                    Vec3D vec3D2 = vertex.normal.scale(127.0f);
                    this.gfx.stroke(vec3D2.x + 128.0f, vec3D2.y + 128.0f, vec3D2.z + 128.0f);
                    this.gfx.line(vertex.x, vertex.y, vertex.z, vec3D.x, vec3D.y, vec3D.z);
                }
            } else {
                float f2 = 0.33333334f;
                for (Face face : mesh3D.getFaces()) {
                    Vec3D vec3D = face.a.add((Vec3D)face.b).addSelf((Vec3D)face.c).scaleSelf(f2);
                    Vec3D vec3D3 = vec3D.add(face.normal.scale(f));
                    Vec3D vec3D4 = face.normal.scale(127.0f);
                    this.gfx.stroke(vec3D4.x + 128.0f, vec3D4.y + 128.0f, vec3D4.z + 128.0f);
                    this.gfx.line(vec3D.x, vec3D.y, vec3D.z, vec3D3.x, vec3D3.y, vec3D3.z);
                }
            }
            if (bl2) {
                this.gfx.stroke(n);
            } else {
                this.gfx.noStroke();
            }
        }
    }

    public final void meshNormalMapped(Mesh3D mesh3D, boolean bl, float f) {
        block8: {
            Vec3D vec3D;
            this.gfx.beginShape(9);
            if (bl) {
                for (Face face : mesh3D.getFaces()) {
                    vec3D = this.normalMap.applyTo((ReadonlyVec3D)face.a.normal);
                    this.gfx.fill(vec3D.x, vec3D.y, vec3D.z);
                    this.gfx.normal(face.a.normal.x, face.a.normal.y, face.a.normal.z);
                    this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                    vec3D = this.normalMap.applyTo((ReadonlyVec3D)face.b.normal);
                    this.gfx.fill(vec3D.x, vec3D.y, vec3D.z);
                    this.gfx.normal(face.b.normal.x, face.b.normal.y, face.b.normal.z);
                    this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                    vec3D = this.normalMap.applyTo((ReadonlyVec3D)face.c.normal);
                    this.gfx.fill(vec3D.x, vec3D.y, vec3D.z);
                    this.gfx.normal(face.c.normal.x, face.c.normal.y, face.c.normal.z);
                    this.gfx.vertex(face.c.x, face.c.y, face.c.z);
                }
            } else {
                for (Face face : mesh3D.getFaces()) {
                    this.gfx.normal(face.normal.x, face.normal.y, face.normal.z);
                    this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                    this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                    this.gfx.vertex(face.c.x, face.c.y, face.c.z);
                }
            }
            this.gfx.endShape();
            if (!(f > 0.0f)) break block8;
            if (bl) {
                for (Face face : mesh3D.getVertices()) {
                    vec3D = face.add(face.normal.scale(f));
                    Vec3D vec3D2 = face.normal.scale(127.0f);
                    this.gfx.stroke(vec3D2.x + 128.0f, vec3D2.y + 128.0f, vec3D2.z + 128.0f);
                    this.gfx.line(face.x, face.y, face.z, vec3D.x, vec3D.y, vec3D.z);
                }
            } else {
                for (Face face : mesh3D.getFaces()) {
                    vec3D = face.getCentroid();
                    Vec3D vec3D3 = vec3D.add(face.normal.scale(f));
                    Vec3D vec3D4 = face.normal.scale(127.0f);
                    this.gfx.stroke(vec3D4.x + 128.0f, vec3D4.y + 128.0f, vec3D4.z + 128.0f);
                    this.gfx.line(vec3D.x, vec3D.y, vec3D.z, vec3D3.x, vec3D3.y, vec3D3.z);
                }
            }
        }
    }

    public void origin(float f) {
        this.origin(Vec3D.ZERO, f);
    }

    public final void origin(ReadonlyVec3D readonlyVec3D, float f) {
        float f2 = readonlyVec3D.x();
        float f3 = readonlyVec3D.y();
        float f4 = readonlyVec3D.z();
        this.gfx.stroke(255.0f, 0.0f, 0.0f);
        this.gfx.line(f2, f3, f4, f2 + f, f3, f4);
        this.gfx.stroke(0.0f, 255.0f, 0.0f);
        this.gfx.line(f2, f3, f4, f2, f3 + f, f4);
        this.gfx.stroke(0.0f, 0.0f, 255.0f);
        this.gfx.line(f2, f3, f4, f2, f3, f4 + f);
    }

    public final void plane(Plane plane, float f) {
        this.mesh(plane.toMesh(f), false, 0.0f);
    }

    public final void point(ReadonlyVec2D readonlyVec2D) {
        this.gfx.point(readonlyVec2D.x(), readonlyVec2D.y());
    }

    public final void point(ReadonlyVec3D readonlyVec3D) {
        this.gfx.point(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public final void point(Vec2D vec2D) {
        this.gfx.point(vec2D.x, vec2D.y);
    }

    public final void point(Vec3D vec3D) {
        this.gfx.point(vec3D.x, vec3D.y, vec3D.z);
    }

    public final void points2D(Iterator<? extends Vec2D> iterator) {
        this.processVertices2D(iterator, 2, false);
    }

    public final void points2D(List<? extends Vec2D> list) {
        this.processVertices2D(list.iterator(), 2, false);
    }

    public final void points3D(Iterator<? extends Vec3D> iterator) {
        this.processVertices3D(iterator, 2, false);
    }

    public final void points3D(List<? extends Vec3D> list) {
        this.processVertices3D(list.iterator(), 2, false);
    }

    public final void polygon2D(Polygon2D polygon2D) {
        this.processVertices2D(polygon2D.vertices.iterator(), 20, true);
    }

    public final void processVertices2D(Iterator<? extends Vec2D> iterator, int n, boolean bl) {
        this.gfx.beginShape(n);
        while (iterator.hasNext()) {
            Vec2D vec2D = iterator.next();
            this.gfx.vertex(vec2D.x, vec2D.y);
        }
        if (bl) {
            this.gfx.endShape(2);
        } else {
            this.gfx.endShape();
        }
    }

    public final void processVertices3D(Iterator<? extends Vec3D> iterator, int n, boolean bl) {
        this.gfx.beginShape(n);
        while (iterator.hasNext()) {
            Vec3D vec3D = iterator.next();
            this.gfx.vertex(vec3D.x, vec3D.y, vec3D.z);
        }
        if (bl) {
            this.gfx.endShape(2);
        } else {
            this.gfx.endShape();
        }
    }

    public final void ray(Ray2D ray2D, float f) {
        Vec2D vec2D = ray2D.getPointAtDistance(f);
        this.gfx.line(ray2D.x, ray2D.y, vec2D.x, vec2D.y);
    }

    public final void ray(Ray3D ray3D, float f) {
        Vec3D vec3D = ray3D.getPointAtDistance(f);
        this.gfx.line(ray3D.x, ray3D.y, ray3D.z, vec3D.x, vec3D.y, vec3D.z);
    }

    public final void rect(Rect rect) {
        switch (this.gfx.rectMode) {
            case 0: {
                this.gfx.rect(rect.x, rect.y, rect.width, rect.height);
                break;
            }
            case 1: {
                this.gfx.rect(rect.x, rect.y, rect.x + rect.width, rect.y + rect.height);
                break;
            }
            case 3: {
                this.gfx.rect(rect.x + rect.width * 0.5f, rect.y + rect.height * 0.5f, rect.width, rect.height);
                break;
            }
            case 2: {
                float f = rect.width * 0.5f;
                float f2 = rect.height * 0.5f;
                this.gfx.rect(rect.x + f, rect.y + f2, f, f2);
                break;
            }
            default: {
                logger.warning("invalid rect mode: " + this.gfx.rectMode);
            }
        }
    }

    public final void rotate(float f, ReadonlyVec3D readonlyVec3D) {
        this.gfx.rotate(f, readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public final void scale(ReadonlyVec2D readonlyVec2D) {
        this.gfx.scale(readonlyVec2D.x(), readonlyVec2D.y());
    }

    public final void scale(ReadonlyVec3D readonlyVec3D) {
        this.gfx.scale(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public final void scale(Vec2D vec2D) {
        this.gfx.scale(vec2D.x, vec2D.y);
    }

    public final void scale(Vec3D vec3D) {
        this.gfx.scale(vec3D.x, vec3D.y, vec3D.z);
    }

    public final void setGraphics(PGraphics pGraphics) {
        this.gfx = pGraphics;
    }

    public final void sphere(Sphere sphere, int n) {
        this.mesh(sphere.toMesh(n));
    }

    public final void sphere(Sphere sphere, int n, boolean bl) {
        this.mesh(sphere.toMesh(n), bl);
    }

    public final void texturedMesh(TriangleMesh triangleMesh, PImage pImage, boolean bl) {
        this.gfx.beginShape(9);
        this.gfx.texture(pImage);
        if (bl) {
            for (Face face : triangleMesh.faces) {
                if (face.uvA != null && face.uvB != null && face.uvC != null) {
                    this.gfx.normal(face.a.normal.x, face.a.normal.y, face.a.normal.z);
                    this.gfx.vertex(face.a.x, face.a.y, face.a.z, face.uvA.x, face.uvA.y);
                    this.gfx.normal(face.b.normal.x, face.b.normal.y, face.b.normal.z);
                    this.gfx.vertex(face.b.x, face.b.y, face.b.z, face.uvB.x, face.uvB.y);
                    this.gfx.normal(face.c.normal.x, face.c.normal.y, face.c.normal.z);
                    this.gfx.vertex(face.c.x, face.c.y, face.c.z, face.uvC.x, face.uvC.y);
                    continue;
                }
                this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                this.gfx.vertex(face.c.x, face.c.y, face.c.z);
            }
        } else {
            for (Face face : triangleMesh.faces) {
                this.gfx.normal(face.normal.x, face.normal.y, face.normal.z);
                if (face.uvA != null && face.uvB != null && face.uvC != null) {
                    this.gfx.vertex(face.a.x, face.a.y, face.a.z, face.uvA.x, face.uvA.y);
                    this.gfx.vertex(face.b.x, face.b.y, face.b.z, face.uvB.x, face.uvB.y);
                    this.gfx.vertex(face.c.x, face.c.y, face.c.z, face.uvC.x, face.uvC.y);
                    continue;
                }
                this.gfx.vertex(face.a.x, face.a.y, face.a.z);
                this.gfx.vertex(face.b.x, face.b.y, face.b.z);
                this.gfx.vertex(face.c.x, face.c.y, face.c.z);
            }
        }
        this.gfx.endShape();
    }

    public final void translate(ReadonlyVec2D readonlyVec2D) {
        this.gfx.translate(readonlyVec2D.x(), readonlyVec2D.y());
    }

    public final void translate(ReadonlyVec3D readonlyVec3D) {
        this.gfx.translate(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public final void translate(Vec2D vec2D) {
        this.gfx.translate(vec2D.x, vec2D.y);
    }

    public final void translate(Vec3D vec3D) {
        this.gfx.translate(vec3D.x, vec3D.y, vec3D.z);
    }

    public final void triangle(Triangle2D triangle2D) {
        this.triangle(triangle2D, true);
    }

    public final void triangle(Triangle2D triangle2D, boolean bl) {
        if (bl) {
            this.gfx.beginShape(9);
        }
        this.gfx.vertex(triangle2D.a.x, triangle2D.a.y);
        this.gfx.vertex(triangle2D.b.x, triangle2D.b.y);
        this.gfx.vertex(triangle2D.c.x, triangle2D.c.y);
        if (bl) {
            this.gfx.endShape();
        }
    }

    public final void triangle(Triangle3D triangle3D) {
        this.triangle(triangle3D, true);
    }

    public final void triangle(Triangle3D triangle3D, boolean bl) {
        if (bl) {
            this.gfx.beginShape(9);
        }
        Vec3D vec3D = triangle3D.computeNormal();
        this.gfx.normal(vec3D.x, vec3D.y, vec3D.z);
        this.gfx.vertex(triangle3D.a.x, triangle3D.a.y, triangle3D.a.z);
        this.gfx.vertex(triangle3D.b.x, triangle3D.b.y, triangle3D.b.z);
        this.gfx.vertex(triangle3D.c.x, triangle3D.c.y, triangle3D.c.z);
        if (bl) {
            this.gfx.endShape();
        }
    }

    public final void vertex(ReadonlyVec2D readonlyVec2D) {
        this.gfx.vertex(readonlyVec2D.x(), readonlyVec2D.y());
    }

    public final void vertex(ReadonlyVec3D readonlyVec3D) {
        this.gfx.vertex(readonlyVec3D.x(), readonlyVec3D.y(), readonlyVec3D.z());
    }

    public final void vertex(Vec2D vec2D) {
        this.gfx.vertex(vec2D.x, vec2D.y);
    }

    public final void vertex(Vec3D vec3D) {
        this.gfx.vertex(vec3D.x, vec3D.y, vec3D.z);
    }
}

