/*
 * Decompiled with CFR 0.152.
 */
package toxi.physics2d;

import java.util.ArrayList;
import java.util.List;
import toxi.geom.ReadonlyVec2D;
import toxi.geom.Rect;
import toxi.geom.Vec2D;
import toxi.physics2d.VerletParticle2D;
import toxi.physics2d.VerletSpring2D;
import toxi.physics2d.behaviors.GravityBehavior;
import toxi.physics2d.behaviors.ParticleBehavior2D;
import toxi.physics2d.constraints.ParticleConstraint2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerletPhysics2D {
    public ArrayList<VerletParticle2D> particles;
    public ArrayList<VerletSpring2D> springs;
    protected float timeStep;
    protected int numIterations;
    protected Rect worldBounds;
    public final List<ParticleBehavior2D> behaviors = new ArrayList<ParticleBehavior2D>(1);
    protected float drag;

    public static void addConstraintToAll(ParticleConstraint2D particleConstraint2D, List<VerletParticle2D> list) {
        for (VerletParticle2D verletParticle2D : list) {
            verletParticle2D.addConstraint(particleConstraint2D);
        }
    }

    public static void removeConstraintFromAll(ParticleConstraint2D particleConstraint2D, List<VerletParticle2D> list) {
        for (VerletParticle2D verletParticle2D : list) {
            verletParticle2D.removeConstraint(particleConstraint2D);
        }
    }

    public VerletPhysics2D() {
        this(null, 50, 0.0f, 1.0f);
    }

    public VerletPhysics2D(Vec2D vec2D, int n, float f, float f2) {
        this.particles = new ArrayList();
        this.springs = new ArrayList();
        if (vec2D != null) {
            this.addBehavior(new GravityBehavior(vec2D));
        }
        this.numIterations = n;
        this.timeStep = f2;
        this.setDrag(f);
    }

    public void addBehavior(ParticleBehavior2D particleBehavior2D) {
        particleBehavior2D.configure(this.timeStep);
        this.behaviors.add(particleBehavior2D);
    }

    public VerletPhysics2D addParticle(VerletParticle2D verletParticle2D) {
        this.particles.add(verletParticle2D);
        return this;
    }

    public VerletPhysics2D addSpring(VerletSpring2D verletSpring2D) {
        if (this.getSpring(verletSpring2D.a, verletSpring2D.b) == null) {
            this.springs.add(verletSpring2D);
        }
        return this;
    }

    public VerletPhysics2D clear() {
        this.particles.clear();
        this.springs.clear();
        return this;
    }

    protected void constrainToBounds() {
        for (VerletParticle2D verletParticle2D : this.particles) {
            if (verletParticle2D.bounds == null) continue;
            verletParticle2D.constrain(verletParticle2D.bounds);
        }
        if (this.worldBounds != null) {
            for (VerletParticle2D verletParticle2D : this.particles) {
                verletParticle2D.constrain(this.worldBounds);
            }
        }
    }

    public Rect getCurrentBounds() {
        Vec2D vec2D = new Vec2D(Float.MAX_VALUE, Float.MAX_VALUE);
        Vec2D vec2D2 = new Vec2D(Float.MIN_VALUE, Float.MIN_VALUE);
        for (VerletParticle2D verletParticle2D : this.particles) {
            vec2D.minSelf((Vec2D)verletParticle2D);
            vec2D2.maxSelf((Vec2D)verletParticle2D);
        }
        return new Rect((ReadonlyVec2D)vec2D, (ReadonlyVec2D)vec2D2);
    }

    public float getDrag() {
        return 1.0f - this.drag;
    }

    public int getNumIterations() {
        return this.numIterations;
    }

    public VerletSpring2D getSpring(Vec2D vec2D, Vec2D vec2D2) {
        for (VerletSpring2D verletSpring2D : this.springs) {
            if ((verletSpring2D.a != vec2D || verletSpring2D.b != vec2D2) && (verletSpring2D.a != vec2D2 || verletSpring2D.b != vec2D)) continue;
            return verletSpring2D;
        }
        return null;
    }

    public float getTimeStep() {
        return this.timeStep;
    }

    public Rect getWorldBounds() {
        return this.worldBounds;
    }

    public boolean removeBehavior(ParticleBehavior2D particleBehavior2D) {
        return this.behaviors.remove(particleBehavior2D);
    }

    public boolean removeParticle(VerletParticle2D verletParticle2D) {
        return this.particles.remove((Object)verletParticle2D);
    }

    public boolean removeSpring(VerletSpring2D verletSpring2D) {
        return this.springs.remove(verletSpring2D);
    }

    public boolean removeSpringElements(VerletSpring2D verletSpring2D) {
        if (this.removeSpring(verletSpring2D)) {
            return this.removeParticle(verletSpring2D.a) && this.removeParticle(verletSpring2D.b);
        }
        return false;
    }

    public void setDrag(float f) {
        this.drag = 1.0f - f;
    }

    public void setNumIterations(int n) {
        this.numIterations = n;
    }

    public void setTimeStep(float f) {
        this.timeStep = f;
        for (ParticleBehavior2D particleBehavior2D : this.behaviors) {
            particleBehavior2D.configure(f);
        }
    }

    public VerletPhysics2D setWorldBounds(Rect rect) {
        this.worldBounds = rect;
        return this;
    }

    public VerletPhysics2D update() {
        this.updateParticles();
        this.updateSprings();
        this.constrainToBounds();
        return this;
    }

    protected void updateParticles() {
        for (ParticleBehavior2D object : this.behaviors) {
            for (VerletParticle2D verletParticle2D : this.particles) {
                object.apply(verletParticle2D);
            }
        }
        for (VerletParticle2D verletParticle2D : this.particles) {
            verletParticle2D.scaleVelocity(this.drag);
            verletParticle2D.update();
        }
    }

    protected void updateSprings() {
        for (int i = this.numIterations; i > 0; --i) {
            for (VerletSpring2D verletSpring2D : this.springs) {
                verletSpring2D.update(i == 1);
            }
        }
    }
}

