/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.ugens;

import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Frequency {
    static float HZA4 = 440.0f;
    static float MIDIA4 = 69.0f;
    static float MIDIOCTAVE = 12.0f;
    private static TreeMap<String, Integer> noteNameOffsets = Frequency.initializeNoteNameOffsets();
    private static String noteNameRegex = Frequency.initializeNoteNameRegex();
    private static String noteNaturalnessRegex = "[#b]";
    private static String noteOctaveRegex = "(-1|10|[0-9])";
    private static String pitchRegex = "^" + noteNameRegex + "?[ ]*" + noteNaturalnessRegex + "*[ ]*" + noteOctaveRegex + "?$";
    private float freq;

    private static TreeMap<String, Integer> initializeNoteNameOffsets() {
        TreeMap<String, Integer> treeMap = new TreeMap<String, Integer>();
        treeMap.put("A", new Integer(9));
        treeMap.put("B", new Integer(11));
        treeMap.put("C", new Integer(0));
        treeMap.put("D", new Integer(2));
        treeMap.put("E", new Integer(4));
        treeMap.put("F", new Integer(5));
        treeMap.put("G", new Integer(7));
        treeMap.put("La", new Integer(9));
        treeMap.put("Si", new Integer(11));
        treeMap.put("Do", new Integer(0));
        treeMap.put("Re", new Integer(2));
        treeMap.put("Mi", new Integer(4));
        treeMap.put("Fa", new Integer(5));
        treeMap.put("Sol", new Integer(7));
        return treeMap;
    }

    private static String initializeNoteNameRegex() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = noteNameOffsets.keySet().iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        String string = "(";
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            string = string + (String)listIterator.previous() + "|";
        }
        string = string.substring(0, string.length() - 1);
        string = string + ")";
        return string;
    }

    private Frequency(float f) {
        this.freq = f;
    }

    public float asHz() {
        return this.freq;
    }

    public void setAsHz(float f) {
        this.freq = f;
    }

    public float asMidiNote() {
        float f = MIDIA4 + MIDIOCTAVE * (float)Math.log(this.freq / HZA4) / (float)Math.log(2.0);
        return f;
    }

    public static Frequency ofHertz(float f) {
        return new Frequency(f);
    }

    public static Frequency ofMidiNote(float f) {
        float f2 = HZA4 * (float)Math.pow(2.0, (f - MIDIA4) / MIDIOCTAVE);
        return new Frequency(f2);
    }

    public static Frequency ofPitch(String string) {
        if ((string = string.trim()).matches(pitchRegex)) {
            float f;
            String string2;
            Minim.debug(string + " matches the pitchRegex.");
            Pattern pattern = Pattern.compile(noteOctaveRegex);
            Matcher matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start(), matcher.end());
                f = Float.valueOf(string2.trim()).floatValue();
            } else {
                f = 4.0f;
            }
            float f2 = f * 12.0f + 12.0f;
            Minim.debug("midiNote based on octave = " + f2);
            pattern = Pattern.compile(noteNaturalnessRegex);
            matcher = pattern.matcher(string);
            while (matcher.find()) {
                string2 = string.substring(matcher.start(), matcher.end());
                if (string2.equals("#")) {
                    f2 += 1.0f;
                    continue;
                }
                f2 -= 1.0f;
            }
            Minim.debug("midiNote based on naturalness = " + f2);
            pattern = Pattern.compile(noteNameRegex);
            matcher = pattern.matcher(string);
            if (matcher.find()) {
                string2 = string.substring(matcher.start(), matcher.end());
                float f3 = noteNameOffsets.get(string2).intValue();
                f2 += f3;
            }
            Minim.debug("midiNote based on noteName = " + f2);
            return new Frequency(Frequency.ofMidiNote(f2).asHz());
        }
        Minim.debug(string + " DOES NOT MATCH.");
        return new Frequency(0.0f);
    }
}

