/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import java.util.ArrayList;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PShape;

public class demo
extends PApplet {
    int CANVAS_WIDTH = 1920;
    int CANVAS_HEIGHT = 1080;
    int SONG_SKIP_MILLISECONDS = 2000;
    float ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
    Minim minim;
    AudioPlayer song;
    Moonlander moonlander;
    ArrayList<Ball> balls;
    float ellipseSize = 0.0f;
    PFont ps2p;
    PShape turtle;
    ArrayList<FallingTurtle> turtles;
    WavyText wt;
    boolean greezShowed;

    public void setupAudio() {
        this.minim = new Minim((Object)this);
        this.song = this.minim.loadFile("../common/Graffathon.mp3");
    }

    public void setup() {
        this.size(this.displayWidth, this.displayHeight, "processing.opengl.PGraphics2D");
        this.CANVAS_WIDTH = this.displayWidth;
        this.CANVAS_HEIGHT = this.displayHeight;
        this.ASPECT_RATIO = (float)this.CANVAS_WIDTH / (float)this.CANVAS_HEIGHT;
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"../common/Graffathon.mp3", (int)150, (int)8);
        this.frameRate(60.0f);
        this.noStroke();
        this.fill(255);
        this.smooth();
        this.balls = new ArrayList();
        this.ps2p = this.loadFont("../common/PressStart2P-Regular-48.vlw");
        this.textFont(this.ps2p, 32.0f);
        this.turtle = this.loadShape("../common/turtle_animal_lemmling.svg");
        this.turtles = new ArrayList();
        this.wt = new WavyText();
        this.setupAudio();
        this.moonlander.start();
    }

    public void drawDemo(int n) {
        if (n < 39000) {
            this.ballsScene(n);
        } else {
            this.roadScene(n);
        }
    }

    public void ballsScene(int n) {
        this.pushMatrix();
        this.resetMatrix();
        this.text("Univaje", demo.map((float)0.0f, (float)(-this.ASPECT_RATIO), (float)this.ASPECT_RATIO, (float)0.0f, (float)this.CANVAS_WIDTH), demo.map((float)0.0f, (float)-1.0f, (float)1.0f, (float)0.0f, (float)this.CANVAS_HEIGHT));
        this.popMatrix();
        int n2 = this.moonlander.getIntValue("red");
        int n3 = this.moonlander.getIntValue("green");
        int n4 = this.moonlander.getIntValue("blue");
        this.ellipseMode(3);
        this.fill(n2, n3, n4);
        this.balls.add(new Ball(this.random(-this.ASPECT_RATIO, this.ASPECT_RATIO), this.random(0.0f, 1.0f), this.ASPECT_RATIO, 0.1f));
        for (Ball ball : this.balls) {
            ball.run();
        }
        if (this.balls.size() >= 1000) {
            this.balls.remove(0);
        }
        if (n > 35000) {
            this.ellipseSize += 0.05f;
            this.ellipse(0.0f, 0.0f, this.ellipseSize * this.ASPECT_RATIO, this.ellipseSize);
        }
    }

    public void roadScene(int n) {
        this.sky(this.color(0, 0, 255), this.color(0));
        this.bg();
        this.road();
        this.turtles();
        this.pushMatrix();
        this.resetMatrix();
        this.text("UnknownPotato", demo.map((float)(-this.ASPECT_RATIO), (float)(-this.ASPECT_RATIO), (float)this.ASPECT_RATIO, (float)0.0f, (float)this.CANVAS_WIDTH), demo.map((float)0.9f, (float)-1.0f, (float)1.0f, (float)this.CANVAS_HEIGHT, (float)0.0f));
        this.text("Music and sync: VoxWave", demo.map((float)(-this.ASPECT_RATIO), (float)(-this.ASPECT_RATIO), (float)this.ASPECT_RATIO, (float)0.0f, (float)this.CANVAS_WIDTH), demo.map((float)0.0f, (float)-1.0f, (float)1.0f, (float)this.CANVAS_HEIGHT, (float)0.0f));
        this.text("Code: Serdion, a544jh", demo.map((float)(-this.ASPECT_RATIO), (float)(-this.ASPECT_RATIO), (float)this.ASPECT_RATIO, (float)0.0f, (float)this.CANVAS_WIDTH), demo.map((float)-0.1f, (float)-1.0f, (float)1.0f, (float)this.CANVAS_HEIGHT, (float)0.0f));
        this.popMatrix();
        if (!this.greezShowed) {
            this.wt.displayText("UnknownPotato would like to greet these people and groups in random order: BJAKKE  LAKO  DOT  firebug  sooda  Ihan sama, joo  msqrt  Future Crew  ASD  Kewlers  Bisqwit  lft  Delma  Letixari  EKK", -0.6f, -0.39f);
            this.greezShowed = true;
        }
        this.wt.run();
    }

    public void road() {
        float f = 0.03f;
        float f2 = 0.1f;
        float f3 = 0.03f;
        float f4 = -0.5f;
        float f5 = 0.0017f * (float)this.millis();
        float f6 = 2.0f * (f2 + f) / (float)Math.PI * demo.atan((float)(1.0f / demo.tan((float)(f5 * (float)Math.PI)))) + 2.0f * (f2 + f);
        this.pushMatrix();
        this.translate(-this.ASPECT_RATIO - f6, 0.0f);
        this.fill(255);
        int n = 1;
        while (n < 31) {
            this.rect(f2 * (float)n + f * (float)n, f4, f2, f3);
            ++n;
        }
        this.popMatrix();
    }

    public void sky(int n, int n2) {
        float f = 0.0f;
        float f2 = 1.0f;
        while (f2 >= f) {
            this.stroke(this.lerpColor(n, n2, demo.norm((float)f2, (float)1.0f, (float)f)));
            this.line(-this.ASPECT_RATIO, f2, this.ASPECT_RATIO, f2);
            f2 -= 0.01f;
        }
    }

    public void bg() {
        this.noStroke();
        this.fill(86.0f, 173.0f, 35.0f);
        this.rect(-this.ASPECT_RATIO, 0.0f, 2.0f * this.ASPECT_RATIO, -1.0f);
        this.fill(151);
        this.rect(-this.ASPECT_RATIO, -0.33f, 2.0f * this.ASPECT_RATIO, -0.3f);
    }

    public void turtles() {
        if (this.millis() % 10 == 0) {
            this.turtles.add(new FallingTurtle(this.random(-this.ASPECT_RATIO, this.ASPECT_RATIO), 0.9f, this.random(-0.1f, 0.1f), this.random(-0.1f, 0.0f), this.random(0.0f, (float)Math.PI * 2), this.random(-0.1f, 0.1f)));
        }
        for (FallingTurtle fallingTurtle : this.turtles) {
            fallingTurtle.run();
        }
        if (this.turtles.size() > 50) {
            this.turtles.remove(0);
        }
    }

    public void drawAxes() {
        this.stroke(255);
        this.strokeWeight(0.004f);
        this.fill(255);
        this.line(-this.ASPECT_RATIO, 0.0f, this.ASPECT_RATIO, 0.0f);
        this.pushMatrix();
        this.resetMatrix();
        this.text(String.format("%.3f", Float.valueOf(-this.ASPECT_RATIO)), 12.0f, this.CANVAS_HEIGHT / 2);
        this.text(String.format("%.3f", Float.valueOf(this.ASPECT_RATIO)), this.CANVAS_WIDTH - 42, this.CANVAS_HEIGHT / 2);
        this.popMatrix();
        this.line(0.0f, -1.0f, 0.0f, 1.0f);
        this.pushMatrix();
        this.resetMatrix();
        this.text("1", this.CANVAS_WIDTH / 2 + 12, 12.0f);
        this.text("-1", this.CANVAS_WIDTH / 2 + 12, this.CANVAS_HEIGHT - 12);
        this.popMatrix();
    }

    public void draw() {
        this.clear();
        this.resetMatrix();
        this.moonlander.update();
        this.translate((float)this.CANVAS_WIDTH / 2.0f, (float)this.CANVAS_HEIGHT / 2.0f);
        this.scale((float)this.CANVAS_WIDTH / 2.0f / this.ASPECT_RATIO, (float)(-this.CANVAS_HEIGHT) / 2.0f);
        this.clear();
        this.drawDemo(this.millis());
    }

    public void keyPressed() {
        if (this.key == '\uffff') {
            if (this.keyCode == 37) {
                this.song.skip(-this.SONG_SKIP_MILLISECONDS);
            } else if (this.keyCode == 39) {
                this.song.skip(this.SONG_SKIP_MILLISECONDS);
            }
        } else if (this.key == ' ') {
            if (this.song.isPlaying()) {
                this.song.pause();
            } else {
                this.song.play();
            }
        } else if (this.key == '\n') {
            demo.print((String)(String.valueOf(this.song.position()) + ", "));
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "demo"};
        if (stringArray != null) {
            PApplet.main((String[])demo.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Ball {
        float x;
        float y;
        float speedX;
        float speedY;
        float aspectratio;
        float size;

        Ball(float f, float f2, float f3, float f4) {
            this.speedX = demo.this.random(-0.01f, 0.01f);
            this.speedY = 0.002f;
            this.x = f;
            this.y = f2;
            this.aspectratio = f3;
            this.size = f4;
        }

        public void run() {
            this.display();
            this.move();
            this.bounce();
            this.gravity();
        }

        public void display() {
            demo.this.ellipse(this.x, this.y, this.size, this.size);
        }

        public void move() {
            this.x += this.speedX;
            this.y += this.speedY;
        }

        public void bounce() {
            if (this.x + this.size / 2.0f >= this.aspectratio || this.x - this.size / 2.0f <= -this.aspectratio) {
                this.speedX = -this.speedX;
            }
            if (this.y - this.size / 2.0f <= -1.0f) {
                this.speedY = Math.abs(this.speedY);
            }
        }

        public void gravity() {
            this.speedY -= 0.001f;
        }
    }

    class FallingTurtle {
        float x;
        float y;
        float vx;
        float vy;
        float rot;
        float vrot;

        FallingTurtle(float f, float f2, float f3, float f4, float f5, float f6) {
            this.x = f;
            this.y = f2;
            this.vx = f3;
            this.vy = f4;
            this.rot = f5;
            this.vrot = f6;
        }

        public void display() {
            demo.this.pushMatrix();
            demo.this.rotate(this.rot);
            demo.this.shape(demo.this.turtle, this.x, this.y, 0.6f, 0.6f);
            demo.this.popMatrix();
        }

        public void run() {
            this.display();
            this.x += this.vx;
            this.y += this.vy;
            this.rot += this.vrot;
        }
    }

    class Letter {
        char c;
        float x;
        float y;
        float ymin;
        float ymax;
        int col1;
        int col2;

        Letter(char c, float f, float f2) {
            this.x = demo.this.ASPECT_RATIO;
            this.y = 0.0f;
            this.col1 = demo.this.color(255, 255, 0);
            this.col2 = demo.this.color(0, 149, 255);
            this.c = c;
            this.ymin = f;
            this.ymax = f2;
        }

        public void display() {
            demo.this.pushMatrix();
            demo.this.resetMatrix();
            demo.this.fill(demo.this.lerpColor(this.col1, this.col2, demo.sin((float)(this.x * 2.0f - (float)demo.this.frameCount * 0.1f))));
            demo.this.text(this.c, demo.map((float)this.x, (float)(-demo.this.ASPECT_RATIO), (float)demo.this.ASPECT_RATIO, (float)0.0f, (float)demo.this.CANVAS_WIDTH), demo.map((float)this.y, (float)-1.0f, (float)1.0f, (float)0.0f, (float)demo.this.CANVAS_HEIGHT));
            demo.this.popMatrix();
        }

        public void run() {
            this.x -= 0.04f;
            this.y = -demo.map((float)demo.sin((float)(this.x * 10.0f)), (float)-1.0f, (float)1.0f, (float)this.ymin, (float)this.ymax);
            this.display();
        }
    }

    class WavyText {
        ArrayList<Letter> letters = new ArrayList();
        ArrayList<Letter> emitted = new ArrayList();
        boolean remove = false;

        WavyText() {
        }

        public void displayText(String string, float f, float f2) {
            int n = 0;
            while (n < string.length()) {
                this.letters.add(new Letter(string.charAt(n), f, f2));
                ++n;
            }
        }

        public void emitNext() {
            if (!this.letters.isEmpty()) {
                this.emitted.add(this.letters.remove(0));
            }
        }

        public void run() {
            if (demo.this.frameCount % 4 == 0) {
                this.emitNext();
            }
            for (Letter letter : this.emitted) {
                letter.run();
                if (!(letter.x < -demo.this.ASPECT_RATIO)) continue;
                this.remove = true;
            }
            if (this.remove) {
                this.emitted.remove(0);
                this.remove = false;
            }
        }
    }
}

