define(["three", "skySphere", "objects", "camera", "tween", "random", "util"],
    function(THREE, skySphere, objects, camera, tween, random, util) {
        var scene = new THREE.Scene();
        var hats = new Array();
        var spotLight = null;
        var sceneTime = 0;
        var moveEverything = 10;
        var text = null;

        scene.init = function() {
            var hemiLight = new THREE.HemisphereLight(0xaaaaaa, 0x666666, 0.2);

            spotLight = new THREE.SpotLight(0xFFFFFF, 0.8);
            spotLight.position.set(0, 10, 100);

            spotLight.castShadow = true;

            spotLight.shadowMapWidth = 1024;
            spotLight.shadowMapHeight = 1024;

            spotLight.shadowCameraNear = 500;
            spotLight.shadowCameraFar = 4000;
            spotLight.shadowCameraFov = 30;

            text = objects.introPlane.clone();
            text.position.x = moveEverything;
            text.scale.multiplyScalar(0.5);

            scene.add(spotLight);
            scene.add(hemiLight);
            scene.add(skySphere.clone());
            scene.add(text);
        }

        scene.enter = function() {
            camera.position.set(0, 0, 30);
            sceneTime = 0;
        }

        var hatStep = 1;
        var radius = 7;
        var hatScales = new Array();
        var newEffect = false;

        scene.addHat = function() {
            var hat = objects.hat.clone();
            hat.scale.set(0.01, 0.01, 0.01);
            hat.position.set(Math.sin(hats.length) * radius - moveEverything, hatStep * hats.length, Math.cos(hats.length) * radius);
            hats.push(hat);

            var rand = new random(hats.length);
            hatScales.push(1);
            scene.add(hat);
        }


        var timeShit = 0.48;
        var timeSinceLastSpawn = 0;
        var timeWhenHatSpawns = 0.1;
        scene.update = function(t, dt) {
            sceneTime += dt;
            if (t > timeSinceLastSpawn + timeWhenHatSpawns) {
                scene.addHat();
                timeSinceLastSpawn = t;
            }

            camera.position.y += 10 * dt * timeShit;
            text.position.y += 5 * dt * timeShit;
            spotLight.position.setY(spotLight.position.y + 20 * dt * timeShit);

            for (var i = 0; i < hats.length; ++i) {                
                var start = util.beatsToTime(130, {bars: 4, beats: 0, eights: 0});
                var end = start + 0.5;
                if(sceneTime >= start && sceneTime <= end)
                {             
                    newEffect = true;   
                    this.fadeAmount = (end - sceneTime) / (end - start);
                }
                else
                {
                    this.fadeAmount = 0;
                }

                if(newEffect)
                {
                    hats[i].position.x += Math.sin(i+t+2*Math.PI)*0.1;
                    hats[i].position.z += Math.sin(i+t+2*Math.PI)*0.1;
                }

                if (hats[i].scale.x > hatScales[i]) {
                    continue;
                }

                hats[i].rotation.set(hats[i].rotation.x + timeShit * dt * Math.PI * 2, 0, 0);
                hats[i].scale.addScalar(timeShit * dt);
            }
        }

        return scene;
    });
