define(["three", "camera", "renderer", "musicManager", "fadePass"],
    function(THREE, camera, renderer, musicManager, FadePass) {
        var SceneManager = {
            scene: undefined,
            lastTimestamp: 0,
            composer: undefined,
            fadePass: undefined,

            animate: function(t) {
                window.requestAnimationFrame(SceneManager.animate);

                var time = musicManager.update();
                var scene = SceneManager.scene;

                scene.update(time, time - SceneManager.lastTimestamp);
                SceneManager.lastTimestamp = time;

                if(scene.fadeAmount !== undefined)
                    fadePass.amount = scene.fadeAmount;
                if(scene.fadeColor !== undefined)
                    fadePass.color = scene.fadeColor;

                renderer.clear();
                renderer.autoClear = false;
                composer.render();
            },

            setScene: function(scene) {
                this.scene = scene;
                scene.enter();
                this.initPostProcessing(scene);
            },

            initPostProcessing: function(scene) {
                composer = new THREE.EffectComposer(renderer);
                renderModel = new THREE.RenderPass(scene, camera);

                var copyPass = new THREE.ShaderPass(THREE.CopyShader);
                copyPass.renderToScreen = true;

                var effectDotScreen = new THREE.BloomPass(0.7, 25, 7, 512);
                effectDotScreen.renderToScreen = false;

                fadePass = new FadePass();

                composer.addPass(renderModel);
                composer.addPass(effectDotScreen);                         
                composer.addPass(fadePass);                
                composer.addPass(copyPass);
            }
        };

        return SceneManager;
    });
