/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XOMOrientation
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return XlibWrapper.dataModel == 32 ? 8 : 16;
    }

    @Override
    public int getDataSize() {
        return XOMOrientation.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XOMOrientation(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XOMOrientation() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XOMOrientation.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_num_orientation() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_num_orientation(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public int get_orientation(int n) {
        log.finest("");
        return Native.getInt(Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8)) + (long)(n * 4));
    }

    public long get_orientation() {
        log.finest("");
        return Native.getLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8));
    }

    public void set_orientation(long l) {
        log.finest("");
        Native.putLong(this.pData + (long)(XlibWrapper.dataModel == 32 ? 4 : 8), l);
    }

    @Override
    String getName() {
        return "XOMOrientation";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("num_orientation = ").append(this.get_num_orientation()).append(", ");
        stringBuilder.append("orientation = ").append(this.get_orientation()).append(", ");
        return stringBuilder.toString();
    }
}

