/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.plaf.FontUIResource;
import sun.awt.FontConfiguration;
import sun.awt.HeadlessToolkit;
import sun.font.CFont;
import sun.font.CFontConfiguration;
import sun.font.CreatedFontTracker;
import sun.font.FileFont;
import sun.font.Font2D;
import sun.font.FontConfigManager;
import sun.font.FontFamily;
import sun.font.FontManager;
import sun.font.FontUtilities;
import sun.font.NativeFont;
import sun.font.SunFontManager;
import sun.font.TrueTypeFont;
import sun.font.Type1Font;
import sun.lwawt.macosx.LWCToolkit;

public class CFontManager
extends SunFontManager {
    private FontConfigManager fcManager = null;
    private static Hashtable<String, Font2D> genericFonts = new Hashtable();
    private static String[] defaultPlatformFont = null;
    Object waitForFontsToBeLoaded = new Object();

    @Override
    protected FontConfiguration createFontConfiguration() {
        CFontConfiguration cFontConfiguration = new CFontConfiguration(this);
        cFontConfiguration.init();
        return cFontConfiguration;
    }

    @Override
    public FontConfiguration createFontConfiguration(boolean bl, boolean bl2) {
        return new CFontConfiguration(this, bl, bl2);
    }

    @Override
    public synchronized String[] getDefaultPlatformFont() {
        if (defaultPlatformFont == null) {
            defaultPlatformFont = new String[2];
            CFontManager.defaultPlatformFont[0] = "Lucida Grande";
            CFontManager.defaultPlatformFont[1] = "/System/Library/Fonts/LucidaGrande.ttc";
        }
        return defaultPlatformFont;
    }

    public static Font2D[] getGenericFonts() {
        return genericFonts.values().toArray(new Font2D[0]);
    }

    public Font2D registerGenericFont(Font2D font2D) {
        return this.registerGenericFont(font2D, false);
    }

    public Font2D registerGenericFont(Font2D font2D, boolean bl) {
        int n = 4;
        String string = font2D.fullName;
        String string2 = font2D.familyName;
        if (string == null || "".equals(string)) {
            return null;
        }
        if (bl || !genericFonts.containsKey(string)) {
            FontFamily fontFamily;
            if (FontUtilities.debugFonts()) {
                FontUtilities.getLogger().info("Add to Family " + string2 + ", Font " + string + " rank=" + n);
            }
            if ((fontFamily = FontFamily.getFamily(string2)) == null) {
                fontFamily = new FontFamily(string2, false, n);
                fontFamily.setFont(font2D, font2D.style);
            } else if (fontFamily.getRank() >= n) {
                fontFamily.setFont(font2D, font2D.style);
            }
            if (!bl) {
                genericFonts.put(string, font2D);
                this.fullNameToFont.put(string.toLowerCase(Locale.ENGLISH), font2D);
            }
            return font2D;
        }
        return genericFonts.get(string);
    }

    @Override
    public Font2D[] getRegisteredFonts() {
        Font2D[] font2DArray = super.getRegisteredFonts();
        Font2D[] font2DArray2 = CFontManager.getGenericFonts();
        Font2D[] font2DArray3 = new Font2D[font2DArray.length + font2DArray2.length];
        System.arraycopy(font2DArray, 0, font2DArray3, 0, font2DArray.length);
        System.arraycopy(font2DArray2, 0, font2DArray3, font2DArray.length, font2DArray2.length);
        return font2DArray3;
    }

    @Override
    protected void addNativeFontFamilyNames(TreeMap<String, String> treeMap, Locale locale) {
        Font2D[] font2DArray = CFontManager.getGenericFonts();
        for (int i = 0; i < font2DArray.length; ++i) {
            if (font2DArray[i] instanceof NativeFont) continue;
            String string = font2DArray[i].getFamilyName(locale);
            treeMap.put(string.toLowerCase(locale), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Font2D createFont2D(File file, int n, boolean bl, CreatedFontTracker createdFontTracker) throws FontFormatException {
        String string = file.getPath();
        FileFont fileFont = null;
        final File file2 = file;
        final CreatedFontTracker createdFontTracker2 = createdFontTracker;
        try {
            switch (n) {
                case 0: {
                    fileFont = new TrueTypeFont(string, null, 0, true);
                    break;
                }
                case 1: {
                    fileFont = new Type1Font(string, null, bl);
                    break;
                }
                default: {
                    throw new FontFormatException("Unrecognised Font Format");
                }
            }
        }
        catch (FontFormatException fontFormatException) {
            if (!bl) throw fontFormatException;
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    if (createdFontTracker2 != null) {
                        createdFontTracker2.subBytes((int)file2.length());
                    }
                    file2.delete();
                    return null;
                }
            });
            throw fontFormatException;
        }
        if (!bl) return fileFont;
        FileFont.setFileToRemove(fileFont, file, createdFontTracker);
        Class<FontManager> clazz = FontManager.class;
        synchronized (FontManager.class) {
            if (this.tmpFontFiles == null) {
                this.tmpFontFiles = new Vector();
            }
            this.tmpFontFiles.add(file);
            if (this.fileCloser != null) return fileFont;
            final Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            for (int i = 0; i < 20; ++i) {
                                if (CFontManager.this.fontFileCache[i] == null) continue;
                                try {
                                    CFontManager.this.fontFileCache[i].close();
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            if (CFontManager.this.tmpFontFiles != null) {
                                File[] fileArray = new File[CFontManager.this.tmpFontFiles.size()];
                                fileArray = CFontManager.this.tmpFontFiles.toArray(fileArray);
                                for (int i = 0; i < fileArray.length; ++i) {
                                    try {
                                        fileArray[i].delete();
                                        continue;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            return null;
                        }
                    });
                }
            };
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = threadGroup = Thread.currentThread().getThreadGroup();
                    while (threadGroup2 != null) {
                        threadGroup = threadGroup2;
                        threadGroup2 = threadGroup.getParent();
                    }
                    CFontManager.this.fileCloser = new Thread(threadGroup, runnable);
                    CFontManager.this.fileCloser.setContextClassLoader(null);
                    Runtime.getRuntime().addShutdownHook(CFontManager.this.fileCloser);
                    return null;
                }
            });
            // ** MonitorExit[var9_10] (shouldn't be in output)
            return fileFont;
        }
    }

    @Override
    protected void registerFontsInDir(String string, boolean bl, int n, boolean bl2, boolean bl3) {
        this.loadNativeDirFonts(string);
        super.registerFontsInDir(string, bl, n, bl2, bl3);
    }

    private native void loadNativeDirFonts(String var1);

    private native void loadNativeFonts();

    void registerFont(String string, String string2) {
        CFont cFont = new CFont(string, string2);
        this.registerGenericFont(cFont);
        if ((cFont.getStyle() & 2) == 0) {
            this.registerGenericFont(cFont.createItalicVariant(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadFonts() {
        Object object = this.waitForFontsToBeLoaded;
        synchronized (object) {
            super.loadFonts();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    CFontManager.this.loadNativeFonts();
                    return null;
                }
            });
            String string = "Lucida Grande";
            String string2 = "Lucida Sans";
            this.setupLogicalFonts("Dialog", string, string2);
            this.setupLogicalFonts("Serif", "Times", "Lucida Bright");
            this.setupLogicalFonts("SansSerif", string, string2);
            this.setupLogicalFonts("Monospaced", "Menlo", "Lucida Sans Typewriter");
            this.setupLogicalFonts("DialogInput", string, string2);
        }
    }

    protected void setupLogicalFonts(String string, String string2, String string3) {
        FontFamily fontFamily = this.getFontFamilyWithExtraTry(string, string2, string3);
        this.cloneStyledFont(fontFamily, string, 0);
        this.cloneStyledFont(fontFamily, string, 1);
        this.cloneStyledFont(fontFamily, string, 2);
        this.cloneStyledFont(fontFamily, string, 3);
    }

    protected FontFamily getFontFamilyWithExtraTry(String string, String string2, String string3) {
        FontFamily fontFamily = this.getFontFamily(string2, string3);
        if (fontFamily != null) {
            return fontFamily;
        }
        super.loadFonts();
        fontFamily = this.getFontFamily(string2, string3);
        if (fontFamily != null) {
            return fontFamily;
        }
        System.err.println("Warning: the fonts \"" + string2 + "\" and \"" + string3 + "\" are not available for the Java logical font \"" + string + "\", which may have unexpected appearance or behavior. Re-enable the \"" + string2 + "\" font to remove this warning.");
        return null;
    }

    protected FontFamily getFontFamily(String string, String string2) {
        FontFamily fontFamily = FontFamily.getFamily(string);
        if (fontFamily != null) {
            return fontFamily;
        }
        fontFamily = FontFamily.getFamily(string2);
        if (fontFamily != null) {
            System.err.println("Warning: the font \"" + string + "\" is not available, so \"" + string2 + "\" has been substituted, but may have unexpected appearance or behavor. Re-enable the \"" + string + "\" font to remove this warning.");
            return fontFamily;
        }
        return null;
    }

    protected boolean cloneStyledFont(FontFamily fontFamily, String string, int n) {
        if (fontFamily == null) {
            return false;
        }
        Font2D font2D = fontFamily.getFontWithExactStyleMatch(n);
        if (font2D == null || !(font2D instanceof CFont)) {
            return false;
        }
        CFont cFont = new CFont((CFont)font2D, string);
        this.registerGenericFont(cFont, true);
        return true;
    }

    @Override
    public String getFontPath(boolean bl) {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit instanceof HeadlessToolkit) {
            toolkit = ((HeadlessToolkit)toolkit).getUnderlyingToolkit();
        }
        if (toolkit instanceof LWCToolkit) {
            return "";
        }
        return "/Library/Fonts";
    }

    @Override
    protected FontUIResource getFontConfigFUIR(String string, int n, int n2) {
        String string2 = FontUtilities.mapFcName(string);
        if (string2 == null) {
            string2 = "sansserif";
        }
        return new FontUIResource(string2, n, n2);
    }

    @Override
    protected void populateFontFileNameMap(HashMap<String, String> hashMap, HashMap<String, String> hashMap2, HashMap<String, ArrayList<String>> hashMap3, Locale locale) {
    }
}

