

layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 parms;

in vec3 ws_norm;
in vec3 ws_lightvec;
in vec2 uv0;

//remaps interval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}
//note: more code stolen from IQ... there should be a group for us poor bastards.
float hash( float n )
{
	return fract(sin(n)*43758.5453);
}

void main()
{
	float n_dot_l = 0.25 + 0.75 * dot( normalize(ws_norm), normalize(ws_lightvec) );

	const vec3 diffcol = vec3(0.25);

	float t = remap( parms.y, 0.1, 0.01 );
	float noiset = remap( t, 0, 0.5 );
	float brokeanim = 0.5 + 0.5 * t + 0.5 * t * hash( parms.y );
	vec3 lettercol = brokeanim * vec3(0.5 + 0.5 * parms.x*parms.x);
	vec3 framecol = diffcol * n_dot_l;

	bool isLetter = uv0.x < 0;
	vec3 col = isLetter ? lettercol : framecol;
	outcol0 = vec4( col, 1 );
}
