

layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 time_s;
uniform vec4 parms;

in vec2 texcoord0_nm;

float sat( float a ) {
	return clamp( a, 0.0f, 1.0f );
}
vec3 sat( vec3 t )
{
	return clamp( t, 0, 1 );
}

//remaps inteval [a;b] to [0;1]
float remap  ( float t, float a, float b )
{
	return sat( (t - a) / (b - a) );
}


//note: [0;1]
vec3 nrand3( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* vec3(43758.5453, 28001.8384, 50849.4141) );
}

void main( void )
{
	outcol0 = texture( tex0, texcoord0_nm );

	vec2 uv = texcoord0_nm.xy - vec2(0.5);
	
	const vec3 gc0 = vec3(104,79,255)/255.0f;
		
	//note: angel overlay
	float s0 = 1 + 0.25 * sin( 89 * uv.x + 1.1*time_s.y - 1.89*time_s.x );
	float s1 = 1 + 0.25 * sin( 97 * uv.x - 1.3*time_s.y + 1.13*time_s.x );
	float s2 = 0.5 + 0.5 * sin ( sin( 17 * uv.x - 2 * time_s.y + 1.07*time_s.x ) * cos ( 3 * uv.x + time_s.y - 1.71*time_s.x ) );
	float s0_h = pow ( remap( uv.y, -0.2, 0.5), 3 );
	float s1_h = pow ( remap( uv.y, -0.5, 0.5), 1.75 );
	float s2_h = pow ( remap( uv.y, -0.45, 0.5), 2 );
	vec3 aits = vec3( 0.3 * (s0_h*s0 + s1_h*s1) + s2_h*s2 );
	//aits = sat( aits );
	float lits = smoothstep( 0, 1, 1-abs(uv.x-parms.z) );
	aits *= lits;

	//screen
	outcol0.rgb = mix( outcol0.rgb, 1-(1-parms.y*gc0*vec3(aits))*(1-outcol0.rgb), 0.25 );

	//color dodge
	outcol0.rgb = mix ( outcol0.rgb, outcol0.rgb / (1.0f-parms.y*sat(aits)), 0.35 );
	
	//debug
	//outcol0.rgb = parms.y * vec3( aits );
	
	outcol0.rgb += nrand3( texcoord0_nm.xy + fract( time_s.x + 0.69472 ) ) / 255.0;
}
