
layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;
uniform vec4 time_s;

in vec2 texcoord0_nm;


float nrand( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
float srand( vec2 n )
{
	return nrand(n)*2-1;
}

//remaps interval [a;b] to [0;1]
float remap( float t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}
vec3 remap( vec3 t, float a, float b ) {
	return clamp( (t - a) / (b - a), 0, 1 );
}

void main()
{
	vec4 sample_col = texture( tex0, texcoord0_nm );
	outcol0 = sample_col;
	vec2 uv = texcoord0_nm;

	//note: mirror in ctr
	uv = -0.25*(uv-0.5)+0.5;

	const float max_dist_nm = 0.1;
	const int num_steps = 10;
	const float num_steps_f = float(num_steps);
	vec2 ctrvec = vec2(0.5)-uv;
	float ctrvec_len = length( ctrvec );
	ctrvec /= ctrvec_len;

	float dist_nm = min( max_dist_nm, ctrvec_len );
	vec2 stepvec = dist_nm * ctrvec / num_steps_f;

	float rnd = nrand(gl_FragCoord.xy+vec2(fract(time_s.x)));

	vec2 suv;
	suv = uv;
	suv -= 0.5 * dist_nm * stepvec;
	suv += rnd * stepvec;

	float d = rnd;
	vec3 s0 = vec3(0);
	for( int i=0; i<num_steps; ++i ) {
		s0 += remap(texture( tex0, suv ).rgb, 0.5, 1 );
		suv += stepvec;
	}
	s0 /= num_steps_f;

	//desat
	s0 = mix( s0, vec3(dot(s0,vec3(0.3333))), 0.25 );

	//intensity
	//s0 *= 0.5;

	outcol0.rgb += s0.rgb;
}
