layout(location = 0, index = 0) out vec4 outcol0;

uniform sampler2D tex0;

uniform vec4 hsl_adjust;

in vec2 texcoord0_nm;


float atan2(float x, float y )
{
	return atan( x, y );
}

float sat( float v )
{
	return clamp( v, 0, 1 );
}

vec3 rgb2hsl( const vec3 in_rgb )
{
	float u = (2.0f*in_rgb.r - in_rgb.g - in_rgb.b)    / 3.0f;
	float v = ( -in_rgb.r + 2.0f* in_rgb.g - in_rgb.b) / 3.0f;

	vec3 out_hsl;
	out_hsl.y = sqrt(u*u + v*v);
	out_hsl.x = (out_hsl.y>0) ? atan2(u,v) : 0.0f;
	out_hsl.z = dot( vec3(0.333333f), in_rgb);

	return out_hsl;
}

vec3 hsl2rgb( vec3 in_hsl )
{
	float u = in_hsl.y * sin(in_hsl.x);
	float v = in_hsl.y * cos(in_hsl.x);

	vec3 out_rgb;
	out_rgb.r = in_hsl.z + u;
	out_rgb.g = in_hsl.z + v;
	out_rgb.b = sat( in_hsl.z - u - v );

	return out_rgb;
}
vec3 ensure_rgb_validity( vec3 in_hsb ) {
//	//TODO: make sure S is inside valid limits... necessary if correction goes beyond borders of
//	//      (happens in both sat-change and regular its-change) - might also want to clamp intensity
//	//      would probably be best to find "closest rgb-valid point in ihs-space" by adjusting intensity also...
	in_hsb.y = clamp( in_hsb.y, 0, in_hsb.z );

	const float M_TAU = 6.2830f;
	if(in_hsb.x > M_TAU ) in_hsb.x -= M_TAU;
	if(in_hsb.x < 0 )     in_hsb.x += M_TAU;

	return in_hsb;
}

void main()
{
	vec4 sample_col = texture( tex0, texcoord0_nm );

	vec3 hsl = rgb2hsl( sample_col.rgb );
	hsl.x += hsl_adjust.x;
	hsl.y *= hsl_adjust.y;

	//hsl = ensure_rgb_validity( hsl );
	vec3 rgb = hsl2rgb( hsl );

	outcol0 = vec4( rgb, sample_col.a );
}
