

layout(location = 0, index = 0) out vec4 outcol;

uniform sampler2D tex0;

uniform vec4 levels_inout;
uniform vec4 gamma;
uniform vec4 time_s;

in vec2 texcoord0_nm;

vec3 nrand3( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* vec3(43758.5453, 28001.8384, 50849.4141) );
}

void main()
{
	vec4 sample_col = texture( tex0, texcoord0_nm );

	vec3 inBlack  = levels_inout.xxx;
	vec3 inWhite  = levels_inout.yyy;
	vec3 gamma    = gamma.xxx;
	vec3 outBlack = levels_inout.zzz;
	vec3 outWhite = levels_inout.www;

	//note: sakset fra gpu-gems1, s.364
	//TODO: fjern normaliseringer - de er der kun for at matche vrdier fra ps
	outcol.rgb = ( pow( max(vec3(0,0,0),(sample_col.rgb * vec3(255.0f)) - inBlack) / (inWhite-inBlack), gamma) * (outWhite-outBlack) + outBlack) / vec3(255.0f);
	outcol.a = sample_col.a;

	outcol.rgb -= nrand3( texcoord0_nm + fract(0.1*time_s.xx) ) / 255.0;
}
