
layout(location = 0, index = 0) out vec4 outcol0;

//uniform vec4 time_s;

uniform vec4 ks_planeeq0;
uniform vec4 ks_planeeq1;
uniform vec4 ks_planeeq2;
uniform vec4 parms;

in vec3 v2f_os_pos;
in vec3 ks_pos;
in vec3 ws_pos;
in vec2 uv0;

float sat( float a ) {
	return clamp( a, 0.0f, 1.0f );
}


//[0;1]
float rand( vec2 n ) {
  return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* 43758.5453);
}
vec3 nrand3( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* vec3(43758.5453, 28001.8384, 50849.4141) );
}

float trunc( float x, float l )
{
	return floor(x*l)/l;
}

//remaps inteval [a;b] to [0;1]
float remap( float a, float b, float t ) {
	return sat( (t - a) / (b - a) );
}


//note: [-1;1]
//note: honestly stolen from iq: https://www.shadertoy.com/view/Xsl3Dl
vec3 hash( vec3 p )
{
	p = vec3( dot(p,vec3(127.1,311.7, 74.7)),
			  dot(p,vec3(269.5,183.3,246.1)),
			  dot(p,vec3(113.5,271.9,124.6)));

	return -1.0 + 2.0*fract(sin(p)*43758.5453123);
}
//note: [-1;1]
float snoise( in vec3 p )
{
    vec3 i = floor( p );
    vec3 f = fract( p );

	vec3 u = f*f*(3.0-2.0*f);

    return mix( mix( mix( dot( hash( i + vec3(0.0,0.0,0.0) ), f - vec3(0.0,0.0,0.0) ), 
                          dot( hash( i + vec3(1.0,0.0,0.0) ), f - vec3(1.0,0.0,0.0) ), u.x),
                     mix( dot( hash( i + vec3(0.0,1.0,0.0) ), f - vec3(0.0,1.0,0.0) ), 
                          dot( hash( i + vec3(1.0,1.0,0.0) ), f - vec3(1.0,1.0,0.0) ), u.x), u.y),
                mix( mix( dot( hash( i + vec3(0.0,0.0,1.0) ), f - vec3(0.0,0.0,1.0) ), 
                          dot( hash( i + vec3(1.0,0.0,1.0) ), f - vec3(1.0,0.0,1.0) ), u.x),
                     mix( dot( hash( i + vec3(0.0,1.0,1.0) ), f - vec3(0.0,1.0,1.0) ), 
                          dot( hash( i + vec3(1.0,1.0,1.0) ), f - vec3(1.0,1.0,1.0) ), u.x), u.y), u.z );
}
float nnoise( in vec3 p )
{
	return 0.5 + 0.5 * snoise( p );
}

const mat3 m = mat3( 0.00,  0.80,  0.60,
                    -0.80,  0.36, -0.48,
                    -0.60, -0.48,  0.64 );

void main()
{
	//TODO: input ranges
	
	float t = clamp( parms.x, 0, 2 );
	float max_t = 6 + parms.z*t; //2
	float min_t = min( max_t-0.1, parms.y*t ); //-4
	float its = remap( max_t, min_t, length(v2f_os_pos) );


	vec3 q = 2*v2f_os_pos;
	float f = 0;
	f  = 0.5000*nnoise( q ); q = m*q*2.01;
	f += 0.2500*nnoise( q ); q = m*q*2.02;
	f += 0.1250*nnoise( q ); q = m*q*2.03;
	f += 0.0625*nnoise( q ); q = m*q*2.01;
	f = pow(f, 0.4f);
	its *= f;

	
	//vec3 col = vec3(0.2,0.5,0.6) + clamp(t, 0, 1 ) * vec3(1,1,1);
	vec3 col = vec3(121,85,255)/255.0f + clamp(t, 0, 1 ) * vec3(1,1,1);
	outcol0 = vec4( its * col, 1 );

	vec2 deriv = abs( dFdx( uv0 ) ) + abs( dFdy( uv0 ) );
	float wire = max( remap( 2, 0, uv0.x / deriv.x ), remap( 2, 0, uv0.y / deriv.y ) );

	outcol0.rgb = mix( outcol0.rgb, vec3(1,1,1), wire );

	//outcol0.rgb -= nrand3( gl_FragCoord.xy + fract(time_s.xx) ) / 255.0;
	//outcol0.rgb = pow( outcol0.rgb, vec3(1.0 / 2.2) );
}
