 
layout(triangles) in;
layout(triangle_strip, max_vertices = 3) out;

uniform vec4 ptpos0;
uniform vec4 ptpos1;
uniform vec4 ptpos2;

uniform vec4 posfactors;

in vec3 v2g_os_norm[];

out vec3 os_norm;

void main()
{
	vec3 avgpos = ( gl_in[0].gl_Position.xyz + gl_in[1].gl_Position.xyz + gl_in[2].gl_Position.xyz ) / 3.0f;
	vec3 avgnorm = ( v2g_os_norm[0].xyz + v2g_os_norm[1].xyz + v2g_os_norm[2].xyz ) / 3.0f;

	vec3 ptvec0 = normalize( ptpos0.xyz - avgpos );
	float dp0 = pow( clamp( dot( avgnorm, ptvec0 ), 0, 1 ), 10 );
	vec3 ptvec1 = normalize( ptpos1.xyz - avgpos );
	float dp1 = pow( clamp( dot( avgnorm, ptvec1 ), 0, 1 ), 10 );
	vec3 ptvec2 = normalize( ptpos2.xyz - avgpos );
	float dp2 = pow( clamp( dot( avgnorm, ptvec2 ), 0, 1 ), 10 );

	vec3 pf = posfactors.xyz;
	float dp = 1 - clamp( 1.6 * (pf.x*dp0 + pf.y*dp1 + pf.z*dp2), 0, 1 );
	//dp *= 1.5f;

	for(int i = 0; i < gl_in.length(); i++) 
	{
		gl_Position = vec4( mix( avgpos, gl_in[i].gl_Position.xyz, dp ), gl_in[i].gl_Position.w );
		os_norm = avgnorm;
		EmitVertex();
	}
	EndPrimitive();
}
