layout(location = 0, index = 0) out vec4 outcol0;

uniform vec4 time_s;
uniform vec4 fogdist;
uniform vec4 diffcol;
uniform sampler2D maintex;

in float alpha_stencil;

in vec3 ws_norm;
in vec3 ws_view;
in vec3 ws_pos;
in vec2 texcoord;

vec3 nrand3( vec2 n ) {
	return fract(sin(dot(n.xy, vec2(12.9898, 78.233)))* vec3(43758.5453, 28001.8384, 50849.4141) );
}

void main()
{
	vec2 light_bake = texture(maintex, texcoord).rg;
	light_bake *= light_bake;
	float light_ambient = sqrt(1 - dot(normalize(ws_norm), normalize(ws_view))) / 8.0;
	float light = (light_bake.r * 6 * diffcol.r + light_ambient) * light_bake.g;

	float fog = clamp(1 - length(ws_pos) / fogdist.x, 0, 1);

	outcol0 = vec4(vec3(light * fog), sign(-texcoord.x));
	
	outcol0.rgb += nrand3( gl_FragCoord.xy * 0.01 + fract( time_s.x ) ) / 255.0;
}