layout(location = 0) in vec3 os_pos;
layout(location = 1) in vec3 os_norm;
layout(location = 2) in vec2 in_texcoord;

uniform mat4 mvp;
uniform mat4 modelmat;
uniform mat4 modelmatIT;
uniform vec4 ws_viewpos;

out vec3 ws_norm;
out vec3 ws_view;
out vec3 ws_pos;
out vec2 texcoord;

void main()
{
	gl_Position =  mvp * vec4( os_pos, 1 );

	ws_norm = normalize((modelmatIT * vec4(os_norm, 0)).xyz);
	ws_pos = (modelmat * vec4(os_pos,1)).xyz;
	ws_view = ws_viewpos.xyz - ws_pos;

	texcoord = in_texcoord;
	texcoord.y = (texcoord.y - 0.5f) * modelmat[1].y + 0.5f;
	texcoord.y -= (modelmat[1].y - 1) / 128;
}