#include "matrix.hlsl"
#include "inout.hlsl"

PIT_DEPTH Depth_VS(VIT_DEPTH input)
{
  PIT_DEPTH output;

  // Change the position vector to be 4 units for proper matrix calculations.
  input.position.w = 1.0f;

  // Calculate the position of the vertex against the world, view, and projection matrices.
  output.position = mul(input.position, worldMatrix);
  output.position = mul(output.position, viewMatrix);
  output.position = mul(output.position, projectionMatrix);

  // Store the position value in a second input value for depth value calculations.
  output.depthPosition = output.position;
	
  return output;
}