; bugs:

; auto next shape cause: prevents from skipping over the -1 shape when using userkey input to select a shape
; if the IP is not found when looking for games, the game freezes for a long time
; read wan ip from site function bugs for 217.123.240.212 (workaround in place via config value)
; player color: when altering the player color (player number) manualy combined with using multiplayer (3 or 4 players) the wrong player colors are used. fix color/player number solved the issue for now

; todos:

; computer players should have some kind of noticable sign to see that they are computer players
; don't display my game name in current game players list in game menu when my game is closed and not joined to any other game

; game rules:

; never overlap, 22 different pieces, board 35*35, same color may not be placed next to eachother may only touch corners
; board must have 17 triangle along the edges which shape a hexagon.
; get enough level point to get to the next level
; max 30 second to place a new tile

Type gameConfig
	Field fullscreen			
	Field playername$
	Field host_ip$
	Field gamename$		
	Field maxplayersconnected
	Field portstart
	Field portend
	Field maxpackagestack
	Field packagesendinterval
	Field framelimit
	Field logging
	Field wan_ip$
	Field theme$
End Type

Global config.gameConfig
config.gameConfig = New gameConfig

readINI()

If config\fullscreen=True
	Graphics 800,600,32,0
Else
	Graphics 800,600,32,2
End If

Global logfile, writeToLogFile=config\logging

If writeToLogFile
	logfile= WriteFile(Str(MilliSecs())+".log")
End If


Dim basicTriangle(1,4) ; x and y, points for the shapes
Dim newShape(1,4) ; rotated points for the basic triangle, used when a triangle needs rotation
Dim rotationSteps(6) ; steps per workable rotation

; pre set rotations to be applied to a shape
rotationSteps(0)=0
rotationSteps(1)=60
rotationSteps(2)=120
rotationSteps(3)=180
rotationSteps(4)=240
rotationSteps(5)=300

; triangle width and height (changeing the triangle size also means making a new play board image)
Global twidth=14*2
Global theight=12*2

Global shapeCnt=23 ; total number of shapes +1

; field width and height
Global fieldcols=35 ; longest horizontal line is 35 triangles long
Global fieldrows=17 ; 18 lines verticaly

; shape triangle count array
Dim shapeTriangleCnt(shapeCnt)  ; per shape, a total triangle count is needed to plot the shape

; shape 0 is the entire field with the most triangles used to for the shape
shapeTriangleCnt(0)=(fieldcols+1)*(fieldrows+1)

Dim playfield(shapeTriangleCnt(0)) ; tile status (-2 is not usable, -1 is empty, 0 is player 0, 1 is player 1 2 and 3 is player 2 and 3)

; shapes array
Dim shapes(shapeCnt,shapeTriangleCnt(0),3) ; shape nr, triangle nr, triangle x pos and y pos and rotation value of a triangle to build a shape

Global playerCnt=4 ; max 4 players in the game
Dim playerShapesCnt(playerCnt,shapeCnt) ; player, number of shapes per player (array number matches shape number)

Dim firstShapePlayer(playerCnt) ; each player can put the first shape down without touching an existing shape of it's own

Dim fieldShapePos(shapeTriangleCnt(0),3) ; triangle nr, x - y - fieldarray position if current shape before placement (actual shape coordinates on the field)

Global turnTimer=0,maxTurnTime=30000,curTurnTimer ; max time in millisecs

; player selected shape
Global selectedShape = 1

Global currentLevel=1 ; current level to play
Global minimalLevelScore=0 ; score to get to the next level
Global levelColR=50,levelColG=50,levelColB=50

Global psrot = 0 ; spin counter for the player shapes left to play with/select

Global fpsCount=0,oldFpsCount=0,fpsTimer=0,fps=0
Global Lmt_Fps=config\framelimit
Global Lmt_Frametime=Float(1000/Lmt_Fps), Lmt_Frame_begin=-1

Global activePlayer  ; current player that must place a shape on the board
Dim tilesPlayed(playerCnt) ; keeps track of how many shapetriangle are put onto the field for each player

Dim playerScore(playerCnt) ; keeps track of actual player scores

Dim highscores$(3,14,1)

Dim compuNames$(playerCnt) ; hold computer player names, used when not all players in the game are human player

compuNames$(0)="Chordee"
compuNames$(1)="Anorchia"
compuNames$(2)="Aspermia"
compuNames$(3)="Orchitis"

; precalc the possible computer shape settings for compu moves:
Dim movesPreCalc(shapeCnt*6*2*2,4)

Global totalCompuMoves=0
For s=1 To shapeCnt-1  ;selectedShape

	For r=0 To 5 ;selectedRotation
		
		For fx=0 To 180 Step 180 ;selectedFlipX
		
			For fy=0 To 180 Step 180 ;selectedFlipY
				movesPreCalc(totalCompuMoves,0)=s
				movesPreCalc(totalCompuMoves,1)=r
				movesPreCalc(totalCompuMoves,2)=fx
				movesPreCalc(totalCompuMoves,3)=fy
			
				;addToLog(s+" "+r+" "+fx+" "+fy+" :"+totalCompuMoves)
				totalCompuMoves=totalCompuMoves+1
			Next
		
		Next
		
	Next
	
Next

; vars for level texts
Dim levelTextSinCnt(22)
Dim levelText$(22)
Dim levelposX(22)
Dim levelposY(22)
Dim levelTextMode(22)
Dim levelposSpd(22)
Dim levelTextSin(22)
Dim levelTextCol(22)

;-------------------------------------------- end of game vars --------------------------------------------------------

; menu/game fonts
Global board=LoadImage("img_"+config\theme+"\game.png")

Global gamename=LoadImage("img_"+config\theme+"\gamename.png")

Global fntGameGray=LoadImage("img_"+config\theme+"\mfont_gr.png")
MaskImage fntGameGray,39,51,20

Global fntGameSel=LoadImage("img_"+config\theme+"\mfont_sl.png")
MaskImage fntGameSel,39,51,20

Global fntGame=LoadImage("img_"+config\theme+"\mfont_w.png")
MaskImage fntGame,39,51,20

Global fntGameRed=LoadImage("img_"+config\theme+"\mfont_r.png")
MaskImage fntGameRed,39,51,20

Global fntGameYellow=LoadImage("img_"+config\theme+"\mfont_y.png")
MaskImage fntGameYellow,39,51,20

Global fntGameGreen=LoadImage("img_"+config\theme+"\mfont_g.png")
MaskImage fntGameGreen,39,51,20

Global fntGameBlue=LoadImage("img_"+config\theme+"\mfont_b.png")
MaskImage fntGameBlue,39,51,20

; game images
Global menuBack=LoadImage("img_"+config\theme+"\blokkers_menu2.png")

; game mouse pointers
Global mousePointers=LoadImage("img_"+config\theme+"\mousepointer.png")
MaskImage mousePointers,58,65,53

; game sprites
Global gameSprites=LoadImage("img_"+config\theme+"\stones.png")
MaskImage gameSprites,58,60,57

; level scores
Global levelScores=LoadImage("img_"+config\theme+"\levelscores.png")
MaskImage levelScores ,1,1,1

; level font
Global levelFont=LoadImage("img_"+config\theme+"\levelfont_grey.png")
MaskImage levelFont ,24,26,24

Global levelFont_yellow=LoadImage("img_"+config\theme+"\levelfont_yellow.png")
MaskImage levelFont_yellow ,24,26,24

Global levelFont_blue=LoadImage("img_"+config\theme+"\levelfont_blue.png")
MaskImage levelFont_blue ,24,26,24

Global levelFont_red=LoadImage("img_"+config\theme+"\levelfont_red.png")
MaskImage levelFont_red ,24,26,24

Global levelFont_green=LoadImage("img_"+config\theme+"\levelfont_green.png")
MaskImage levelFont_green ,24,26,24

; level backgrounds
Global levelbackgrnds

; level doors anim
Dim leveldoor(7)

leveldoor(0) = LoadImage("img_"+config\theme+"\leveldoor0.png")
MaskImage leveldoor(0) ,49,49,49

leveldoor(1) = LoadImage("img_"+config\theme+"\leveldoor1.png")
MaskImage leveldoor(1) ,49,49,49

leveldoor(2) = LoadImage("img_"+config\theme+"\leveldoor2.png")
MaskImage leveldoor(2) ,49,49,49

leveldoor(3) = LoadImage("img_"+config\theme+"\leveldoor3.png")
MaskImage leveldoor(3) ,49,49,49

leveldoor(4) = LoadImage("img_"+config\theme+"\leveldoor4.png")
MaskImage leveldoor(4) ,49,49,49

leveldoor(5) = LoadImage("img_"+config\theme+"\leveldoor5.png")
MaskImage leveldoor(5) ,49,49,49

leveldoor(6) = LoadImage("img_"+config\theme+"\leveldoor6.png")
MaskImage leveldoor(6) ,49,49,49

Global endScreen=LoadImage("img_"+config\theme+"\endscreen.png")


; game sounds

Global txt_key = LoadSound("snd\txt_key.mp3")
Global txt_over = LoadSound("snd\txt_over.mp3")  ; used for enter key at the moment
Global txt_enter = LoadSound("snd\txt_enter.mp3")
Global txt_select = LoadSound("snd\txt_select.mp3")
Global obj_rotate = LoadSound("snd\obj_rotate.mp3")
Global obj_select = LoadSound("snd\obj_select.mp3")
Global obj_flip = LoadSound("snd\obj_flip.mp3")
Global obj_put = LoadSound("snd\obj_put.mp3")
Global menu_atmos = LoadSound("snd\menu_atmos.mp3")
Global game_atmos = LoadSound("snd\game_atmos.mp3")
Global trans_scr = LoadSound("snd\trans_scr.mp3")

Global turn_hurry= LoadSound("snd\turn_hurry.mp3")
Global turn_skip= LoadSound("snd\turn_skip.mp3")
Global level_start= LoadSound("snd\level_start.mp3")
Global level_finish= LoadSound("snd\level_finish.mp3")
Global game_quit= LoadSound("snd\game_quit.mp3")
Global level_gates= LoadSound("snd\level_gates.mp3")
Global bonus_diamond= LoadSound("snd\bonus_diamond.mp3")
Global bonus_marble= LoadSound("snd\bonus_marble.mp3")
Global bonus_gold= LoadSound("snd\bonus_gold.mp3")


Global fntArialB=LoadFont("Arial",16,True,False,False)
SetFont fntArialB


; -------------------------- network vars: -------------------------------------------

Global NetworkLog$ ; logging var in general
Global maxSendPackages=config\maxpackagestack,maxGameCommandSize=maxSendPackages*100 ; max amount of packaes before forces send out is triggered
Global mytcpServer, maxPlayers=config\maxplayersconnected, serverPortStart=config\portstart,serverPortEnd=config\portend, staticBankSizeDigits=Len(Str(maxGameCommandSize)),sendBankSize=staticBankSizeDigits ; sendBankSize is the byte size of a package counter written in the start of each package
Dim tcpStreams(maxPlayers+1,3) ; holds the connections made to a client -  intranet connection, input bank, read possition
Global myHostIP$=config\host_ip ;"192.168.178.14" ;"94.215.170.151" ;"192.168.178.14" ;"127.0.0.1" ; receive the host ip and port (manualy entered by client), or list of users in a IRC channel
Global tcpSendInterval=config\packagesendinterval, oldTimerVal=0 ; once every x miliseconds
Dim playerBanks(maxPlayers+1,2)  ; holds the sending packages buffers

Dim players$(maxPlayers+1,21) ; holds all player info

Dim inputWasUpdated(maxPlayers+1) ; holds the array number that was updated when package is received. used for key and mousebutton

; player 0 is me

players$(0,2)=config\playername ;"noname"
players$(0,3)=config\gamename ;"noname"
players$(0,4)="0"
players$(0,5)="0"
players$(0,7)="0"
players$(0,8)=""
players$(0,17)="2"
players$(0,19)=""
players$(0,20)=""

; 0 = player ip (=intranet ip)
; 1 = player port
; 2 = player name
; 3 = my game name
; 4 = my player number (0-3)
; 5 = isHosting a game
; 6 = player key of the user that is hosting a game that i joined
; 7 = this/joined game has started
; 8 = hold the playernumber that must make a move (between 0 and 3 players)
; 9 = mousex
;10 = mousey
;11 = mousebutton
;12 = mousewheel
;13 = keyboard input
;14 = internet IP
;15 = player unique key / ID
;16 = this player is using the internet connection
;17 = max allowed players in the game allowed
;18 = chat line
;19 = change game variable
;20 = used for game sync purpose. will be filled by the player I asked for it's activePlayer value

;-------------------------------------------- end of network vars ---------------------------------------------------------


;------------------------------------------------- start of game scroller vars -----------------------------

Dim pfont(299,30,30)  ; reserve without border
Dim dcors(30,300,2)
Dim dcors2(30,300,2)

Global font=LoadImage("img_"+config\theme+"\circlefont.png")  ; optimize font to use less space in y-ax
Global circcols=LoadImage("img_"+config\theme+"\circlecolors.png")

Global fontx=12, fonty=24  ; size includes 2px borderlines
Global kar=0,spx=0,strpos=0,colsinCnt=0
Global dpc=210    ; pixels in each circle


;------------------------------------------------- end of game scroller vars -----------------------------

;------------------ twister bar vars -------------------------------------------

Global crdback=LoadImage("img_"+config\theme+"\credits.png")

Global highscorebck=LoadImage("img_"+config\theme+"\highscorebck.png")

Global rotobar=LoadImage("img_"+config\theme+"\twstbar.png")
MaskImage rotobar,105,111,100

;------------------ end of twister bar vars ------------------------------------


;-------------------------------------------- start of the game -------------------------------------------------------

SeedRnd MilliSecs()

createSingleTriangle()			
createShapes()


initGameScroller()

LoopSound game_atmos
LoopSound menu_atmos

Global menu_ambientSnd,game_ambientSnd 

game_ambientSnd= PlaySound(game_atmos)
ChannelVolume game_ambientSnd,0.5
;ChannelPitch game_ambientSnd,20000
PauseChannel game_ambientSnd

menu_ambientSnd= PlaySound(menu_atmos)
ChannelVolume menu_ambientSnd,0.5

SetBuffer BackBuffer()

HidePointer

updateHighScores(hostKey$,maxInGame)

start()

Function start()
	quitGame=False
	
	doScreenTransition(gamename, 4, 1000)
	
	While Not quitGame
		keyp=GetKey()
		but=GetMouse()
	
		DrawBlock gamename,0,0
	
		gameScroller("  TRIAGON       ")
	
		i=plotBitmapFont(150,370,"Start game",fntGameGray,MouseX(),MouseY())
	
		If i=0 And but=1
			gameMenu()
			doScreenTransition(gamename, 3, 1000)
		End If
	
		i=plotBitmapFont(150,390,"Highscores",fntGameGray,MouseX(),MouseY())

		If i=0 And but=1
			plotHighScores()
			doScreenTransition(gamename, 3, 1000)
		End If

		i=plotBitmapFont(180,410,"Credits",fntGameGray,MouseX(),MouseY())
		
		If i=0 And but=1
			creditsScreen()
			doScreenTransition(gamename, 3, 1000)
		End If
	
		i=plotBitmapFont(205,430,"Quit",fntGameGray,MouseX(),MouseY())
	
		If i=0 And but=1
			quitGame=True
			doScreenTransition(gamename, 5, 1000)
		End If
	
		plotMouse(MouseX(),MouseY())
		
		;frames=frameCounter()
		;Text 0,0,frames

		Flip(True)

		frameLimitor()

	Wend
	
	StopChannel menu_ambientSnd
	StopChannel game_ambientSnd
	
	closeTCPSession()
	If mytcpServer
		CloseTCPServer(mytcpServer)
	End If
	FreeFont fntArialB
	
	End
End Function

Function gameMenu()
	doScreenTransition(menuBack, 2, 1000)

	stayInGame=True
	
	While stayInGame
	
		; run main menu until start or quit is selected
		stayInGame=runGameMenu()
		
		If stayInGame
			; goto game
	
			PauseChannel menu_ambientSnd
	
			ResumeChannel game_ambientSnd
			triagonGame()
			
			doScreenTransition(menuBack, 1, 1000)
			
			PauseChannel game_ambientSnd
	
			ResumeChannel menu_ambientSnd
	
		End If
	
	Wend

End Function

Function creditsScreen()
	doScreenTransition(crdback, 1, 1000)

	; credits screen
	keyp=0
	but=0
	
	While keyp=0 And but=0
		keyp=GetKey()
		but=GetMouse()
	
		DrawBlock crdback,0,0
	
		gameScroller("                   CODE and GFX           The Match/FUN           CHARS           ripped :)           FX'S           The Match/FUN           MUSIC           The Match/FUN, D-Force/Outline           TESTING           The Match/FUN, D-Force/Outline, Jungla           Released at OUTLINE 2014                  Pants down for all sceners!!!!!!!        WARPPPPPPP           ")
	
		; draw twister bars
		For rbx=0 To 800
			rxpos=(rbx+Sin( Sin(rcnt-rbx)*20 + (Sin(rcnt+rbx/2)*70) )*200+200) Mod 417  ;Abs( Sin(rbx/4+rcnt) * (Sin(rcnt/2+rbx)*209+209)+rcnt+rbx ) Mod 417
			
			DrawImageRect rotobar,rbx,50 ,rxpos,0 ,1,148
		Next
		
		rcnt=rcnt+1
	
		plotMouse(MouseX(),MouseY())
		
		Flip(True)
		
		frameLimitor()

	Wend
End Function


Function gameScroller(lultekst$, mode=0)

	Local cx,cy,col

	shownall=False

	If lultekst$<>""
			
		; scroll to next char in circle text
		spx=spx+1
	
		If spx>fontx-2 Then
			spx=0
	
			strpos=strpos+1
	
			If strpos>Len(lultekst$)
				strpos=1
				shownall=True
			End If
			
			kar=Asc(Mid(lultekst$,strpos,1))-32
	
		End If
	
	Else
		strpos=0
		spx=fontx
	End If

	colsinCnt=colsinCnt+1

	If mode=0
		
		For d=1 To dpc
		
			For r=3 To fonty-3	; cut out blank cirlce line by not plotting them
	
				cx=dcors(r,d,0)
				cy=dcors(r,d,1)
				col=dcors(r,d,2)
	
				; swap the first color with the second to make this shit scroll
				dcors(r,dpc-d+1,2)=dcors(r,dpc-d,2)
	
				; place the font color on pos x=0 in ring r
				dcors(r,0,2)=pfont(kar,spx,r)
				
				If col<>0
					colsin=Sin(colsinCnt-d+r)*180+180 ; if a color is set, set the source x cor to the non black portian of the color img
					
					CopyRect colsin,0,3,3,cx,cy ,ImageBuffer(circcols),BackBuffer()
				End If	
			Next
		Next

	Else

		For d=1 To dpc
		
			For r=3 To fonty-3	; cut out blank cirlce line by not plotting them
	
				cx=dcors2(r,d,0)
				cy=dcors2(r,d,1)
				col=dcors2(r,d,2)
	
				; swap the first color with the second to make this shit scroll
				dcors2(r,dpc-d+1,2)=dcors2(r,dpc-d,2)
	
				; place the font color on pos x=0 in ring r
				dcors2(r,0,2)=pfont(kar,spx,r)
				
				If col<>0
					colsin=Sin(colsinCnt-d+r)*180+180 ; if a color is set, set the source x cor to the non black portian of the color img
					
					CopyRect colsin,0,3,3,cx,cy ,ImageBuffer(circcols),BackBuffer()
				End If	
			Next
		Next
		

	End If
	
	Return shownall
End Function

Function initGameScroller()

	SetBuffer FrontBuffer()

	cperline=16
	clines=6
	fontx=12
	fonty=24  ; size includes 2px borderlines
	
	DrawImage font,0,0
	
	LockBuffer
	; get font pixel data
	For c=0 To clines*cperline-1  ; chars in x and y -1
		For sy=1 To fonty-1
			For sx=1 To fontx-1
			
				nx=sx+(c Mod cperline)*fontx
				ny=sy+(c/cperline)*fonty
				
				col=ReadPixelFast(nx,ny) And $FFFFFF  ; mask the high 8 bits alpha value out		
				
				If col>0     ; set pixel to 360 when not black
					col=360
				End If
				
				pfont(c,sx-1,sy-1)=col  ; read pixel col-val per letter and store value at same x,y pos in array			
			Next
		Next
	
	Next
	UnlockBuffer
	
	Cls
	
	; pre-calc circle scroller cors :
	
	cs=290  ; start radius size
	cstr=4  ; y stretch amount
	
	dpc=210    ; pixels in each circle
	
	For d=0 To dpc
		For r=0 To fonty
	
			; cors for the normal scroller
			cx=Cos((360.000/dpc)*d)*(cs-d*4-r*cstr)+570
			cy=Sin((-30.000/dpc)*d+r)*(cs-d+r*cstr)+310
	
			dcors(r,d,0)=cx
			dcors(r,d,1)=cy
			dcors(r,d,2)=0

			; cors for the level scroller
			cx=Cos((90.000/dpc)*d)*(cs-d*4+r*cstr)+520
			cy=Sin((-90.000/dpc)*d)*(cs-d*6-r*cstr)+230

			dcors2(r,d,0)=cx
			dcors2(r,d,1)=cy
			dcors2(r,d,2)=0

		Next
	Next

End Function

Function doScreenTransition(trgtScr, mode, transT)
	Local srcScr=CreateImage(800,600)	
	Local t=MilliSecs()
	Local ct=0

	CopyRect 0,0, 800,600, 0,0,BackBuffer(),ImageBuffer(srcScr)

	PlaySound(trans_scr)
	
	While ct<transT
		ct=MilliSecs()-t

		Select mode
			Case 0 ; scroll up
				y2=Sin((90.000/transT)*ct)*600

				DrawBlock srcScr,0,y2

				DrawBlock trgtScr,0,y2-600
			
			Case 1 ; scroll down
				y2=Sin((-90.000/transT)*ct)*600

				DrawBlock srcScr,0,y2

				DrawBlock trgtScr,0,y2+600
					
			Case 2 ; scroll right
				x2=Sin((90.000/transT)*ct)*800

				DrawBlock srcScr,x2,0

				DrawBlock trgtScr,x2-800,0
			
			Case 3 ; scroll left
				x2=Sin((90.000/transT)*ct)*-800

				DrawBlock srcScr,x2,0

				DrawBlock trgtScr,x2+800,0

			Case 4 ; stretched to normal screen trans
				
				;DrawBlock srcScr,0,0

				y2=102-((100.000/transT)*ct)
				
				If y2=0
					y2=1
				End If
			
				For y=0 To 300
					CopyRect 0,300-y/y2, 800,1, 0,300-y,ImageBuffer(trgtScr),BackBuffer()
					CopyRect 0,300+y/y2, 800,1, 0,300+y,ImageBuffer(trgtScr),BackBuffer()
				Next			

			Case 5 ; normal to stretched screen trans
				
				;DrawBlock srcScr,0,0

				y2=2+(100.000/transT)*ct
				
				If y2=0
					y2=1
				End If
			
				For y=0 To 300
					CopyRect 0,300-y/y2, 800,1, 0,300-y,ImageBuffer(trgtScr),BackBuffer()
					CopyRect 0,300+y/y2, 800,1, 0,300+y,ImageBuffer(trgtScr),BackBuffer()
				Next			

			Case 6 ; gates closing trans

				x2=Sin((90.000/transT)*ct)*400

				DrawBlock srcScr,0,0

				CopyRect 0,0, 400,600, x2-400,0,ImageBuffer(trgtScr),BackBuffer()
				CopyRect 400,0, 400,600, 800-x2,0,ImageBuffer(trgtScr),BackBuffer()

		End Select

		plotMouse(MouseX(),MouseY())
		
		Flip(True)
		
		frameLimitor()

	Wend

End Function

;----------------------------------------start of game functions ------------------------------------------

Function plotEndScreen(finished=False)

	doScreenTransition(endScreen, 6, 1000)
	
	but=0
	keyp=0

	t=MilliSecs()

	While (keyp=0 And but=0)
		keyp=GetKey()
		but=GetMouse()
		
		DrawBlock endScreen,0,0
		
		plotMouse(MouseX(),MouseY())
	
		If finished
		
			If MilliSecs()-t>200+Rand(100)
				plotLevelText(Rand(4),"# well done #",Rand(450),Rand(200)+200,1)
				t=MilliSecs()
			End If
	
			plotLevelText()
			
			gameScroller("   WELL DONE !! You have finished the game!   ",1)
	
		End If
		
		Flip(True)
		
		frameLimitor()
	Wend

End Function

Function triagonGame()

	doScreenTransition(board, 0, 1000)

	Local keyPressed
	Local oldmx=-1,mx
	Local oldmy=-1,my
	Local mz
	Local button

	Local oldselectedShape=-1
	Local oldselectedRotation=-1
	Local oldselectedFlipX=-1
	Local oldselectedFlipY=-1

	Local myTurn=False,gameInSync=False,allowed=False, gameFinished=False
	Local onRotateButton=False

	Local mouseType=0

	Local iControlComputerNow=False, compuMoveStarted=False,compuMovesPos=0,compuMoveStartPoint=0

	Local nextLevel=True, levelLoaded=False
	Local doorAnim=0
	
	Local oldcurTurnTimer=0, playingHurry=False

	; clear all woble text
	For p=0 To 22
		levelText$(p)=""
	Next
		
	; start at level 0, call to next level will set this var to 0
	currentLevel=-1

	; set play field drawing offset
	fieldOffsetx=twidth/2+20
	fieldOffsety=theight/2+20
	
	selectedShape = 1

	; current shape rotation settings
	selectedRotation = 0
	selectedFlipX=0
	selectedFlipY=0
	shapeRotate=0
	spdr=0 ; tween speed for shape rotation
	
	activePlayer=-1
	players$(0,8)="" ; current active player number

	For i=0 To playerCnt-1
		firstShapePlayer(i)=True
		tilesPlayed(i)=0
		playerScore(i)=0
	Next

	hostKey$=""
	Local maxInGame   ; holds the host max players count for the game
	
	; if i am hosting, set the player start number and broadcast your turn status
	If players$(0,5)="1"

		hostKey$=players$(0,15)
		activePlayer=Rand(3) ; pick a player that must start

		iControlComputerNow=setNextPlayer(hostKey$)
	Else
		hostKey$=players$(0,6)
	End If

	; get current max players in game
	For p=0 To maxPlayers	
		If players$(p,15)<>"" And players$(p,7)="1"
			; get max players in game from host player
			If players$(p,15)=hostKey$
				maxInGame=Int(players$(p,17))
			End If
		End If
	Next
	
	While players$(0,7)="1"

		DrawBlock board,0,0

		If levelLoaded  ; don't plot the level of a level is being loaded
	
			DrawImageRect levelbackgrnds,30,26,0,0,515,442
	
			; draw play field shapes and count the tiles of each player on the board
			;Color levelColR,levelColG,levelColB
		
			For t=0 To shapeTriangleCnt(0)-1
	
				calcTriangle(shapes(0,t,2),shapes(0,t,0),shapes(0,t,1),0,0)	

				If playfield(t)<>-2 ; value -2 is a visibly empty field so don't draw anything there, else, draw the shit
					;drawTriangle(fieldOffsetx,fieldOffsety)

					If playfield(t)>-1  ; if field item is used				
						drawGameIcon(fieldOffsetx,fieldOffsety,shapes(0,t,2),playfield(t))
						;drawTriangle(fieldOffsetx,fieldOffsety)
					End If

				End If
						
			Next
		
		End If
			
		;If nextLevel=False
			; get info from other players
			checkNetwork()
		;End If
		
		; check if activePayer var matches my internal players array activePlayer value
		For p=0 To maxPlayers
			If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
		
				If Int(players$(p,8))<>activePlayer
					gameInSync=False
				End If
				
			End If
		Next
		
		
		If activePlayer<>-1 And nextLevel=False ; prevent moves being made while doing next level stuff

			prekeyPressed=GetKey()
			premx=MouseX()
			premy=MouseY()
			premz=MouseZSpeed() ; shape selector
			prebutton=GetMouse() ; but nr that is pressed
	
			oldselectedShape=selectedShape
			oldselectedRotation=selectedRotation
			oldselectedFlipY=selectedFlipY
			oldselectedFlipX=selectedFlipX

			If gameInSync=True

	
				; if it is my turn
				If myTurn  ; if activeplayer is my playernumber
		
					If keyPressed<>prekeyPressed
						FlushKeys
					End If
		
					If button<>prebutton Or mz<>premz
						FlushMouse
					End If
					
					keyPressed=prekeyPressed
					mx=premx
					my=premy
					mz=premz ; shape selector
					button=prebutton ; but nr that is pressed
	
					; calc turn timer
					curTurnTimer= Int((maxTurnTime-(MilliSecs()-turnTimer))/100)
				
					If curTurnTimer<0
						curTurnTimer=0
					End If	
			
					; send update of my mouse status
					If mx<>oldmx Or my<>oldmy ;Or button<>0 Or mz<>0
		
						oldmx=mx
						oldmy=my
				
						players$(0,9)=mx
						players$(0,10)=my
					
						For p=1 To maxPlayers
							If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
								sendGameCommand(6, 0, p)
							End If
						Next
		
					End If
		
		
					; start set game vars
		
					; skip turn when out of time
					If curTurnTimer=0 And iControlComputerNow=False
						iControlComputerNow=setNextPlayer(hostKey$)
						myTurn=False
						
						gameInSync=False
						
						;addToLog("human out of time")
					End If
		
					If spdr=0  ; only allow rotation when not rotating already
						onRotateButton=False
				
						If mx>50 And mx<100 And my>25 And my<75 
							If button=1
								selectedRotation=selectedRotation+ 1
								PlaySound(obj_rotate)
							End If
													
							onRotateButton=True
						End If
			
						If mx>475 And mx<525 And my>25 And my<75 
							If button=1
								selectedRotation=selectedRotation- 1			
								PlaySound(obj_rotate)
							End If
							
							onRotateButton=True
						End If
				
						If mx>50 And mx<100 And my>415 And my<470 
							
							If button=1
							
								If selectedFlipY=180
									selectedFlipY=0
								Else
									selectedFlipY=180
								End If
							
								PlaySound(obj_flip)
							End If						
							onRotateButton=True
							
						End If
			
						If mx>475 And mx<525 And my>415 And my<470 
							If button=1
							
								If selectedFlipX=180
									selectedFlipX=0
								Else
									selectedFlipX=180
								End If
							
								PlaySound(obj_flip)
							End If					
							onRotateButton=True
							
						End If
	
						Select keyPressed
						
							Case 43 ; +
								selectedShape=selectedShape + 1
								
								onRotateButton=True
								PlaySound(obj_select)
								
							Case 45 ; -
								selectedShape=selectedShape - 1
								
								onRotateButton=True
								PlaySound(obj_select)
								
							Case 31 ; left arrow
								selectedRotation=selectedRotation -1
	
								onRotateButton=True
								PlaySound(obj_rotate)
										
							Case 30 ; right arrow
								selectedRotation=selectedRotation+1
								
								onRotateButton=True
								PlaySound(obj_rotate)
										
							Case 28 ; up arrow
								If selectedFlipX=180
									selectedFlipX=0
								Else
									selectedFlipX=180
								End If
								
								onRotateButton=True
								PlaySound(obj_flip)
								
							Case 29 ; down arrow			
								If selectedFlipY=180
									selectedFlipY=0
								Else
									selectedFlipY=180
								End If
								
								onRotateButton=True
								PlaySound(obj_flip)
						
						End Select
	
						If mz<>0			
							selectedShape=selectedShape + mz
							PlaySound(obj_select)
						End If
					
					End If
						
		
					; set shape rotation
					If selectedRotation<0
						selectedRotation=5
					Else If selectedRotation>5
						selectedRotation=0
					End If
		
					; set selected shape
					If selectedShape<1
						selectedShape=shapeCnt-1
					Else If selectedShape>shapeCnt-1
						selectedShape=1
					End If
				
					; auto select next shape if the selected one is all played out
					; BUG: also prevents from skipping over the -1 shape when using userkey input to select a shape
					mcnt=0
					While (playerShapesCnt(activePlayer,selectedShape)=-1 And mcnt<shapeCnt)
						selectedShape=selectedShape+1
						
						If selectedShape<1
							selectedShape=shapeCnt-1
						Else If selectedShape>shapeCnt-1
							selectedShape=1
						End If
								
						mcnt=mcnt+1
					Wend
			
					; end set game vars
						
				Else ; if it's not my turn, get mouse and keyboard data from active player
					
					onRotateButton=False
					
					keyPressed=0
					mz=0
					button=0
			
					pnum=-1
		
					For p=0 To maxPlayers
		
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
		
							If Int(players$(p,4))=activePlayer
								pnum=p
								p=maxPlayers
							End If
					
						End If
		
					Next
		
					If pnum<>-1 ; if human connected player is at the key's
			
						gameVarChanged$=""
			
						mx=players$(pnum,9)
						my=players$(pnum,10)
						
						If inputWasUpdated(pnum)=19  
							gameVarChanged$=players$(pnum,19)
						End If
						
						inputWasUpdated(pnum)=0
						
						; use received input if game variable change is received
						If gameVarChanged$<>""  ; if a game variable value change is received
							; extract change variable, variable number and new value: format: "3,blaa"
							
							varnum=Left(gameVarChanged$,Instr(gameVarChanged$,",")-1)
							val$=Mid(gameVarChanged$,Instr(gameVarChanged$,",")+1,Len(gameVarChanged$)-Instr(gameVarChanged$,",")+1)
			
							; active player has:
							Select varnum
								
								Case 0	; placed an object
								
									; mx&my&turntimer
								
									np=Instr(val$,"&")
									
									mx=Left(val$,np-1)
									
									sp=Instr(val$,"&",np+1)
									
									my=Mid(val$,np+1,np+1-sp-1)
									
									curTurnTimer=Mid(val$,sp+1,Len(val$)-sp)
									button=1
			
								Case 1	; select an other object
									selectedShape=Int(val$)
								Case 2	; rotated the object
									selectedRotation=Int(val$)
								Case 3	; object flip x
									selectedFlipX=Int(val$)
								Case 4	; object flip y
									selectedFlipY=Int(val$)
									
								Case 5 ; player has quit the game, I quit also
								
									addToLog("force quit received")
	
									players$(0,6)=""
									players$(0,7)="0"
									players$(0,8)=""
									
								Case 6 ; turn timer
									curTurnTimer=Int(val$)
							End Select
							
						End If
					
					Else  ; if no human is playing
					
						
						; set mouse pointer to computer
						
						If iControlComputerNow ; which means that this player must computate the computer move
						
							; calc turn timer for computer player
							curTurnTimer= Int((maxTurnTime-(MilliSecs()-turnTimer))/100)
						
							If curTurnTimer<0
								curTurnTimer=0
							End If	
	
						
							; computer pre final moves are not send to other players
							; allowed move is send, take in account that rotation, shape number and position must be send too
					
							;Repeat   ; check all options in one go will cause the game to freeze for a second
							
							If compuMoveStarted=False ; start somewhere random to make the compu look more intelligent ;)
								compuMoveStartPoint=Rand(totalCompuMoves-10)
								compuMovesPos=compuMoveStartPoint
								
								compuMoveStarted=True
							End If
	
							; get shape,rotation etc from pre-calc moves array
							Repeat
								selectedShape=movesPreCalc(compuMovesPos,0)
								selectedRotation=movesPreCalc(compuMovesPos,1)
								selectedFlipX=movesPreCalc(compuMovesPos,2)
								selectedFlipY=movesPreCalc(compuMovesPos,3)
																
								compuMovesPos=(compuMovesPos+1) Mod totalCompuMoves
							Until playerShapesCnt(activePlayer,selectedShape)>-1 Or compuMovesPos=compuMoveStartPoint
						
							; no more moves of out of time, skip the turn
							If compuMovesPos=compuMoveStartPoint Or curTurnTimer=0
								; no more moves left to try									
								;addToLog("no more moves")
								
								;addToLog("compu time "+curTurnTimer)
								
								compuMoveStarted=False
								
								; skip player move because there is no move to make
								iControlComputerNow=setNextPlayer(hostKey$)
								
								gameInSync=False  ; triggers the sync procedure
								
								; next turn
							Else
								; test the move on the field
								mcnt=0
								
								allowedCompu=False
								
								shapeRotate=rotationSteps(selectedRotation) ; set the rotation to the correct selected angle to prevent rotate animation
								spdr=0
								
								tStart=Rand(shapeTriangleCnt(0)-1)
								t=tStart
								
								; test shape on each field tile
								Repeat
								
									t=(t+1) Mod shapeTriangleCnt(0)
							
									If playfield(t)=-1 Or playfield(t)>3 ; only check usable field blocks
										; calc field pos
										calcTriangle(shapes(0,t,2),shapes(0,t,0),shapes(0,t,1),0,0)	
										
										; calc shape position
										mx=((newShape(0,0)+newShape(0,1)+newShape(0,2))/3)+fieldOffsetx
										my=((newShape(1,0)+newShape(1,1)+newShape(1,2))/3)+fieldOffsety
									
										; check if move is valid
										ret$=checkGameMove(mx,my,mcnt,shapeRotate,selectedRotation,selectedFlipX,selectedFlipY, fieldOffsetx, fieldOffsety)
		
										allowedCompu=Int(Left(ret$,1))
										outsideCompu=Int(Right(ret$,1))
	
										If allowedCompu=1 And outsideCompu=0
											t=tStart
										End If
					
									End If		
	
								Until t=tStart
	
								; check if a good position is found
								If allowedCompu
									compuMoveStarted=False
	
									; trigger place shape procedure
									button=1
									
									;addToLog("found: "+selectedShape+" "+selectedRotation+" "+selectedFlipX+" "+selectedFlipY+" :"+compuMovesPos)
							
									;addToLog("yea "+mx+","+my+","+mcnt+","+shapeRotate+","+selectedRotation+","+selectedFlipX+","+selectedFlipY+","+fieldOffsetx+","+fieldOffsety)
								End If
	
							End If
	
	
							;Until compuMoveStarted=False
	
	
						Else ; if I don't control the compu moves, receive them:
	
							; handle received computer moves here
							
							; computer pre final moves are not send to other players
							; move is send, take in account that rotation, shape number And position must be send too
	
							gameVarChanged$=""
	
							For p=0 To maxPlayers
				
								If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
				
									If inputWasUpdated(p)=19
										gameVarChanged$=players$(p,19)
										inputWasUpdated(p)=0
										
										p=maxPlayers
									End If
							
								End If
				
							Next
	
							; use received input if game variable change is received
							If gameVarChanged$<>""  ; if a game variable value change is received
								; extract change variable, variable number and new value: format: "3,blaa"
								
								varnum=Left(gameVarChanged$,Instr(gameVarChanged$,",")-1)
								gameVarChanged$=Mid(gameVarChanged$,Instr(gameVarChanged$,",")+1,Len(gameVarChanged$)-Instr(gameVarChanged$,",")+1)
				
								gameVarChanged$=gameVarChanged$+"&"
								
								; get shape settings etc and active placement - button=1
								Select varnum
																	
									Case 5	; computer has placed an object
										;addToLog("YEEA "+gameVarChanged$)
	
										; mx+"&"+my+"&"+selectedShape+"&"+selectedRotation+"&"+selectedFlipX+"&"+selectedFlipY		
	
										arrCnt=0
										strtPos=1
										endPos=Instr(gameVarChanged$,"&",strtPos)
										While endPos>0
											arrVal$=Mid(gameVarChanged$,strtPos,endPos-strtPos)
							
											Select arrCnt
											
												Case 0
													mx=Int(arrVal$)
												Case 1
													my=Int(arrVal$)
												Case 2
													selectedShape=Int(arrVal$)
												Case 3
													selectedRotation=Int(arrVal$)
												Case 4
													selectedFlipX=Int(arrVal$)
												Case 5
													selectedFlipY=Int(arrVal$)
												Case 6
													curTurnTimer=Int(arrVal$)
											End Select
							
											arrCnt=arrCnt+1
											
											strtPos=endPos+1		
											endPos=Instr(gameVarChanged$,"&",strtPos)
										Wend
	
										shapeRotate=rotationSteps(selectedRotation) ; set the rotation to the correct selected angle to prevent rotate animation
										spdr=0					
										button=1
										
										addToLog(mx+","+my+","+selectedShape+","+selectedRotation+","+selectedFlipX+","+selectedFlipY)
								End Select
								
							End If
	
	
						End If
	
					End If ; end if human or not
 						
				End If ; end if myturn or not

			End If ; end of sync or not
	
			; end get/set game vars
			
			; draw all the game shapes of current player
			
			If spdr=0  ; only allow new object selection when not rotating and object right now
				If drawPlayerShapes(mx,my,button)				
					PlaySound(obj_select)
				End If	
			Else
				drawPlayerShapes(mx,my,0)
			End If
	
			; now that all input is collected from the game, send out differences to other players when it's my turn only
			If myTurn
				; send game var changes here if changed:
	
				If oldselectedShape<>selectedShape
					players$(0,19)="1,"+selectedShape
				
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If
					Next
				
				End If
				
				If oldselectedRotation<>selectedRotation
					players$(0,19)="2,"+selectedRotation
				
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If
					Next
				
				End If
				
				If oldselectedFlipX<>selectedFlipX
					players$(0,19)="3,"+selectedFlipX
				
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If
					Next
				
				End If
				
				If oldselectedFlipY<>selectedFlipY
					players$(0,19)="4,"+selectedFlipY
				
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If
					Next
		
				End If

				; send turn timer				
				If Abs(oldcurTurnTimer-curTurnTimer)>10 Or (curTurnTimer=0 And oldcurTurnTimer<>0)  ; prevent sending out all timer intervals
					players$(0,19)="6,"+curTurnTimer
				
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If	
					Next
					
					oldcurTurnTimer=curTurnTimer					
				End If
	
			End If	
	
			If curTurnTimer>200
				playingHurry=False
			EndIf

			If curTurnTimer<101 And playingHurry=False
				playingHurry=True
				PlaySound (turn_hurry)
			End If

			If curTurnTimer=0
				PlaySound (turn_skip)
			End If
		
			; start game var parsing:
	
			; animate selected shape rotation
			If rotationSteps(selectedRotation)-shapeRotate>200 ; from 0 to 300
				spdr=spdr+1
				shapeRotate=shapeRotate-spdr
	
				If shapeRotate<-60
					shapeRotate=rotationSteps(selectedRotation)
					spdr=0
				End If
	
			Else If rotationSteps(selectedRotation)-shapeRotate<-200 ; from 300 to 0
				spdr=spdr+1
				shapeRotate=shapeRotate+spdr
	
				If shapeRotate>360
					shapeRotate=rotationSteps(selectedRotation)
					spdr=0
				End If
		
			Else
	
				If rotationSteps(selectedRotation)>shapeRotate
					spdr=spdr+1
					shapeRotate=shapeRotate+spdr
				End If
				
				If rotationSteps(selectedRotation)<shapeRotate
					spdr=spdr+1
					shapeRotate=shapeRotate-spdr
				End If
	
				If Abs(rotationSteps(selectedRotation)-shapeRotate)<10
					shapeRotate=rotationSteps(selectedRotation)
					spdr=0
				End If
				
			End If
	
			If spdr>4
				spdr=4
			End If
		

			; check game move - apply game rules
			ret$=checkGameMove(mx,my,mcnt,shapeRotate,selectedRotation,selectedFlipX,selectedFlipY, fieldOffsetx, fieldOffsety)

			allowed=Int(Left(ret$,1))
			outside=Int(Right(ret$,1))

			If onRotateButton ; show shape outside the field when i am rotating via the rotate button
				outside=0
			End If

			placed=False
			
			; draw current shape on cursor and field position, place the shape if commanded
			
			olds=playerScore(activePlayer)
			bonusType=0
			
			For t=0 To shapeTriangleCnt(selectedShape)
	
				If outside=0  ; not outside the field
	
					; calc triangle position and rotate it
					calcTriangle(shapes(selectedShape,t,2)+shapeRotate,shapes(selectedShape,t,0),shapes(selectedShape,t,1),selectedFlipX,selectedFlipY)
		
					If iControlComputerNow=False
						; draw using field position
						If allowed 
							;Color 255,255,255
							drawTriangle(fieldShapePos(t,0),fieldShapePos(t,1),0,16777215)
						End If
					
						; draw triangle on mouse point
						plotCol=0
						Select activePlayer
							Case 0:
								;Color 255,255,0
								plotCol=16776960
							Case 1:
								;Color 0,255,0
								plotCol=65280
							Case 2:
								;Color 0,100,255
								plotCol=25855
							Case 3:
								;Color 255,0,0
								plotCol=16711680
						End Select
					
						drawTriangle(mx-twidth/3,my-theight/2,2,plotCol)
					End If
				
					If button=1 And allowed=1 ; allowed to place shit here
						
						If playfield(fieldShapePos(t,2))>3  ; field tile holds a bonus item
							
							bText$=""
							
							Select playfield(fieldShapePos(t,2))
								Case 4 ; marble
									playerScore(activePlayer)=playerScore(activePlayer)+25
									bText$="+25 marble bonus"
									PlaySound (bonus_marble)
								Case 5 ; gold
									playerScore(activePlayer)=playerScore(activePlayer)+10
									bText$="+10 gold bonus"
									PlaySound (bonus_gold)
								Case 6 ; diamonds
									playerScore(activePlayer)=playerScore(activePlayer)+50
									bText$="+50 diamond bonus"
									PlaySound (bonus_diamond)
							End Select

							plotLevelText(activePlayer,bText$)
							; todo: play bonus sounds here
						End If
						
						playfield(fieldShapePos(t,2))=activePlayer
						
						playerScore(activePlayer)=playerScore(activePlayer)+(1*curTurnTimer/20)  ; turntime is big factor in the scores per tile
						
						; keep track of the placed tiles
						tilesPlayed(activePlayer)=tilesPlayed(activePlayer)+1
	
						placed=True
					End If
					
				End If
			Next


			If placed
				
				If olds<>playerScore(activePlayer)
					plotLevelText(activePlayer,"+"+(playerScore(activePlayer)-olds),mx,my,1)
				End If

				; check if next level is reached
				If tilesPlayed(activePlayer)=>minimalLevelScore
					
					playerScore(activePlayer)=playerScore(activePlayer)+100
					
					plotLevelText(activePlayer,"+100 # next level #")

					PlaySound (level_finish)

					nextLevel=True
				End If
				
				PlaySound(obj_put)
						
				addToLog("object is now placed "+activePlayer )
			
				; substract 1 from the players shapes count
				playerShapesCnt(activePlayer,selectedShape)=playerShapesCnt(activePlayer,selectedShape)-1
	
				; it's no longer the first shape being placed next time
				firstShapePlayer(activePlayer)=False
					
				allowed=False
				allowedCompu=False

				; to prevent game command inteferance (new active player and previous active player command get mixed at third player)
				; ask all players for there current active player number
				; if all players respond with the same number the game is synced
				gameInSync=False  ; triggers the sync procedure
				
				If myTurn Or iControlComputerNow
					; send out game command that the shape is placed on a good spot on the board:
	
					If iControlComputerNow ; computer placed it
						players$(0,19)="5,"+mx+"&"+my+"&"+selectedShape+"&"+selectedRotation+"&"+selectedFlipX+"&"+selectedFlipY+"&"+curTurnTimer		
					Else ; human has placed it
						players$(0,19)="0,"+mx+"&"+my+"&"+curTurnTimer
					End If
					
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							sendGameCommand(4, 0, p, 19)
						End If
					Next
	
					addToLog("now switching to other player")
	
					iControlComputerNow=setNextPlayer(hostKey$)
					myTurn=False
				Else
					iControlComputerNow=False
				End If

			End If
					
			; plot player names and buttons
			sItem=plotGameInfo(premx,premy, hostKey$,myTurn)
	
			If prebutton=1 And iControlComputerNow=False
				Select sItem
					Case 0 ; skip
					
						PlaySound(txt_select)
						iControlComputerNow=setNextPlayer(hostKey$)
						myTurn=False
						
						PlaySound (turn_skip)
						
						gameInSync=False  ; triggers the sync procedure
						
					Case 1 ; quit game
	
						PlaySound(txt_select)

						addToLog("send quit game pressed")

						players$(0,19)="5,quit"
											
						For p=1 To maxPlayers
							If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
								sendGameCommand(4, 0, p, 19)
							End If
						Next
						
						sendTCPPackages() ; force sendout of quit message

						players$(0,7)="0"

				End Select
			End If

		End If ; endif for activeplayer>-1
		
		; if shape is outside play field or it's not my turn, plot mouse
		If outside=1 Or myTurn=False
			plotMouse(premx,premy,mouseType)
		End If

		; plot chat tet and clear if all is shown once
		If gameScroller(levelScroller$,1)
			levelScroller$=""
		End If

		; plot point scroller
		plotLevelText()
				
		; when activePlayer is changed by the active player, the new activePlayer number is found in the players(x,8)==activePlayer

		If gameInSync=False ; when games starts or object is placed (by current or remote player) or when skip turn or quit game
			mouseType=1  ; set mousepointer to syncing
			
			; check if I have received the new active player number from all players
			If players$(0,20)<>"1"
			
				; new players in sync?
				; check if all players in this game have the same activePlayer number
				
				;addToLog("checking player numbers are in sync or not")
				
				pReceived=True
				For p=1 To maxPlayers
					If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
						If players$(p,8)=activePlayer ; check if the newly received active player is there by checking it against the current
							pReceived=False
						End If
						
					End If
				Next

				If pReceived
					; new player number received for all players in this game
					; now send out the in sync signal for this player to all other players

					players$(0,20)="1"
					For p=1 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$					
							sendGameCommand(4, 0, p, 20)
						End If
					Next
					
				End If
				
			Else
				; wait until sync value for all players = true
				
				sync=True
				For p=0 To maxPlayers
					If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
						If players$(p,20)<>"1" ; if i did not receive a sync signal from one of the joined players
							sync=False
						End If
						
					End If
				Next
			
				;addToLog("waiting for sync " + sync)
			
				If sync=True					
					; all players are now in sync and have received the new active player value
	
					activePlayer=Int(players$(0,8))
					
					If Int(players$(0,4))=activePlayer						
						myTurn=True
					End If
	
					; reset vars for next sync action (next player turn)
					gameInSync=True

					For p=0 To maxPlayers
						If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$
							players$(p,20)="0"
						End If
					Next
					
					mouseType=0 ; set mousepointer to default pointer
	
					oldcurTurnTimer=0
					turnTimer=MilliSecs() ; set the turn timer to current ticks timer/resetting it to start
	
					;addToLog("turn timer set "+turnTimer)

				End If

		
			End If

		Else
		
			If nextLevel=True
			
				If doorAnim/3>6
					nextLevel=False
					doorAnim=-6*3
					
					;gameInSync=False
	
				Else

					; draw the doors openening
					DrawImageRect leveldoor(Abs(doorAnim/3)),30,26,0,0,515,442
	
					If doorAnim=0  ; load the next level
						
						; todo: create game end tigger after all levels finished
						currentLevel=currentLevel+1
	
						If currentLevel>5
							gameFinished=True
							
							; exit game loop, will occurs with other players by design without sending quit signal
							players$(0,7)="0"
						End If
						
						If gameFinished=False
							
							loadLevel()
							
							; imprint the board raster onto the level image						
							; draw play field shapes and count the tiles of each player on the board
	
							SetBuffer ImageBuffer(levelbackgrnds) 
	
							;Color levelColR,levelColG,levelColB
					
							plotCol=(levelColR Shl 16)+(levelColG Shl 8) + levelColB
						
							For t=0 To shapeTriangleCnt(0)-1
					
								calcTriangle(shapes(0,t,2),shapes(0,t,0),shapes(0,t,1),0,0)	
				
								If playfield(t)<>-2 ; value -2 is a visibly empty field so don't draw anything there, else, draw the shit
									drawTriangle(4,6,1,plotCol)
								End If
										
							Next
							
							SetBuffer BackBuffer()
							
	
							levelLoaded=True
						
							Select maxInGame							
								Case 0
									minimalLevelScore=Int(minimalLevelScore/1)
								Case 1
									minimalLevelScore=Int(minimalLevelScore/1.2)
								Case 2
									minimalLevelScore=Int(minimalLevelScore/1.4)
								Case 3
									minimalLevelScore=Int(minimalLevelScore/1.7)
							End Select
	
							; each player can place at any pont at the start
							For i=0 To playerCnt-1
								firstShapePlayer(i)=True
								tilesPlayed(i)=0
							Next
							
							plotLevelText(-1,"# Start level "+(currentLevel+1)+" #")
		
							levelScroller$="PLACE "+minimalLevelScore+" TILES"
	
							PlaySound (level_start)
							PlaySound (level_gates)
							
						End If
						
					End If
			
					doorAnim=doorAnim+1
				End If
				
			End If		
				
		End If
		
		printLog(535)
		
		Flip(True)
				
		frameLimitor()

	Wend 

	FlushKeys
	FlushMouse

	PlaySound (game_quit)

	updateHighScores(hostKey$,maxInGame)

	; clea highscores after the update
	For i=0 To playerCnt-1
		playerScore(i)=0
	Next

	plotEndScreen(gameFinished)

	plotHighScores(maxInGame)

	; clear player status for a new game
	For p=0 To maxPlayers
		If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$

			players$(p,6)=""
			players$(p,7)="0"
			players$(p,8)=""
			players$(p,19)=""

		End If
	Next
	
End Function

Function plotLevelText(plr=-1,ltext$="",px=0,py=0,mode=0)

	; mode 0 = text in the middle, wobble and leave screen
	; mode 1 = text from given position, speeds to screen top

	If ltext$<>""
		; add text to show to text buffer
	
		For p=0 To 22
			If levelText$(p)=""
				levelTextSinCnt(p)=0
				levelText$(p)=ltext$
			
				levelposX(p)=px
				levelposY(p)=py
				levelposSpd(p)=-8
				levelTextMode(p)=mode
				
				levelTextSin(p)=0
				levelTextCol(p)=plr
				p=22
			End If
		Next
	End If
	

	For p=0 To 22
		If levelText$(p)<>""
			If levelTextMode(p)=0	
				levelposX(p)=400-(Len(levelText$(p))/2)*25-25
			End If
			
			For ch=1 To Len(levelText$(p))
				If levelTextMode(p)=0
					levelposY(p)=100-Sin(ch*12+levelTextSin(p)/2)*50+Sin(levelTextSinCnt(p))*200
					levelTextSin(p)=levelTextSin(p)+1
				End If
				
				plotLevelFont((ch-1)*26+levelposX(p),levelposY(p),Mid(levelText$(p),ch,1),levelTextCol(p))
				
			Next

			If levelTextMode(p)=0
				levelTextSinCnt(p)=levelTextSinCnt(p)+2
			
				If levelTextSinCnt(p)>250
					levelText$(p)=""
				End If
			Else
				levelposY(p)=levelposY(p)-levelposSpd(p)
				
				If levelposSpd(p)<8
					levelposSpd(p)=levelposSpd(p)+1
				End If
				
				If levelposY(p)<-20
					levelText$(p)=""
				End If
			End If
			
		End If
	Next
	
End Function

Function plotGameInfo(mx,my, hostKey$,myTurn)

	mItem=-1

	; plot player that is playing
	sh=0
	usedPlayerNumbers$=""
	playersInGame=0
	
	maxInGame=0 ; max players from host
	
	For p=0 To maxPlayers
	
		If (players$(p,6)=hostKey$ And players$(p,6)<>"") Or players$(p,15)=hostKey$
		
			; get max players in game from host player
			If players$(p,15)=hostKey$
				maxInGame=Int(players$(p,17))
			End If
		
			fnt=fntGame
			
			Select Int(players$(p,4))
				Case 0
					fnt=fntGameYellow
				Case 1
					fnt=fntGameGreen
				Case 2
					fnt=fntGameBlue
				Case 3
					fnt=fntGameRed
			End Select

			myPl$=" "
			If Int(players$(p,4))=activePlayer
				myPl$="*"
			End If
		
			plotBitmapFont(10+(sh/2)*270,539+(sh Mod 2)*26,myPl$+players$(p,2)+":"+ playerScore(Int(players$(p,4))),fnt)
			
			playersInGame=playersInGame+1
			usedPlayerNumbers$=usedPlayerNumbers$+","+players$(p,4)
			sh=sh+1
		
		End If
	
	Next

	; plot computer players:
	For cn=0 To playerCnt-1
		If Instr(usedPlayerNumbers$,Str(cn))<1 And playersInGame<maxInGame+1

			fnt=fntGame

			Select cn
				Case 0
					fnt=fntGameYellow
				Case 1
					fnt=fntGameGreen
				Case 2
					fnt=fntGameBlue
				Case 3
					fnt=fntGameRed
			End Select

			myPl$=" "
			If cn=activePlayer
				myPl$="*"
			End If

			plotBitmapFont(10+(sh/2)*270,539+(sh Mod 2)*26,myPl$+compuNames$(cn)+":"+playerScore(cn),fnt)
			playersInGame=playersInGame+1

			sh=sh+1

		End If
	Next

	If myTurn
		i=plotBitmapFont(590,539,"Skip turn",fntGame,mx,my)
		If i<>-1
			mItem=0
		End If

		i=plotBitmapFont(590,564,"Stop game",fntGame,mx,my)
		If i<>-1
			mItem=1
		End If
	Else
		i=plotBitmapFont(590,539,"Skip turn",fntGame)
		i=plotBitmapFont(590,564,"Stop game",fntGame)
	End If


	; draw level progress bars
	For cn=0 To playerCnt-1

		Select cn
			Case 0
				c=1
			Case 1
				c=2
			Case 2
				c=0
			Case 3
				c=3
		End Select

		psc=tilesPlayed(cn)
		If psc>minimalLevelScore
			psc=minimalLevelScore
		End If

		xs=(497.00/minimalLevelScore)*psc
				
		DrawBlockRect levelScores,558-xs,478+c*10, 497-xs,c*10, xs,10
	
	
		prcnt$=Str(Int((100.00/497)*xs))+Chr$(58)  ; add the % symbol to the number string
		
		For cn2=1 To Len(prcnt$)
			lpx=(Asc(Mid(prcnt$,cn2,1))-48)*8
		
			DrawImageRect levelScores, cn2*8+520,480+c*10, lpx+1,51, 7,6
		Next

	Next

	; draw turn timer

	ptt$=Str(curTurnTimer)
	cent=(3-Len(ptt$)*14)/2
	For cn2=1 To Len(ptt$)
		lpx=(Asc(Mid(ptt$,cn2,1))-48)*14
		
		DrawImageRect levelScores, cn2*14+555+cent,238, lpx+160,44, 13,16
	Next


	Return mItem

End Function

Function setNextPlayer(hostKey$)

	goodNum=False
	isHuman=False
	
	maxInGame=0  ; max players in game from host

	; get current max players in game
	For p=0 To maxPlayers			
		If players$(p,15)=hostKey$ And players$(p,7)="1"
			maxInGame=Int(players$(p,17))
		End If
	Next

	goodNum=False

	Repeat 
		isHuman=False
		
		playersUsed$=""
		
		activePlayer=(activePlayer+1) Mod playerCnt ; add until i found a player active with this number to start with
	
		; build string of players active in the game (only players that joined the game/non-computer players)
		For p=0 To maxPlayers
		
			If (players$(p,6)=hostKey$ Or players$(p,15)=hostKey$) And players$(p,7)="1"  ; joined or host player
				
				playersUsed$=playersUsed$+","+players$(p,4)
			
				If Int(players$(p,4))=activePlayer
	
					isHuman=True
					p=maxPlayers
				End If
			
			End If
		
		Next
	
		; if no human player matches the current active player number set, try to find a computer that does math the number
		If isHuman=False
			If activePlayer<maxInGame+1
				For cn=0 To playerCnt-1
					If Instr(playersUsed$,Str(cn))<1 
						goodNum=True
					End If
				Next
			End If
		Else
			goodNum=True
		End If
	
	Until goodNum=True
	
	players$(0,8)=Str(activePlayer) ; set this player status to It's your turn

	; update all joined players with the new activeplayer var value and broadcast
	For br=0 To maxPlayers
		If players$(br,6)=hostKey$ Or players$(br,15)=hostKey$  ; joined or host player

			players$(br,8)=players$(0,8) ; update all my joined players localy (array) with the new active player number
			
			For p=1 To maxPlayers
				If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$  ; joined or host playes
					sendGameCommand(4, br, p, 8)  ; send out the new active player to all joined players
				End If
			Next
			
		End If
	Next

	; send out the inSync signal to other joined players
	players$(0,20)="1"
	For p=1 To maxPlayers
		If players$(p,6)=hostKey$ Or players$(p,15)=hostKey$					
			sendGameCommand(4, 0, p, 20)
		End If
	Next

	; force send out of current player package when active player is changed
	sendTCPPackages()

	; set iControlComputerNow to true if I have switch to a new player that is not human.
	; all other human players will have this var as false as default. only setnextplayer function can set this var to true
	; when current player quits and is also responsible for the computer player move at this point must stay in the game until a human player is playing again.
	; only then the quit command is executed, not before that.

	Return (isHuman=False)  ; means that if no human is playing, I (this computer) control the computer player moves
End Function


Function checkGameMove$(mx,my,mcnt,shapeRotate,selectedRotation,selectedFlipX,selectedFlipY, fieldOffsetx, fieldOffsety)

	allowed=True ; is this move allowed: does the trinagle shape fit onto the board in this position
	outsideField=False ; is the shape inside the play field

	connected=False  ; test if shape is touching anything of it's own color/player
	badconnect=False ; true if same color touches the other shape directly

	If mcnt<shapeCnt ; only draw shape when there is a shape left to play

		; apply game rules to triangle:
		; check each triangle in the shape selected		
		For t=0 To shapeTriangleCnt(selectedShape)
		
			; calc triangle position and rotate it
			calcTriangle(shapes(selectedShape,t,2)+shapeRotate,shapes(selectedShape,t,0),shapes(selectedShape,t,1),selectedFlipX,selectedFlipY)

			; calc array position from mouse position
			nx=(mx-fieldOffsetx)/(twidth/2)
			ny=(my-fieldOffsety)/theight

			; calc screen x and y pos to place the triangle onto the right grid position		
			tx=nx*(twidth/2)+fieldOffsetx
			ty=ny*theight+fieldOffsety

			; calc triangle array position, don't use the last point to calc the middle
			centerX=((newShape(0,0)+newShape(0,1)+newShape(0,2))/3+tx-fieldOffsetx)/(twidth/2)
			centerY=((newShape(1,0)+newShape(1,1)+newShape(1,2))/3+ty-fieldOffsety)/theight

			If (centerX>0 And centerX<=fieldcols And centerY>-1 And centerY<=fieldrows And my>=fieldOffsety)
		
				; calc array position
				ex=centerY Mod 2
				
				fieldarrPos = (centerX-ex)+centerY*(fieldcols+1) 

				If playfield(fieldarrPos)>-2 ; only look onto field blocks that are or can be used

					; get field triangle rotation
					fieldTrAngle=shapes(0,fieldarrPos,2)
					
					; get shape triangle rotation
					trot=shapes(selectedShape,t,2)+shapeRotate
	
					deltaRot=fieldTrAngle-trot+selectedFlipX

					If deltaRot=-60 Or deltaRot=-180 Or deltaRot=-300 Or deltaRot=300 Or deltaRot=-420 Or deltaRot=-540 Or deltaRot=180 Or deltaRot=60
						; not allowed delta angles: -60,-300,-180,-420,-540,60, 180, 300
						allowed=False
					End If
		
					If playfield(fieldarrPos)>-1 And playfield(fieldarrPos)<4 ; this spot is not available
						allowed=False
					End If
		
					If shapeRotate<>rotationSteps(selectedRotation)
						; object is not yet rotated to correct position
						allowed=False
					End If
		
					; shape may only be placed when at least one triangle is touching corners of the same color, never aside the same color

					; Text 0,t*16,deltaRot + " " + rotationSteps(selectedRotation) + " " + selectedFlipX ; 300 60 180	

					If allowed ; only check if move is still allowed
						; look around the shape on the field
													
						; if the routine below is done and the move is still allowed, the shape indirectly touches another as it should
						For ly=-1 To 1
							For lx=-2 To 2
	
								; rule out some positions that do not need to be tested
								; indirectly possible positions depending on triangle angle
								; 180 = y+1 look x -2 to +2, y-1 look x -1 to 1 (pointing up) valid positions
								; 0 = y+1 look x -1 to 1, y-1 look x -2 to 2 (pointing down) valid positions
								; x=0 y=0 invalid position
								skip=False
								
								If (fieldTrAngle=0 And ly=1 And (lx=-2 Or lx=2)) Or (fieldTrAngle=180 And ly=-1 And (lx=-2 Or lx=2)) Or (lx=0 And ly=0)
									skip=True
								End If
	
								If skip=False
	
									lex = (centerY+ly) Mod 2
								
									newCenterX=(centerX-lex+lx)
									newCenterY=(centerY+ly)
									
									newfieldarrPos = newCenterX+newCenterY*(fieldcols+1)

									; check if there is a shape of the current player touching the new shape									
									If newCenterX>0 And newCenterY>-1 And newCenterX<=fieldcols And newCenterY<=fieldrows
			
										If playfield(newfieldarrPos)=activePlayer
											; check if the touching shape is not directly connected to the new shape
			
											; get field triangle rotation
											newfieldTrAngle=shapes(0,newfieldarrPos ,2)
		
											; if field triangle angle =180 (point up), xpos=0 ypos-1 is directly touching
											If lx=0 And ly=-1 And newfieldTrAngle=180
												; direct hit
												badconnect=True
											End If
									
											; if field triangle angle =0 (point down), xpos=0 ypos+1 is directly touching		
											If lx=0 And ly=1 And newfieldTrAngle=0
												; direct hit
												badconnect=True
											End If
				
											; xpos-1 ypos=0 , directly touching
											If lx=-1 And ly=0
												; direct hit
												badconnect=True
											End If
			
											; xpos+1 ypos=0 , directly touching
											If lx=1 And ly=0
												; direct hit
												badconnect=True
											End If
				
											connected=True ; at least one or more triangles touch the new shape in some way
		
											;Text 0,(a+(t*16))*15, badconnect+ " badc " + connected+ " con" + " x" + lx + " y" + ly
											;a=a+1
																			
										End If

									End If
																
								End If
							
							Next

						Next
						
					End If
		
					; store the fieldposition of the triangle	
					fieldShapePos(t,0) = tx
					fieldShapePos(t,1) = ty
					fieldShapePos(t,2) = fieldarrPos	
				

				Else					
					; if shape position is ontop of a empty field outside the playboard ( value -1 )
					outsideField=True
					allowed=False
				End If
				
			Else
				; If cursor is outside the squere shaped playfield area
				outsideField=True
				allowed=False
			End If
			
		Next

		; if shape is not connecting to same players shape
		If (badconnect=True Or connected=False) And firstShapePlayer(activePlayer)=False ; if player first shape, no conecction is needed
			allowed=False
		End If

	Else
		; when there are no shapes left to place
		allowed=False
		outsideField=True
	End If

	Return Str(allowed) + Str(outsideField)
End Function

Function calcTriangle(angle,offsetx,offsety,angleX,angleY)

	; rotate the offset x and y of the shape
	roffsetx = offsetx * Cos(angle) - offsety * Sin(angle)
	roffsety = offsetx * Sin(angle) + offsety * Cos(angle)	

	; rotate the triangle	
	For cnt=0 To 3
		newShape(0,cnt) = basicTriangle(0,cnt) * Cos(angle) - basicTriangle(1,cnt) * Sin(angle)
		newShape(1,cnt) = basicTriangle(0,cnt) * Sin(angle) + basicTriangle(1,cnt) * Cos(angle)
		
		newShape(0,cnt) = newShape(0,cnt)+roffsetx
		newShape(1,cnt) = newShape(1,cnt)+roffsety
	
		;rot over x ax
		newShape(0,cnt) = newShape(0,cnt) * Cos(angleY)
		
		; rot over y ax
		newShape(1,cnt) = newShape(1,cnt) * Cos(angleX)		
	
	Next
End Function


Function drawTriangle(screenposx,screenposy,mode,col)
	; draw all the lines for the triangle
	LockBuffer BackBuffer()
	LockBuffer FrontBuffer()
	LockBuffer ImageBuffer(levelbackgrnds)

	For c=0 To 2 ; stop at 2 because the line adds 1 to make 2 points (+1 for end point)
		;Line newShape(0,c)+screenposx,newShape(1,c)+screenposy,newShape(0,c+1)+screenposx,newShape(1,c+1)+screenposy
	
		plotLine(newShape(0,c)+screenposx,newShape(1,c)+screenposy,newShape(0,c+1)+screenposx,newShape(1,c+1)+screenposy,mode,col)
	Next
	
	UnlockBuffer ImageBuffer(levelbackgrnds)	
	UnlockBuffer BackBuffer()
	UnlockBuffer FrontBuffer()

End Function

Function plotLine(lx,ly,lx2,ly2,mode,col)
	Local lspx#,lspy#,ldx#,ldy#,lnx#,lny#,lec

	ldx#=Abs(lx-lx2)
	ldy#=Abs(ly-ly2)
	
	If ldx#>ldy#
	
		If lx>lx2
			lspx#=-1.0
		Else
			lspx#=1.0
		End If

		If ly>ly2
			lspy#=-(ldy#/ldx#)
		Else
			lspy#=(ldy#/ldx#)
		End If
		
		lnx#=lx
		lny#=ly
		
		lec=ldx#
	Else

		If lx>lx2
			lspx#=-(ldx#/ldy#)
		Else
			lspx#=(ldx#/ldy#)
		End If
		
		If ly>ly2
			lspy#=-1
		Else
			lspy#=1
		End If

		lnx#=lx
		lny#=ly
		
		lec=ldy#
	End If

	; get rgb from hex color value
	rN=(col Shr 16 And 255)
	gN=(col Shr 8 And 255)
	bN=(col And 255)

	a=( (4278190080)+(rN Shl 16)+(gN Shl 8) + bN )


	If mode=0
		; normal color plot		
		
		For c=0 To lec
		
			If lnx#>1 And lnx#<799 And lny#>1 And lny#<599
			
				WritePixelFast( lnx#,lny#,a )

			End If
		
			lnx#=lnx#+lspx#
			lny#=lny#+lspy#
			
	 	Next

	ElseIf mode=1
		; transparent plot

		For c=0 To lec
		
			If lnx#>1 And lnx#<799 And lny#>1 And lny#<599
			
				a=ReadPixelFast(lnx#,lny# )
				
				rB=(a Shr 16 And 255)+rN Shr 1
				gB=(a Shr 8 And 255)+gN Shr 1
				bB=(a And 255)+bN Shr 1
			
				If rB>255 rB=255
				If gB>255 gB=255
				If bB>255 bB=255
			
				a=( (4278190080)+(rB Shl 16)+(gB Shl 8) + bB )

				WritePixelFast( lnx#,lny#,a )
		
			End If
		
			lnx#=lnx#+lspx#
			lny#=lny#+lspy#
			
	 	Next

	ElseIf mode=2
		; chainline plot

		For c=0 To lec
		
			If lnx#>1 And lnx#<799 And lny#>1 And lny#<599

				rB=rN Shr 1
				gB=gN Shr 1
				bB=bN Shr 1
				
				a1=( (4278190080)+(rB Shl 16)+(gB Shl 8) + bB )

				WritePixelFast( lnx#-1,lny#,a1 )
				
				rB=rN/1.5
				gB=gN/1.5
				bB=bN/1.5
				
				a1=( (4278190080)+(rB Shl 16)+(gB Shl 8) + bB )
				
				WritePixelFast( lnx#-1,lny#-1,a1 )

				rB=rN+c Shr 2
				gB=gN+c Shr 2
				bB=bN+c Shr 2
				
				a1=( (4278190080)+(rB Shl 16)+(gB Shl 8) + bB )

				WritePixelFast( lnx#+1,lny#-1,a1 )

			End If
		
			lnx#=lnx#+lspx#
			lny#=lny#+lspy#
			
	 	Next

	EndIf

End Function


Function drawGameIcon(fieldOffsetx,fieldOffsety,shapeAngle, iconNum)

	;drawTriangle(fieldOffsetx,fieldOffsety)

	centerX=((newShape(0,0)+newShape(0,1)+newShape(0,2))/3+fieldOffsetx)
	centerY=((newShape(1,0)+newShape(1,1)+newShape(1,2))/3+fieldOffsety)

	spriteNum=0

	Select iconNum

		Case 0
			spriteNum=1
		Case 1
			spriteNum=2
		Case 2
			spriteNum=3
		Case 3
			spriteNum=4

		Case 4
			spriteNum=5
		Case 5
			spriteNum=6
		Case 6
			spriteNum=7

	End Select

	If spriteNum>-1
	
		If shapeAngle<>0
			centerX=centerX-12
			centerY=centerY-15
	
			; triangle pointing up
			DrawImageRect gameSprites,centerX,centerY, 1,spriteNum*24+1, 25,23
		Else
			centerX=centerX-12
			centerY=centerY-8
	
			; triangle pointing down
			DrawImageRect gameSprites,centerX,centerY, 27,spriteNum*24+1, 25,23
		
		End If
;	Else
;		Text centerX+6,centerY+4,iconNum
	End If

End Function

Function drawPlayerShapes(px,py,pk)

	poffx=740
	poffy=0

	gx=9999
	gy=9999
	
	gxw=0
	gyw=0

	oldSelected=selectedShape

	For s=1 To shapeCnt-1
		If playerShapesCnt(activePlayer,s)>-1

			plotCol=0
			Select activePlayer
				Case 0:
					;Color 255,255,0
					plotCol=16776960
				Case 1:
					;Color 0,255,0
					plotCol=65280
				Case 2:
					;Color 0,100,255
					plotCol=25855
				Case 3:
					;Color 255,0,0
					plotCol=16711680
			End Select
												
			gx=9999
			gy=9999
			
			gxw=0
			gyw=0

			r=0
			
			sc#=1.8
			
			If s=selectedShape
				sc#=1.3
				;Color 255,255,255
				plotCol=16777215
				
				r=psrot

			End If
			
			For t=0 To shapeTriangleCnt(s)
			
				; calc triangle position and rotate it
				calcTriangle(shapes(s,t,2)+r,shapes(s,t,0),shapes(s,t,1),r,0)
		
				; scale down the triangle size
				For ds=0 To 3
					newShape(0,ds)=newShape(0,ds)/sc#
					newShape(1,ds)=newShape(1,ds)/sc#
				Next
		
				nx=poffx-(s Mod 2)*65
				ny=(s*20)+poffy
		
				drawTriangle(nx,ny,1,plotCol)
			
				; get the smallest point and the biggest point of the shape by checking each triangle in the shape

				For c=0 To 3
					If gx>(newShape(0,c)+nx)
						gx=(newShape(0,c)+nx)
					End If

					If gy>(newShape(1,c)+ny)
						gy=(newShape(1,c)+ny)
					End If

					If gxw<(newShape(0,c)+nx)
						gxw=(newShape(0,c)+nx)
					End If

					If gyw<(newShape(1,c)+ny)
						gyw=(newShape(1,c)+ny)
					End If

				Next
	
			Next

			; -5  on the top of the y of the object to make it more clickable
			If px>gx And px<gxw And py>gy-5 And py<gyw And pk=1
				selectedShape=s
			End If

			;Color 255,0,0
			;Plot gx,gy
			
			;Color 0,100,255
			;Plot gxw,gyw

		End If
	Next

	psrot=psrot+2
	
	Return selectedShape<>oldSelected
End Function

Function createSingleTriangle()
	; single triangle coordinates, used for all other triangles
	
	basicTriangle(0,0)=0
	basicTriangle(1,0)=0
	
	basicTriangle(0,1)=twidth
	basicTriangle(1,1)=0
	
	basicTriangle(0,2)=twidth/2
	basicTriangle(1,2)=theight
	
	basicTriangle(0,3)=0
	basicTriangle(1,3)=0
End Function

Function plotHighScores(maxInGame=0)
	
	doScreenTransition(highscorebck, 0, 1000)
	
	keyp=0
	but=0

	posx=-270
	scrNum=maxInGame
	spd=25
	pcnt=-10
	
	While keyp=0 And but=0
		keyp=GetKey()
		but=GetMouse()

		DrawBlock highscorebck,0,0

		spd=spd-1

		If spd>0
			posx=posx+spd
			
			If posx>800
				scrNum=(scrNum+1) Mod 4
				
				posx=-270
				spd=25
				pcnt=-10
			End If
			
		Else If spd<-400
			spd=41
		End If

		plotLevelFont(posx,50,"highscore for "+(scrNum+1)+" player games")
		
		For l=0 To 9	
			sline$=Left(highscores$(scrNum,l,0)+"...................",14)+Right(".........."+highscores$(scrNum,l,1),6)

			psin=Sin(pcnt/3+l*10)*25+100
			pcnt=pcnt+1
	
			plotLevelFont(posx+psin,130+l*40,sline$,l/3)
		Next

		plotMouse(MouseX(),MouseY())

		Flip(True)
		
		frameLimitor()

	Wend

End Function

Function frameCounter()

	fpsCount=fpsCount+1
	
	If MilliSecs()>=fpsTimer
		fps=fpsCount-oldFpsCount
		 
		oldFpsCount=fpsCount
		fpsTimer=MilliSecs()+1000
	
	End If

	Return fps 
End Function

Function frameLimitor()
	
	If (MilliSecs()-Lmt_Frame_begin)<Lmt_Frametime And Lmt_Frame_begin<>-1
		Delay Lmt_Frametime-(MilliSecs()-Lmt_frame_begin)
	End If
	
	Lmt_Frame_begin=MilliSecs()

End Function

Function loadLevel()
	
	filein = ReadFile("data\level"+currentLevel+".dat")

	If Not filein
		filein = ReadFile("data\level0.dat")
	End If
	
	For t=0 To shapeTriangleCnt(0)-1
		; load the playfield array values here
		playfield(t)=ReadInt( filein ) 
	Next

	; load the level picture filename
	levelfile$=ReadString(filein)

	levelbackgrnds = LoadImage("img_"+config\theme+"\"+levelfile$)
	MaskImage levelbackgrnds,49,49,49

	; load the amount of shapes for this level for each player
	playerShapesCnt(0,0)=-1 ; 0 of field shape
	playerShapesCnt(1,0)=-1 ; 0 of field shape
	playerShapesCnt(2,0)=-1 ; 0 of field shape
	playerShapesCnt(3,0)=-1 ; 0 of field shape

	For t=1 To 22
	
		amnt=ReadInt( filein)
		For p=0 To playerCnt-1
			playerShapesCnt(p,t)=amnt
		Next
		
	Next

	levelColR=ReadByte(filein)
	levelColG=ReadByte(filein)
	levelColB=ReadByte(filein)

	; load minimal score to get to pass this level
	minimalLevelScore=ReadInt( filein)

	CloseFile(filein)

End Function

Function updateHighScores(hostKey$,maxInGame)
	; load current highscore

	filein = ReadFile("data\highscores.dat")

	If filein

		For h=0 To 3
		
			For l=0 To 9
			
				name$=ReadString(filein)
				score=ReadInt(filein)
	
				highscores$(h,l,0)=name$
				highscores$(h,l,1)=Str(score)
			Next
		
		Next

		CloseFile(filein)

	End If	

	; insert current players into the highscore

	scr=10

	For br=0 To maxPlayers
		If players$(br,6)=hostKey$ Or players$(br,15)=hostKey$  ; joined or host player

			If playerScore( Int(players$(br,4)) )>0
			
				highscores$(maxInGame,scr,0)=players$(br,2)
				highscores$(maxInGame,scr,1)=Str( playerScore( Int(players$(br,4)) ) )

				scr=scr+1
			End If
			
		End If
	Next

	; sort the shit
	For l=0 To 13

		For l2=0 To 13

			If Int(highscores$(maxInGame,l,1))>=Int(highscores$(maxInGame,l2,1)) And l<>l2
				
				n2$=highscores$(maxInGame,l2,0)
				s2=Int(highscores$(maxInGame,l2,1))
				
				highscores$(maxInGame,l2,0)=highscores$(maxInGame,l,0)
				highscores$(maxInGame,l2,1)=highscores$(maxInGame,l,1)

				highscores$(maxInGame,l,0)=n2$
				highscores$(maxInGame,l,1)=Str(s2)
			End If
		Next

	Next

	; store new highscores

	fileout = WriteFile("data\highscores.dat")

	For h=0 To 3
	
		For l=0 To 9
			WriteString(fileout,highscores$(h,l,0))
			WriteInt( fileout, Int(highscores$(h,l,1)) ) 
		Next
	
	Next

	CloseFile(fileout)	
	
End Function


Function createShapes()
	; first shape is the field itself
	
	For r=0 To fieldrows
	
		f=r Mod 2
	
		For t=0 To fieldcols
			
			If t Mod 2=0 ; tile must be upside up
			
				shapes(0,t+r*(fieldcols+1),0)=twidth*(t/2)-twidth/2+(f*twidth/2)
				shapes(0,t+r*(fieldcols+1),1)=theight*r
				shapes(0,t+r*(fieldcols+1),2)=0
				
			Else ; tile must be upside down

				shapes(0,t+r*(fieldcols+1),0)=-twidth*(t/2)-twidth-(f*twidth/2)
				shapes(0,t+r*(fieldcols+1),1)=-theight*(r+1)
				shapes(0,t+r*(fieldcols+1),2)=180

			End If	
	
		Next	
	Next
	

	; be carefull when moving a triangle in a shape in the y-ax, angle flips will mess-up the position check routine

	; single triangle shape
	shapes(1,0,0)=0
	shapes(1,0,1)=0
	shapes(1,0,2)=0
	
	shapeTriangleCnt(1)=0
	
	; two linked triangles shape
	shapes(2,0,0)=0
	shapes(2,0,1)=0
	shapes(2,0,2)=0
	
	shapes(2,1,0)=0
	shapes(2,1,1)=0
	shapes(2,1,2)=60
	
	shapeTriangleCnt(2)=1
	
	; compleet circle
	shapes(3,0,0)=0
	shapes(3,0,1)=0
	shapes(3,0,2)=0
	
	shapes(3,1,0)=0
	shapes(3,1,1)=0
	shapes(3,1,2)=60
	
	shapes(3,2,0)=0
	shapes(3,2,1)=0
	shapes(3,2,2)=120
	
	shapes(3,3,0)=0
	shapes(3,3,1)=0
	shapes(3,3,2)=180
	
	shapes(3,4,0)=0
	shapes(3,4,1)=0
	shapes(3,4,2)=240
	
	shapes(3,5,0)=0
	shapes(3,5,1)=0
	shapes(3,5,2)=300
	
	shapeTriangleCnt(3)=5
	
	; big triangle
	shapes(4,0,0)=0
	shapes(4,0,1)=0
	shapes(4,0,2)=0
	
	shapes(4,1,0)=0
	shapes(4,1,1)=0
	shapes(4,1,2)=60
	
	shapes(4,2,0)=twidth/2
	shapes(4,2,1)=-theight
	shapes(4,2,2)=60
	
	shapes(4,3,0)=-twidth
	shapes(4,3,1)=0
	shapes(4,3,2)=180
	
	shapeTriangleCnt(4)=3
	
	; 3 triangles as a row
	shapes(5,0,0)=0
	shapes(5,0,1)=0
	shapes(5,0,2)=0
	
	shapes(5,1,0)=0
	shapes(5,1,1)=0
	shapes(5,1,2)=60
	
	shapes(5,2,0)=twidth/2
	shapes(5,2,1)=-theight
	shapes(5,2,2)=60
	
	shapeTriangleCnt(5)=2
	
	; 4 triangles as a row
	shapes(6,0,0)=0
	shapes(6,0,1)=0
	shapes(6,0,2)=0
	
	shapes(6,1,0)=0
	shapes(6,1,1)=0
	shapes(6,1,2)=60
	
	shapes(6,2,0)=twidth/2
	shapes(6,2,1)=-theight
	shapes(6,2,2)=60
	
	shapes(6,3,0)=twidth
	shapes(6,3,1)=0
	shapes(6,3,2)=0
	
	shapeTriangleCnt(6)=3
	
	; 5 triangles as a row
	shapes(7,0,0)=0
	shapes(7,0,1)=0
	shapes(7,0,2)=0
	
	shapes(7,1,0)=0
	shapes(7,1,1)=0
	shapes(7,1,2)=60
	
	shapes(7,2,0)=twidth/2
	shapes(7,2,1)=-theight
	shapes(7,2,2)=60
	
	shapes(7,3,0)=twidth
	shapes(7,3,1)=0
	shapes(7,3,2)=0
	
	shapes(7,4,0)=-twidth*2-twidth/2
	shapes(7,4,1)=-theight
	shapes(7,4,2)=180
	
	shapeTriangleCnt(7)=4
	
	; 6 triangles as a row
	shapes(8,0,0)=0
	shapes(8,0,1)=0
	shapes(8,0,2)=0
	
	shapes(8,1,0)=0
	shapes(8,1,1)=0
	shapes(8,1,2)=60
	
	shapes(8,2,0)=twidth/2
	shapes(8,2,1)=-theight
	shapes(8,2,2)=60
	
	shapes(8,3,0)=twidth
	shapes(8,3,1)=0
	shapes(8,3,2)=0
	
	shapes(8,4,0)=-twidth*2-twidth/2
	shapes(8,4,1)=-theight
	shapes(8,4,2)=180
	
	shapes(8,5,0)=twidth*2
	shapes(8,5,1)=0
	shapes(8,5,2)=0
	
	shapeTriangleCnt(8)=5

	; boat shape triangle
	shapes(9,0,0)=0
	shapes(9,0,1)=0
	shapes(9,0,2)=0
	
	shapes(9,1,0)=0
	shapes(9,1,1)=0
	shapes(9,1,2)=60
	
	shapes(9,2,0)=twidth/2
	shapes(9,2,1)=-theight
	shapes(9,2,2)=60
	
	shapes(9,3,0)=twidth
	shapes(9,3,1)=0
	shapes(9,3,2)=0
	
	shapes(9,4,0)=-twidth*2-twidth/2
	shapes(9,4,1)=-theight
	shapes(9,4,2)=180
	
	shapes(9,5,0)=twidth/2
	shapes(9,5,1)=theight
	shapes(9,5,2)=0
	
	shapeTriangleCnt(9)=5

	; misformed boat shape triangle
	shapes(10,0,0)=0
	shapes(10,0,1)=0
	shapes(10,0,2)=60
	
	shapes(10,1,0)=-twidth
	shapes(10,1,1)=0
	shapes(10,1,2)=0
	
	shapes(10,2,0)=-twidth
	shapes(10,2,1)=0
	shapes(10,2,2)=240

	shapes(10,3,0)=-twidth-twidth/2
	shapes(10,3,1)=-theight
	shapes(10,3,2)=180

	shapes(10,4,0)=twidth
	shapes(10,4,1)=0
	shapes(10,4,2)=0

	shapes(10,5,0)=-twidth/2
	shapes(10,5,1)=theight
	shapes(10,5,2)=0

	shapeTriangleCnt(10)=5

	; compleet circle minus 1 triangle
	shapes(11,0,0)=0
	shapes(11,0,1)=0
	shapes(11,0,2)=0
	
	shapes(11,1,0)=0
	shapes(11,1,1)=0
	shapes(11,1,2)=60
	
	shapes(11,2,0)=0
	shapes(11,2,1)=0
	shapes(11,2,2)=120
	
	shapes(11,3,0)=0
	shapes(11,3,1)=0
	shapes(11,3,2)=180
	
	shapes(11,4,0)=0
	shapes(11,4,1)=0
	shapes(11,4,2)=300
	
	shapeTriangleCnt(11)=4
	
	; compleet circle minus 2 triangles
	shapes(12,0,0)=0
	shapes(12,0,1)=0
	shapes(12,0,2)=0
	
	shapes(12,1,0)=0
	shapes(12,1,1)=0
	shapes(12,1,2)=60
	
	shapes(12,2,0)=0
	shapes(12,2,1)=0
	shapes(12,2,2)=120
	
	shapes(12,3,0)=0
	shapes(12,3,1)=0
	shapes(12,3,2)=180
	
	shapeTriangleCnt(12)=3

	; misformed small boat shape triangle
	shapes(13,0,0)=0
	shapes(13,0,1)=0
	shapes(13,0,2)=60
	
	shapes(13,1,0)=-twidth
	shapes(13,1,1)=0
	shapes(13,1,2)=0
	
	shapes(13,2,0)=-twidth
	shapes(13,2,1)=0
	shapes(13,2,2)=240

	shapes(13,3,0)=-twidth-twidth/2
	shapes(13,3,1)=-theight
	shapes(13,3,2)=180

	shapes(13,4,0)=-twidth/2
	shapes(13,4,1)=theight
	shapes(13,4,2)=0

	shapeTriangleCnt(13)=4

	; compleet circle minus 1 triangle plus 1 triangle tale
	shapes(14,0,0)=0
	shapes(14,0,1)=0
	shapes(14,0,2)=0
	
	shapes(14,1,0)=0
	shapes(14,1,1)=0
	shapes(14,1,2)=60
	
	shapes(14,2,0)=0
	shapes(14,2,1)=0
	shapes(14,2,2)=120
	
	shapes(14,3,0)=0
	shapes(14,3,1)=0
	shapes(14,3,2)=180
	
	shapes(14,4,0)=0
	shapes(14,4,1)=0
	shapes(14,4,2)=300

	shapes(14,5,0)=-twidth/2
	shapes(14,5,1)=theight
	shapes(14,5,2)=240
	
	shapeTriangleCnt(14)=5

	; compleet circle minus 2 triangle plus 1 triangle tale
	
	shapes(15,0,0)=0
	shapes(15,0,1)=0
	shapes(15,0,2)=0
	
	shapes(15,1,0)=0
	shapes(15,1,1)=0
	shapes(15,1,2)=60
	
	shapes(15,2,0)=0
	shapes(15,2,1)=0
	shapes(15,2,2)=120
	
	shapes(15,3,0)=0
	shapes(15,3,1)=0
	shapes(15,3,2)=300

	shapes(15,4,0)=-twidth/2
	shapes(15,4,1)=theight
	shapes(15,4,2)=240
	
	shapeTriangleCnt(15)=4

	; 5 triangles as a row plus 1 triangle
	shapes(16,0,0)=0
	shapes(16,0,1)=0
	shapes(16,0,2)=0
	
	shapes(16,1,0)=0
	shapes(16,1,1)=0
	shapes(16,1,2)=60
	
	shapes(16,2,0)=twidth/2
	shapes(16,2,1)=-theight
	shapes(16,2,2)=60
	
	shapes(16,3,0)=twidth
	shapes(16,3,1)=0
	shapes(16,3,2)=0
	
	shapes(16,4,0)=-twidth*2-twidth/2
	shapes(16,4,1)=-theight
	shapes(16,4,2)=180
	
	shapes(16,5,0)=-twidth/2
	shapes(16,5,1)=theight
	shapes(16,5,2)=0
	
	shapeTriangleCnt(16)=5

	; misformed small boat shape triangle plus 1 triangle
	shapes(17,0,0)=0
	shapes(17,0,1)=0
	shapes(17,0,2)=60
	
	shapes(17,1,0)=-twidth
	shapes(17,1,1)=0
	shapes(17,1,2)=0
	
	shapes(17,2,0)=-twidth
	shapes(17,2,1)=0
	shapes(17,2,2)=240

	shapes(17,3,0)=-twidth-twidth/2
	shapes(17,3,1)=-theight
	shapes(17,3,2)=180

	shapes(17,4,0)=-twidth/2
	shapes(17,4,1)=theight
	shapes(17,4,2)=0

	shapes(17,5,0)=twidth/2
	shapes(17,5,1)=theight
	shapes(17,5,2)=60

	shapeTriangleCnt(17)=5

	; compleet circle minus 1 triangle plus 1 triangle tale - as a rocket
	shapes(18,0,0)=0
	shapes(18,0,1)=0
	shapes(18,0,2)=0
	
	shapes(18,1,0)=0
	shapes(18,1,1)=0
	shapes(18,1,2)=60
	
	shapes(18,2,0)=0
	shapes(18,2,1)=0
	shapes(18,2,2)=120
	
	shapes(18,3,0)=0
	shapes(18,3,1)=0
	shapes(18,3,2)=180
	
	shapes(18,4,0)=0
	shapes(18,4,1)=0
	shapes(18,4,2)=300

	shapes(18,5,0)=-twidth/2
	shapes(18,5,1)=theight
	shapes(18,5,2)=0
	
	shapeTriangleCnt(18)=5

	; compleet circle minus 1 triangle plus 1 triangle tale
	shapes(19,0,0)=0
	shapes(19,0,1)=0
	shapes(19,0,2)=0
	
	shapes(19,1,0)=0
	shapes(19,1,1)=0
	shapes(19,1,2)=60
	
	shapes(19,2,0)=0
	shapes(19,2,1)=0
	shapes(19,2,2)=120
	
	shapes(19,3,0)=0
	shapes(19,3,1)=0
	shapes(19,3,2)=180
	
	shapes(19,4,0)=0
	shapes(19,4,1)=0
	shapes(19,4,2)=300

	shapes(19,5,0)=twidth/2
	shapes(19,5,1)=-theight
	shapes(19,5,2)=60
	
	shapeTriangleCnt(19)=5


	; compleet circle minus 2 triangles plus 2 triangle tales
	shapes(20,0,0)=0
	shapes(20,0,1)=0
	shapes(20,0,2)=0
	
	shapes(20,1,0)=0
	shapes(20,1,1)=0
	shapes(20,1,2)=60
	
	shapes(20,2,0)=0
	shapes(20,2,1)=0
	shapes(20,2,2)=120
	
	shapes(20,3,0)=-twidth/2
	shapes(20,3,1)=theight
	shapes(20,3,2)=60
	
	shapes(20,4,0)=0
	shapes(20,4,1)=0
	shapes(20,4,2)=300

	shapes(20,5,0)=twidth/2
	shapes(20,5,1)=-theight
	shapes(20,5,2)=0
	
	shapeTriangleCnt(20)=5


	; misformed small boat shape triangle plus 1 triangle
	shapes(21,0,0)=0
	shapes(21,0,1)=0
	shapes(21,0,2)=60
	
	shapes(21,1,0)=-twidth-twidth/2
	shapes(21,1,1)=theight
	shapes(21,1,2)=0
	
	shapes(21,2,0)=-twidth
	shapes(21,2,1)=0
	shapes(21,2,2)=240

	shapes(21,3,0)=-twidth-twidth/2
	shapes(21,3,1)=-theight
	shapes(21,3,2)=180

	shapes(21,4,0)=-twidth/2
	shapes(21,4,1)=theight
	shapes(21,4,2)=0

	shapes(21,5,0)=twidth/2
	shapes(21,5,1)=theight
	shapes(21,5,2)=60

	shapeTriangleCnt(21)=5


	; 2 triangles as a row plus 2 triangles sticking out
	shapes(22,0,0)=0
	shapes(22,0,1)=0
	shapes(22,0,2)=0
	
	shapes(22,1,0)=0
	shapes(22,1,1)=0
	shapes(22,1,2)=60
	
	shapes(22,2,0)=-twidth/2
	shapes(22,2,1)=-theight
	shapes(22,2,2)=60
	
	shapes(22,3,0)=-twidth
	shapes(22,3,1)=0 
	shapes(22,3,2)=120

	shapes(22,4,0)=twidth/2
	shapes(22,4,1)=-theight
	shapes(22,4,2)=0

	shapes(22,5,0)=-twidth-twidth/2
	shapes(22,5,1)=-theight
	shapes(22,5,2)=180
	
	shapeTriangleCnt(22)=5
	
End Function


; --------------------------------------- end of game functions --------------------------------------------------



; --------------------------------------- start of menu functions -------------------------------------------------


Function runGameMenu()
	
	recKeyInput=0  ; used to detect wanted input to form a string char by char
	gameStart=False

	mouseType=0

	While kinp<>27
	
		DrawBlock menuBack,0,0
		
		kinp=GetKey()
		
		mx=MouseX()
		my=MouseY()
		button=GetMouse() ; but nr that is pressed

		; get info from other players
		checkNetwork()
	
		mItem=showMenuInfo(mx,my)

		plotMouse(mx,my, mouseType)

		If button=1 And recKeyInput=0

			Select mItem
			
				Case 0  ; connect via lan/wan
					PlaySound(txt_select)

					addToLog("switch network. Current: "+players$(0,16))

					If players$(0,16)="0"  ; switch to wan connection

						If players$(0,14)="    "  ; is empty /no ip value yet
							myInternetIP$=WanIP$()
							
							; if i have got an internet ip connection thingy
							If myInternetIP$<>""
								closeTCPSession()
								
								players$(0,14)=convertDottedIPToAscStr$(myInternetIP$)
								players$(0,16)="1"
							
								addToLog("wan ip set and network switched to 1")
							End If
						
						Else
							closeTCPSession()
							
							players$(0,16)="1"
						
							addToLog("network switched to 1")
						End If
					
					Else	; switch to lan connection
						closeTCPSession()
						
						players$(0,16)="0"
					End If
		
		
				Case 1	; host ip
					PlaySound(txt_select)
				 
					recKeyInput=mItem
					
					closeTCPSession()
				Case 2 ; connect to host
					PlaySound(txt_select)
					
					;mouseType=2 ; set mouse pointer to connecting
					
					addToLog("looking for host")
					lookForHosts(myHostIP$,serverPortStart,serverPortEnd)
					
				Case 3 ; game name
					PlaySound(txt_select)
					
					recKeyInput=mItem
					
				Case 4 ; max allowd player
					PlaySound(txt_select)
					
					players$(0,17)=Str( (Int(players$(0,17))+1) Mod 4 )

					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 17)
						End If
					Next
					
				Case 5 ; am i hosting a game				
					PlaySound(txt_select)
					
					If players$(0,5)="0"
						players$(0,5)="1"
						players$(0,6)="" ; unjoin me from any game if i start hosting
						
						addToLog("hosting a game")
					Else
						players$(0,5)="0"
						addToLog("not hosting a game")
					End If
					
					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 5)
							sendGameCommand(4, 0, p, 6)
						
							If players$(0,5)="0" ; if i stopped hosting, remove joined player from my game
								If players$(p,6)=players$(0,15)
									
									players$(p,6)="" ; unjoin other player and broadcast that setting to everyone
									For br=1 To maxPlayers
										If players$(br,15)<>""
											sendGameCommand(4, p, br, 6)
										End If
									Next
								
								End If
							End If
							
						End If
					Next
						
				Case 6 ; chat
					PlaySound(txt_select)

					recKeyInput=mItem
						
				Case 7 ; player name
					PlaySound(txt_select)
					
					recKeyInput=mItem
		
				Case 8 ; player color
					;PlaySound(txt_select)
					
					;players$(0,4)=Str$( (Int(players$(0,4))+1) Mod 4)
				
					; send updated item to all connected players
					;For p=1 To maxPlayers
					;	If players$(p,15)<>""
					;		sendGameCommand(4, 0, p, 4)
					;	End If
					;Next
		
				Case 9  ; start game
					PlaySound(txt_select)
					
					players$(0,7)="1"
					
					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 7)
						
							If players$(p,6)=players$(0,15)  ; if player is joined to this game, set it's start status and broadcast it
								players$(p,7)="1"
								
								For br=1 To maxPlayers
									If players$(br,15)<>""
										sendGameCommand(4, p, br, 7)
									End If
								Next
							End If
						End If
					Next
						
				Case 10  ; quit game
					PlaySound(txt_select)
					
					gameStart=False
					kinp=27
			End Select
					
			; click on a hosted game / join
			If mItem>10
				PlaySound(txt_select)
				
				players$(0,5)="0"  ; stop hosting
				players$(0,6)=players$(mItem-10,15) ; start joining
				; send updated item to all connected players
				For p=1 To maxPlayers
					If players$(p,15)<>""

						sendGameCommand(4, 0, p, 6)
						sendGameCommand(4, 0, p, 5)

						If players$(p,6)=players$(0,15)
							
							players$(p,6)="" ; unjoin other player and broadcast that setting to everyone
							For br=1 To maxPlayers
								If players$(br,15)<>""
									sendGameCommand(4, p, br, 6)
								End If
							Next
						
						End If

					End If
				Next
		
			End If
					
		End If
	
		; check if I or the host has started the game
		If players$(0,7)="1"
		 	kinp=27
			gameStart=True
		End If			

		; record key's if needed for input
		Select recKeyInput
	
			Case 1 ; host ip
				mouseType=4
					
				If (Upper(Chr(kinp))=>"0" And Upper(Chr(kinp))=<"9") Or (Upper(Chr(kinp))=".")
					PlaySound(txt_key)
					
					If Len(myHostIP$)<15
						myHostIP$=myHostIP$+Chr(kinp)
					End If
				Else If kinp=8 ; backspace
					PlaySound(txt_key)
					
					If Len(myHostIP$)>0
						myHostIP$=Left(myHostIP$,Len(myHostIP$)-1)
					End If
				Else If kinp=13 And Len(myHostIP$)>0 ; enter
					PlaySound(txt_enter)

					mouseType=0
					recKeyInput=0
				End If
				
			Case 3 ; game name
				mouseType=4
		
				If (Upper(Chr(kinp))=>"A" And Upper(Chr(kinp))=<"Z") Or (Upper(Chr(kinp))=>"0" And Upper(Chr(kinp))=<"9") Or Upper(Chr(kinp))=" "
					PlaySound(txt_key)
					
					If Len(players$(0,3))<10
						players$(0,3)=players$(0,3)+Chr(kinp)
					End If
				Else If kinp=8 ; backspace
					PlaySound(txt_key)
					
					If Len(players$(0,3))>0
						players$(0,3)=Left(players$(0,3),Len(players$(0,3))-1)
					End If
				Else If kinp=13 And Len(players$(0,3))>0 ; enter
					PlaySound(txt_enter)

					mouseType=0
					recKeyInput=0
					
					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 3)
						End If
					Next
					
				End If

			Case 6 ; chat
				mouseType=4
				
				If (Upper(Chr(kinp))=>"A" And Upper(Chr(kinp))=<"Z") Or (Upper(Chr(kinp))=>"0" And Upper(Chr(kinp))=<"9") Or Upper(Chr(kinp))=" "
					PlaySound(txt_key)
					
					If Len(players$(0,18))<10
						players$(0,18)=players$(0,18)+Chr(kinp)
					End If
				Else If kinp=8 ; backspace
					PlaySound(txt_key)
					
					If Len(players$(0,18))>0
						players$(0,18)=Left(players$(0,18),Len(players$(0,18))-1)
					End If
				Else If kinp=13 And Len(players$(0,18))>0 ; enter
					PlaySound(txt_enter)

					mouseType=0
					recKeyInput=0
					
					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 18)
						End If
					Next
					
				End If
	
			Case 7 ; rec the key's for my players name
				mouseType=4
					
				If (Upper(Chr(kinp))=>"A" And Upper(Chr(kinp))=<"Z") Or (Upper(Chr(kinp))=>"0" And Upper(Chr(kinp))=<"9") Or Upper(Chr(kinp))=" "
					PlaySound(txt_key)
					
					If Len(players$(0,2))<10
						players$(0,2)=players$(0,2)+Chr(kinp)
					End If
				Else If kinp=8 ; backspace
					PlaySound(txt_key)
					
					If Len(players$(0,2))>0
						players$(0,2)=Left(players$(0,2),Len(players$(0,2))-1)
					End If
				Else If kinp=13 And Len(players$(0,2))>0 ; enter
					PlaySound(txt_enter)

					mouseType=0
					recKeyInput=0
					
					; send updated item to all connected players
					For p=1 To maxPlayers
						If players$(p,15)<>""
							sendGameCommand(4, 0, p, 2)
						End If
					Next
					
				End If

		End Select

		;printLog(535)

		Flip(True)

		frameLimitor()

	Wend
	
	Return gameStart
	
End Function

Function showMenuInfo(mx,my)
	; show hosted games available and mark once that are fill and add a dot to the game I have joined
	; show players that joined my game
	; kick me if game is full
	; auto pick my player color/number if in use within a game
	; show my info


	mItem=-1 ; defailt mouse pos set to nothing selected

	menuFont=fntGameGray

	If mx>36 And my>54 And mx<378 And my<376
		menuFont=fntGame
	End If

	con$="lan"
	If players$(0,16)="1"
		con$="wan"
	End If	

	; lan/wan
	plotBitmapFont(25,70,"Network used:",menuFont)
	i=plotBitmapFont(265,70,con$,menuFont,mx,my)
	If i<>-1
		mItem=0
	End If

	; host IP
	plotBitmapFont(25,70+1*19,"Host:",menuFont)
	i=plotBitmapFont(115,70+1*19,myHostIP$,menuFont,mx,my)
	If i<>-1
		mItem=1
	End If

	; Connect to host
	i=plotBitmapFont(25,70+2*19,"Look for open games",menuFont,mx,my)
	If i<>-1
		mItem=2
	End If

	; game name
	plotBitmapFont(25,70+4*19,"Game name:",menuFont)
	i=plotBitmapFont(205,70+4*19,players$(0,3),menuFont,mx,my)
	If i<>-1
		mItem=3
	End If

	; max players in my game
	plotBitmapFont(25,70+5*19,"Players allowed:",menuFont)
	i=plotBitmapFont(315,70+5*19,Str(Int(players$(0,17))+1),menuFont,mx,my)
	If i<>-1
		mItem=4
	End If

	; host this game
	
	ho$="closed"
	If players$(0,5)="1"
		ho$="open"
	End If
	
	plotBitmapFont(25,70+6*19,"This game is:",menuFont)
	i=plotBitmapFont(260,70+6*19,ho$,menuFont,mx,my)
	If i<>-1
		mItem=5
	End If

	; players in the same game (mine or someone else his game)
	plotBitmapFont(25,70+8*19,"Players in game:",menuFont)


	fnt=fntGame	
	Select Int(players$(0,4))
		Case 0
			fnt=fntGameYellow
		Case 1
			fnt=fntGameGreen
		Case 2
			fnt=fntGameBlue
		Case 3
			fnt=fntGameRed
	End Select

	plotBitmapFont(60,70+10*19,players$(0,2),fnt)
	
	chatLine$=""	
	avCol$=players$(0,4)+"," ; record players colors used to prevent double colors
	newCol=0

	playersInGame=0
	usedPlayerNumbers$=players$(0,4)
	maxInGame=0 ; filled with the host game max players in game value
	
	If players$(0,5)="1"  ; hosting
	
		maxInGame=Int(players$(0,17))
		
		i=0
		For p=1 To maxPlayers
			If players$(0,15)=players$(p,6) ; players that joined me
				
				fnt=fntGame	
				Select Int(players$(p,4))
					Case 0
						fnt=fntGameYellow
					Case 1
						fnt=fntGameGreen
					Case 2
						fnt=fntGameBlue
					Case 3
						fnt=fntGameRed
				End Select
								
				plotBitmapFont(60,70+(11+i)*19,players$(p,2),fnt)			
				
				usedPlayerNumbers$=usedPlayerNumbers$+","+players$(p,4)
				playersInGame=playersInGame+1			
	
				; check of player color is used by other player
				If Instr(avCol$,players$(p,4)+",")>0
					While Instr(avCol$,Str(newCol)+",")>0
						newCol=newCol+1
					Wend
					
					players$(p,4)=Str(newCol)
					
					; broadcast player (number p) color change to all players
					For br=1 To maxPlayers
						sendGameCommand(4, p, br, 4)
					Next
				End If
			
				avCol$=avCol$+players$(p,4)+","
				
				i=i+1
			
				If players$(p,18)<>""
					chatLine$=chatLine$+players$(p,2)+": "+players$(p,18)+" "
				End If

			End If
		Next

	Else     ; not hosting
		i=0
		For p=1 To maxPlayers
			If players$(0,6)<>"" And (players$(0,6)=players$(p,6) Or players$(0,6)=players$(p,15)) ; others that joined the same game as me or are hosting it

				; get max players in game from host player
				If players$(0,6)=players$(p,15)
					maxInGame=Int(players$(p,17))
				End If
				
				fnt=fntGame	
				Select Int(players$(p,4))
					Case 0
						fnt=fntGameYellow
					Case 1
						fnt=fntGameGreen
					Case 2
						fnt=fntGameBlue
					Case 3
						fnt=fntGameRed
				End Select				
				
				plotBitmapFont(60,70+(11+i)*19,players$(p,2),fnt)			
				
				usedPlayerNumbers$=usedPlayerNumbers$+","+players$(p,4)
				playersInGame=playersInGame+1
				
				i=i+1
			
				If players$(p,18)<>""
					chatLine$=chatLine$+players$(p,2)+": "+players$(p,18)+" "
				End If
				
			End If
		Next
	End If

	; plot computer names for the players that are not human

	For cn=0 To playerCnt-1
		If Instr(usedPlayerNumbers$,Str(cn))<1 And playersInGame<maxInGame

			fnt=fntGame	
			Select cn
				Case 0
					fnt=fntGameYellow
				Case 1
					fnt=fntGameGreen
				Case 2
					fnt=fntGameBlue
				Case 3
					fnt=fntGameRed
			End Select				

			plotBitmapFont(60,70+(11+playersInGame)*19,compuNames$(cn),fnt)
			playersInGame=playersInGame+1
		End If
	Next
	
	; plot chat tet and clear if all is shown once
	If gameScroller(chatLine$)

		For p=1 To maxPlayers
			players$(p,18)=""
		Next
	
	End If

	; chat
	i=plotBitmapFont(67,70+15*19,"Chat:",menuFont,mx,my)
	If i<>-1
		mItem=6
	End If
	i=plotBitmapFont(155,70+15*19,players$(0,18),menuFont,mx,my)
	If i<>-1
		mItem=6
	End If
	
	menuFont=fntGameGray

	If mx>516 And my>54 And mx<790 And my<232
		menuFont=fntGame
	End If

	; player name
	plotBitmapFont(490,70,"Name:",menuFont)
	i=plotBitmapFont(583,70,players$(0,2),menuFont,mx,my)
	If i<>-1
		mItem=7
	End If

	; player color / number
	pcol$=""
	Select Int(players$(0,4))
		Case 0
			pcol$="Yellow"
		Case 1
			pcol$="Green"
		Case 2
			pcol$="Blue"
		Case 3
			pcol$="Red"
	End Select

	; player color
	plotBitmapFont(510,70+1*19,"Color:",menuFont)
	plotBitmapFont(620,70+1*19,pcol$,menuFont)

	menuFont=fntGameGray

	If mx>10 And my>496 And mx<246 And my<600
		menuFont=fntGame
	End If

	; Start game
	If players$(0,5)<>"1"  ; can't start if i am not hosting
		i=plotBitmapFont(20,75+23*19,"Start game",menuFont)	
	Else
		i=plotBitmapFont(20,75+23*19,"Start game",menuFont,mx,my)
	End If
	
	If i<>-1
		mItem=9
	End If
	
	; Quit game
	i=plotBitmapFont(20,75+25*19,"Main menu",menuFont,mx,my)
	If i<>-1
		mItem=10
	End If


	menuFont=fntGameGray

	If mx>420 And my>365 And mx<780 And my<600
		menuFont=fntGame
	End If

	; games being hosted
	gp=0
	For p=1 To maxPlayers
		If players$(p,5)="1"

			nf=menuFont
			If players$(p,15)=players$(0,6) ; if i have joined this game
				nf=fntGameSel
			End If
			
			gameh$=players$(p,3)
			canj=True
			
			; check if game is already started
			If players$(p,7)="1"
				gameh$=gameh$+" (started)"
				canj=False
			Else
				; check how many players has already joined this game, if is full, no more join
				j=1
				For ch=0 To maxPlayers
					If players$(p,15)=players$(ch,6)
						j=j+1
					End If
				Next
				
				If j>Int(players$(p,17))
					gameh$=gameh$+" (full)"
	
					canj=False
				End If
			
			End If			
			
			If canj
				i=plotBitmapFont(425,80+(16+gp)*19,gameh$,nf,mx,my)
			Else
				i=plotBitmapFont(425,80+(16+gp)*19,gameh$,nf)			
			End If
			
			gp=gp+1

			If i<>-1  ; if selected and able to join this game
				mItem=p+10  ; add 10 because 0 to 10 are other used menu options
			End If
		End If
	Next

	Return mItem
End Function


Function plotLevelFont(posx,posy,vstr$,plr=-1)
	
	Local fnt=levelFont

	Select plr
		
		Case 0
			fnt=levelFont_yellow
		Case 1
			fnt=levelFont_green
		Case 2
			fnt=levelFont_blue
		Case 3
			fnt=levelFont_red
	End Select

	vstr$=Lower(vstr$)
	
	For i=1 To Len(vstr$)
					
		kar2=Asc(Mid(vstr$,i,1))-97
	
		If kar2>-50 And kar2<-39
			kar2=kar2+49+28
		End If
	
		Select kar2
			Case -51
				kar2=27
			Case -65
				kar2=26
			Case -64
				kar2=38
			Case -57
				kar2=39
			Case -56
				kar2=40
			Case -53
				kar2=41
			Case -58
				kar2=42
			Case -34
				kar2=43
			Case -55
				kar2=44
			Case -52
				kar2=45
			Case -62 ; #
				kar2=46
			Case -54 ; +
				kar2=47
		End Select
	
		lposx2 = kar2 Mod 10
		lposy2 = kar2/10

		lposx2 = lposx2 * 32
		lposy2 = lposy2 * 32

		DrawImageRect fnt,posx+(i-1)*26,posy,lposx2,lposy2,32,24
	Next

End Function

Function plotBitmapFont(posx,posy,vstr$,fnt,mx=-1,my=-1)
	vstr$=Upper(vstr$)

	dfnt=fnt
	iItem=-1
	
	If mx<>-1 And my<>-1
	
		If mx>posx+18 And mx<posx+18+Len(vstr$)*18 And my>posy-4 And my<posy+11
			dfnt=fntGameSel
			iItem=0
		End If
	
	End If
	
	For i=1 To Len(vstr$)
					
		kar2=Asc(Mid(vstr$,i,1))-32
	
		lposx2 = kar2 Mod 10
		lposy2 = kar2/10

		lposx2 = lposx2 * 16
		lposy2 = lposy2 * 13

		DrawImageRect dfnt,posx+i*18,posy,lposx2,lposy2,15,13
	Next

	Return iItem
End Function

Function plotMouse(mposx,mposy,mtype=0)

	; plot the mouse a bit down and a bit to the right to make the clicks more look spot on the text or other objects
	DrawImageRect mousePointers,mposx+1,mposy+2,0,0,45,50

	; add something besides the mouse on some events
	Select mtype
	
		Case 0   ; default mouse
			; nothing to add to the mouse
			
		Case 1  ; syncing mouse

			DrawImageRect mousePointers,mposx+1,mposy+55, 0,50, 59,14
		
		Case 2  ; connecting mouse

			DrawImageRect mousePointers,mposx+1,mposy+55, 0,66, 59,14
		
		Case 3  ; switch network type mouse

			DrawImageRect mousePointers,mposx+1,mposy+55, 0,82, 59,14

		Case 4  ; Entering new value type mouse

			DrawImageRect mousePointers,mposx+1,mposy+55, 0,98, 59,12
		
	End Select
	
End Function

; ---------------------------- end of main menu functions ---------------------------------------

; ---------------------------- start of logging tools --------------------

Function addToLog(ln$)
	; buffer log messages
	If writeToLogFile
	
		ln$=Str(MilliSecs())+" "+ln$

		WriteLine( logfile,  ln$)
	
		NetworkLog$="^"+ln$+NetworkLog$
	
		off=1
		p=0
		While off>0 And p<5
			off=Instr(NetworkLog$,"^",off+1)
		
			p=p+1
		Wend
	
		If off>0
			NetworkLog$=Left(NetworkLog$,off)
		End If

	End If

End Function

Function printLog(yoff)

	If writeToLogFile

		p=0
		off=1
		
		;DrawImageRect menuBack,0,400,0,400,800,200
	
		Color 255,100,255
		
		While off>0 And p<5
			n=Instr(NetworkLog$,"^",off+1)
	
			If n>0
				Text 0,p*12+yoff,Mid(NetworkLog$,off+1,n-off-1)
			Else
				Text 0,p*12+yoff,Mid(NetworkLog$,off+1,Len(NetworkLog$)-off)
			End If
			
			off=Instr(NetworkLog$,"^",off+1)
			
			p=p+1
		Wend

		Text 0,0, frameCounter()

	End If
End Function

; ----------------------- end of logging tools --------------------------

; ------------------------ start of network functions ------------------

Function checkNetwork()
	Local newTCPstream=0

	If mytcpServer
		; receive new tcpstream / new player
		newTCPstream = AcceptTCPStream(mytcpServer) ; receive data from a client		
	Else
		addToLog("no server running. starting server")
		
		; start my tcp server and set player 0's ip and port info
		mytcpServer=createHostServer(serverPortStart,serverPortEnd) ; port start and port end number
	End If
	
	If newTCPstream<>0
		; add to connection to client client array
		addNewPlayerConnection(newTCPstream)
	End If

	If MilliSecs()>oldTimerVal+tcpSendInterval
		; send all packages buikd uo inside the sendBank buffer
		sendTCPPackages()
		
		oldTimerVal=MilliSecs()
	End If

	; read all streams collected
	For c=0 To maxPlayers
		receivePackages(c)
	Next	
End Function

Function addNewPlayerConnection(newTCPstream)
	; find free slot for the new stream
	
	streamNum=-1
	For c=1 To maxPlayers
		If tcpStreams(c,0)=0
			; reserver player stream for communication. will have same array pos number as players$ array pos number
			
			tcpStreams(c,0)=newTCPstream ; connection to and from player full duplex usage
			tcpStreams(c,1)=CreateBank(maxGameCommandSize) ; input bank when reading data from host
			tcpStreams(c,2)=0
	
			playerBanks(c,0)=CreateBank(maxGameCommandSize*maxSendPackages)
			playerBanks(c,1)=0

			addToLog(tcpStreams(c,0) + " new con handle on num " + c)

			streamNum=c
			c=maxPlayers
		End If
	Next

	Return streamNum
End Function

Function terminatePlayer(connectionNum)
	; clear out the player data and connection
	; called when eof or when I look for hosts
	
	addToLog("terminating player connections")

	If tcpStreams(connectionNum,0)
		addToLog("closing stream "+tcpStreams(connectionNum,0))
		CloseTCPStream(tcpStreams(connectionNum,0))
	End If
	
	tcpStreams(connectionNum,0)=0
	tcpStreams(connectionNum,1)=0
	tcpStreams(connectionNum,2)=0

	For t=0 To 19
		players$(connectionNum,t)=""
	Next

	playerBanks(connectionNum,0)=0
	playerBanks(connectionNum,1)=0
	
	;Print "player terminated " + connectionNum
	
End Function

Function closeTCPSession()
	; tell everyone I'm leaving now
	
	addToLog("closing current connections")
	
	For p=1 To maxPlayers
		If players$(p,15)<>""
			sendGameCommand(10, 0, p)
			terminatePlayer(p)
		End If
	Next

End Function

Function convertAscStrToDottedIP$(inpStr$)
	IP$=""
	For c=1 To 4
		IP$=IP$+Str(Asc(Mid(inpStr$,c,1)))+"."
	Next
	
	Return Left(IP$,Len(IP$)-1)
End Function

Function convertDottedIPToAscStr$(inpStr$)
	; takes a dotted IP address and converts it to as ascii string without dots
	
	newStr$=""
	
	s_strt=1
	For c=1 To Len(inpStr$)
		If Mid(inpStr$,c,1)="."
			newStr$=newStr$+Chr$(Int(Mid(inpStr$,s_strt,c-s_strt)))		
			
			s_strt=c+1
		End If
	Next
	
	newStr$=newStr$+Chr$(Int(Mid(inpStr$,s_strt,Len(inpStr$)-s_strt+1)))

	Return newStr$
End Function

Function lookForHosts(myHostIP$,portRangeStart,portRangeEnd)

	; disconnect me first before scanning for hosts
	addToLog("start closing connections")
	closeTCPSession()
	
	portnumHost=portRangeStart

	While portnumHost=<portRangeEnd
		
		If portnumHost<>players$(0,1) Or players$(0,0)<>convertDottedIPToAscStr$(myHostIP$) ; must not be the port our own server is running on
			addToLog("scanning "+myHostIP$+":"+portnumHost)

			tcpToHost=OpenTCPStream(myHostIP$,portnumHost)
		
			; if tcp connection made
			If tcpToHost
		
				conNum=addNewPlayerConnection(tcpToHost)
		
				; send out my info so the other side can add me to it's players list and connection list
				sendGameCommand(1, 0, conNum)

				addToLog("a host found on " + myHostIP$ + ":" + portnumHost)
			End If

		End If
		
		portnumHost=portnumHost+1
	Wend

End Function

Function createHostServer(portRangeStart,portRangeEnd)
	; start my tcp server on a free port
	; set player 0's intranet IP and Port value
	
	addToLog("setup tcp server now")

	; setup player unique key
	players$(0,15)=generatePlayerKey$(3)

	; setyp the player server
	portnum=portRangeStart
	tcpServer=0	
	While tcpServer=0 And portnum=<portRangeEnd
		tcpServer=CreateTCPServer(portnum)
		portnum=portnum+1
	Wend
	
	If tcpServer
		portnum=portnum-1
		
		; setup the players ip for intranet (is default setting)
		
		n=CountHostIPs("")
		sIP=HostIP(1)
		myIP$=DottedIP(sIP)
	
		myIP$=convertDottedIPToAscStr$(myIP$)
	
		players$(0,0)=myIP$
		players$(0,14)="    " ; 4 empty bytes here to make the package size always the same
		players$(0,1)=portnum
		players$(0,16)="0" ; by default the player uses the intranet ip
		
		addToLog("server is running on port "+portnum)

		;Print players$(0,15)

		Return tcpServer
	Else
		;Print "unable to create a server."
		addToLog("cant start server")

		
		Return False
	End If
		
End Function

Function createTCPPackage(gameCommand, playerNum, playerKey$="")
	; gamecommand and my player key
	
	sendBankSize=staticBankSizeDigits ; always reserve the first 3 bytes in the start of the package For the package size so start on 3
;Print players$(playerNum,15)
	If playerKey$=""
		playerKey$=players$(playerNum,15)
	End If

	fillTCPPackage(Chr(gameCommand)+playerKey$,playerNum)
End Function

Function fillTCPPackage(package$,playerNum)
	; package data to send
	blen=Len(package$)
	
	For t=1 To blen
		PokeByte(playerBanks(playerNum,0),sendBankSize+t-1+playerBanks(playerNum,1),Asc(Mid(package$,t,1)))
	Next

	sendBankSize=sendBankSize+blen
End Function

Function endTCPPackage(playerNum)
	; store package size into the package first 3 bytes

	; clear the bytes used to write the total package size first:
	
	For c=0 To staticBankSizeDigits-1
		PokeByte(playerBanks(playerNum,0),c+playerBanks(playerNum,1),0)
	Next
	
	; write the total package size digits
	sendBankSize=sendBankSize-staticBankSizeDigits ; don't count the size digits string in the package
	blen=Len(Str(sendBankSize))
	
	For t=1 To blen
		PokeByte(playerBanks(playerNum,0),t-1+playerBanks(playerNum,1),Asc(Mid(Str(sendBankSize),t,1)))
	Next

	; when received, 0 bytes are ignored

	;Print sendBankSize

	; switch back to total package size including the 3 bytes for the package size to send out
	sendBankSize=sendBankSize+staticBankSizeDigits

	; store package to send it out later
	
	; keep track of next position to write to in the package
	playerBanks(playerNum,1)=playerBanks(playerNum,1)+sendBankSize

	; prevent buffer overload
	If playerBanks(playerNum,1)>(maxSendPackages-2)*maxGameCommandSize
		; send all packages buikd uo inside the sendBank buffer
		sendTCPPackages()
		
		oldTimerVal=MilliSecs()	
	End If
	

End Function

Function sendTCPPackages()
	; send all acummulated packages slices per player

	For p=0 To maxPlayers
	
		If playerBanks(p,1)>0
		
			toServer=tcpStreams(p,0)
		
			If toServer
				s=WriteBytes(playerBanks(p,0),toServer,0,playerBanks(p,1))
				
				If s<>playerBanks(p,1)
					addToLog("send pack failed!: "+s + " must be "+playerBanks(p,1))
				End If
								
			End If
			
			playerBanks(p,1)=0
		End If

	Next

End Function

Function receivePackages(connectionNum)
	; don't use sendBankSize because this var will increase after the package start point is writen

	If tcpStreams(connectionNum,0)<>0
		
		If Not Eof(tcpStreams(connectionNum,0))
		
			breceived=ReadAvail(tcpStreams(connectionNum,0))
			
			If breceived>staticBankSizeDigits-1 And tcpStreams(connectionNum,2)=0 ; if no known package size, read package size first

				r=ReadBytes(tcpStreams(connectionNum,1),tcpStreams(connectionNum,0),0,staticBankSizeDigits)
				
				l$=""
				For i=0 To staticBankSizeDigits-1
					a=PeekByte(tcpStreams(connectionNum,1),i)
				
					If a>0
						l$=l$+Chr(a)
					End If
				Next
				
				tcpStreams(connectionNum,2)=Int(l$)
				
				;Print tcpStreams(connectionNum,2)
				
			Else If tcpStreams(connectionNum,2)>0 And breceived=>tcpStreams(connectionNum,2)
				; package size is know, read entire package when all bytes are received
			
				r=ReadBytes(tcpStreams(connectionNum,1),tcpStreams(connectionNum,0),0,tcpStreams(connectionNum,2))

				If r=tcpStreams(connectionNum,2)					
					parsePackage(connectionNum)
				End If
	
				; package is read, reset the package size to 0
				tcpStreams(connectionNum,2)=0		
			End If
		
		Else
			; connection is lost			
			terminatePlayer(connectionNum)
		End If
		
	End If
		
End Function

Function parsePackage(connectionNum)
	
	; senders game command
	gameCommand=PeekByte(tcpStreams(connectionNum,1),0)

	; senders player key	
	klen=Len(players$(0,15))
	senderPlayerKey$=""
	For c=1 To klen
		senderPlayerKey$=senderPlayerKey$+Chr$(PeekByte(tcpStreams(connectionNum,1),c))
	Next
	
	;Print senderPlayerKey$
	
	; get sender package data and parse it as a string
	pack$=""
	For c=klen+1 To tcpStreams(connectionNum,2)-1
		pack$=pack$+Chr$(PeekByte(tcpStreams(connectionNum,1),c))
	Next

	receiveGameCommand(gameCommand, senderPlayerKey$, pack$, connectionNum)
End Function

Function receiveGameCommand(command, senderPlayerKey$, package$, conNum)
	; execute the game command received
	
	;Print "execute received game command " + command + " from "+senderPlayerKey$
	
	Select command
		Case 1 ; add new player data
			;Print "Received add player data request"

			; extract ip's and port info from package received for this game command
			senderIntranetIP$=Left(package$,4)
			senderPort$=Mid(package$,5,4)	
			senderInternetIP$=Mid(package$,9,4)			
			senderUsedInternetIP$=Mid(package$,13,1)			

			; add player data to player array when player is new
			If players$(conNum,15)=""

				addToLog("player data added " + conNum)

				; if player is already known to me on another connection (possible when 2 players send me a connect request) terminate the request now
				
				isnew=True
				For p=0 To maxPlayers
					If senderPlayerKey$=players$(p,15)
						isnew=False
						p=maxPlayers
					End If
				Next
			
				If isnew
	
					If players$(0,16)=senderUsedInternetIP$  ; connection used should be the same to prevent connection problems
		
						; store new player info data
						players$(conNum,0)=senderIntranetIP$
						players$(conNum,1)=senderPort$
						players$(conNum,14)=senderInternetIP$
						players$(conNum,15)=senderPlayerKey$
						players$(conNum,16)=senderUsedInternetIP$
					
						; respond by requesting to add myself to the senders player list (could already be added but just make sure the sender knows me)							
						sendGameCommand(1, 0,conNum)
						
						; broadcast my player list to all players in my list
						For p=1 To maxPlayers
							If players$(p,15)<>""
		
								For p2=1 To maxPlayers
								
									If players$(p2,15)<>"" And p<>p2  ; player must exist and dont send player 3 to player 3 ofcourse
										If players$(p,16)=players$(p2,16) ; source player must use same network as target to prevent connection problems
											
											; don't broadcast to the new player to the just received player 
											If p<>conNum Or p2<>conNum
												;Print "send to " + players$(p2,15) + " to add player " + players$(p,15)
											
												sendGameCommand(5, p, p2) ; send new player
											End If
										
										End If 
									End If
								Next
				
							End If
						Next
						
						; now ask this player for all it's info
						sendGameCommand(2, 0, conNum)
					Else
						; new player received is using the wrong network to connect to me (lan on lan or wan on wan, rest is termintated)
						terminatePlayer(conNum)				
					End If		
				Else
					; terminate new incomming connection here because i already have this player on another connection
	
					terminatePlayer(conNum)
				End If
				
			End If
		
		Case 2 ; request to send out my compleet player info to requestor
			;Print "received request to send my player info to requestor"
			
			sendGameCommand(3, 0, conNum)
			
		Case 3 ; receive all info from a specific player
			;Print "receive all info from player"
			
			;addToLog("receive all player info from pl "+conNum)
			
			arrCnt=2
			strtPos=1
			endPos=Instr(package$,"|",strtPos)
			While endPos>0
				arrVal$=Mid(package$,strtPos,endPos-strtPos)

				;Print arrVal$
				players$(conNum,arrCnt) = arrVal$

				arrCnt=arrCnt+1
				
				; make sure to skip already known player data in array
				While arrCnt=14 Or arrCnt=15
					arrCnt=arrCnt+1
				Wend
			
				strtPos=endPos+1		
				endPos=Instr(package$,"|",strtPos)
			Wend
			
		Case 4 ; update a specific players arraypart with a new value
			;addToLog("receiving players array part value")

			; find player to update the array part for
			pnum=-1
			For c=0 To maxPlayers
				If players$(c,15)=senderPlayerKey$
					pnum=c
					c=maxPlayers
				End If
			Next
			
			If pnum<>-1
				val$=Left(package$,Instr(package$,"|")-1)
				apnum=Mid(package$,Instr(package$,"|")+1,Len(package$)-Instr(package$,"|")+1)
						
				players$(pnum,apnum)=val$
			
				inputWasUpdated(pnum)=apnum
			End If

			addToLog("receive arrnum=" + apnum + " val=" + val$ + " from player num="+pnum)

		Case 5 ; make connection to a new player that i haven't met yet
			;Print "received connect me to a new player"

			; receive the new player network info from a other known player that is broadcasting to me. I don't have a connection to the new player yet
			; build a connection and send out a add request to new player, conNum is from the known player at this point
			
			;Print "received new player that i need to connect to "+senderPlayerKey$
	
			isnew=True
			For c=0 To maxPlayers
				If players$(c,15)=senderPlayerKey$
					;Print "not new. ignoring"
					isnew=False
				End If
			Next
			
			If isnew
				; extract ip's and port info from package received for this game command
				; get the new user network info
	
				;Print "making connection to player"
				
				senderIntranetIP$=Left(package$,4)
				senderPort$=Mid(package$,5,4)	
				senderInternetIP$=Mid(package$,9,4)			
				senderUsedInternetIP$=Mid(package$,13,1)			
						
				conIP$=""
				If senderUsedInternetIP$="0" ; use intranet ip (lan)
					conIP$=senderIntranetIP$
				Else
					conIP$=senderInternetIP$			
				End If
				
				newTCPstream=OpenTCPStream(convertAscStrToDottedIP$(conIP$),senderPort$)
	
				If newTCPstream
					newconNum=addNewPlayerConnection(newTCPstream)
					
					; send out my info so the other side can add me to it's players list and connection list
					sendGameCommand(1, 0, newconNum)
				;Else
				;	Print "can't connection: " + convertAscStrToDottedIP$(conIP$)+" - "+senderPort$
				
				End If

			End If

		Case 6 ; get mouse update
			
			arrCnt=9
			strtPos=1
			endPos=Instr(package$,"|",strtPos)
			While endPos>0
				arrVal$=Mid(package$,strtPos,endPos-strtPos)

				;Print arrVal$
				players$(conNum,arrCnt) = arrVal$

				arrCnt=arrCnt+1
			
				strtPos=endPos+1		
				endPos=Instr(package$,"|",strtPos)
			Wend			
			
			inputWasUpdated(conNum)=9

			;addToLog("receive mouse string="+package$)
	
		Case 10 ; player is leaving, remove from my list
			;Print "received player is leaving"
			
			; connection stream of this player will eof soon, will automaticaly trigger termintate player routine
			; but this does not always happen fast enough when the same connection returns, so terminate player here also			
			
			terminatePlayer(conNum)
									
	End Select

End Function

Function sendGameCommand(command, sourcePlayerNum, targetPlayerNum, arrPartNum=-1)
	; sourcePlayerNum = player that holds the data to send out to a target player (me most of the time so =0 most of the time)
	; targetPlayerNum = the player to receive the source players data

	If tcpStreams(targetPlayerNum,0)
		;Print "sending command "+command + " to " + players$(targetPlayerNum,15) + " from " + players$(sourcePlayerNum,15) 
	
		Select command
			Case 1 ; send add player request (sourcePlayerNum) to targetPlayerNum
				;Print "send add player request"
				
				createTCPPackage(1, targetPlayerNum, players$(sourcePlayerNum,15))
				fillTCPPackage(players$(sourcePlayerNum,0)+players$(sourcePlayerNum,1)+players$(sourcePlayerNum,14)+players$(sourcePlayerNum,16),targetPlayerNum)
				endTCPPackage(targetPlayerNum)
				
			Case 2 ; send request to give me all player info for a specific player
				;Print "send give me all player info"
				
				createTCPPackage(2, targetPlayerNum)
				endTCPPackage(targetPlayerNum)
				
			Case 3 ; send player info to target
				;Print "send all info of specific player"
				
				createTCPPackage(3, targetPlayerNum)
				
				; don't send intranet and internet ip, port number and playerkey. all these are already known and will not change
				For i=2 To 17
					If i<>14 And i<>15
						fillTCPPackage(players$(sourcePlayerNum,i)+"|",targetPlayerNum)
					End If
				Next
				endTCPPackage(targetPlayerNum)
				
			Case 4 ; send update of sourcesplayer array part to target player
				;Print "send update for arr part " + arrPartNum
			
				createTCPPackage(4, targetPlayerNum, players$(sourcePlayerNum,15))
				fillTCPPackage(players$(sourcePlayerNum,arrPartNum)+"|"+arrPartNum,targetPlayerNum)
				endTCPPackage(targetPlayerNum)

				addToLog("send part val="+players$(sourcePlayerNum,arrPartNum)+" num="+arrPartNum+" to "+targetPlayerNum)

			Case 5 ; send connect new player request (sourcePlayerNum is the new player, targetplayer is the player that does not yet know the new player)
				;Print "send connect new player request"
				
				createTCPPackage(5, targetPlayerNum, players$(sourcePlayerNum,15))
				fillTCPPackage(players$(sourcePlayerNum,0)+players$(sourcePlayerNum,1)+players$(sourcePlayerNum,14)+players$(sourcePlayerNum,16),targetPlayerNum)
				endTCPPackage(targetPlayerNum)

			Case 6 ; send update of mouse to target player
				;Print "send update for arr part " + arrPartNum
			
				createTCPPackage(6, targetPlayerNum)

				fillTCPPackage(players$(sourcePlayerNum,9)+"|",targetPlayerNum)
				fillTCPPackage(players$(sourcePlayerNum,10)+"|",targetPlayerNum)
				fillTCPPackage(players$(sourcePlayerNum,11)+"|",targetPlayerNum)
				fillTCPPackage(players$(sourcePlayerNum,12)+"|",targetPlayerNum)

				endTCPPackage(targetPlayerNum)	
			
				;addToLog("send mouse mx="+players$(sourcePlayerNum,9)+" my="+players$(sourcePlayerNum,10)+" mk="+players$(sourcePlayerNum,11)+" mw="+players$(sourcePlayerNum,12) )			
			
			Case 10 ; send out player is leaving command
				;Print "send leaving now"
				
				createTCPPackage(10, targetPlayerNum)
				endTCPPackage(targetPlayerNum)
	
		End Select
	
	Else
		; no connection to targetplayer so kill the player compleetly
	
		;Print "no connection to target player, killing player"
	
		terminatePlayer(targetPlayerNum)

	End If
End Function

Function generatePlayerKey$(l)
	SeedRnd (MilliSecs())

	k$=""
	For t=0 To l
		k$ = k$ + Chr$(Rnd(200)+20)
	Next
	
	Return k$
End Function

Function WanIP$()
	; depends on an internet site! if not found, now wan ip :(
	
	Local i,l$,ip$,c$,www

	addToLog("getting WAN ip")

	If config\wan_ip<>""
		addToLog("wan ip via config set to "+config\wan_ip)

		Return config\wan_ip
	End If

    www=OpenTCPStream( "checkip.dyndns.org",80 )

    If Not www Return ""
	
    WriteLine www,"GET / HTTP/1.1"
    WriteLine www,"User-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)"
    WriteLine www,"Accept: */*"
    WriteLine www,""
	
	For i = 0 To 7
		ReadLine(www)
	Next

	l$=ReadLine(www)
	find=Instr(l$,"Current IP Address:",1)+19
	ip$=""

	; todo: this routine does not work for IP 217.123.240.212
	For i=1 To 14
		c$=Mid$(l$,find+i,1)
		If c$<>"<" Then ip$=ip$+c$
		If c$="<" Then Exit
	Next
	
    CloseTCPStream www

	addToLog("wan ip is set to "+Trim$(ip$))

    Return Trim$(ip$)

End Function


; ------------------------ end of network functions --------------------

Function readINI()
	filein = ReadFile("game.ini")
	
	While Not Eof(filein)
		cLine$ = ReadLine(filein)
		
		If Len(cLine)>0 ; chars found
			If Left(cLine,1)<>"#"  ; chars are not comment
				If Instr(cLine$,"=")>0  ;  if readable variable is found
					
					varname$=Lower(Trim( Left(cLine$,Instr(cLine$,"=")-1)) )
					varvalue$=Trim(Right(cLine$, Len(cLine$)-Instr(cLine$,"=") ))
					
					;addToLog(varname$)
					;addToLog(varvalue$)
					
					Select varname$
						Case "full screen":	
							config\fullscreen=(Lower(varvalue$)="true")
							
						Case "player name":
							config\playername=varvalue$
						Case "host ip":
							config\host_ip=varvalue$
						Case "game name":
							config\gamename=varvalue$
						Case "max players connected":
							config\maxplayersconnected=Int(varvalue$)
						Case "port start":
							config\portstart=Int(varvalue$)
						Case "port end":
							config\portend=Int(varvalue$)
						Case "max package stack":
							config\maxpackagestack=Int(varvalue$)
						Case "package send interval":
							config\packagesendinterval=Int(varvalue$)
						
						Case "logging":
							config\logging=(Lower(varvalue$)="true")
							
						Case "frame limit"
							config\framelimit=Int(varvalue$)
							
						Case "wan ip"
							config\wan_ip=varvalue$
						
						Case "theme"
							config\theme=varvalue$ 
					End Select				
				
				End If
			End If
		End If
		
	Wend
		
	CloseFile(filein)

End Function