puts "REGISSR Tcl shell"

#package require TclOO

set SOURCE_DIR 0
set SOURCE_ZIP 1
setAssetSource $SOURCE_DIR "data/" 
initializeSystem

set mainPath [pwd]
cd [getAssetSourceDir]
source scripts/util.tcl
source scripts/params.tcl
source scripts/param_utils.tcl
source scripts/param_mods.tcl
source scripts/ui.tcl
cd $mainPath

if {[debugModeEnabled]} {
	Settings windowsettings 1280 720 false false "Peisik Demo"
	Window win windowsettings
} else {
	Window win [inquireLaunchSettings "j\u00e4rjen valo"]
}

Song song demotrak.mp3 88

set demoptr [createDemoObject win song]

if {[debugModeEnabled]} {
	DebugPlayer player win
} else {
	ReleasePlayer player win
}

puts "Debugmode enabled: [debugModeEnabled]"

load_rocket_params player

# the value of the demoptr is the actual pointer string
player loadDemo $demoptr 
puts "Playing demo $demoptr"

set param_map [player getParameterMap]
set vektor [new_stringvector]

player play
while {[win processEvents]} {
	set row [song getRow]
	getParamKeys $param_map $vektor

	if {[debugModeEnabled]}	{
		update_ui win demoptr player song
	}


	player updateSyncTime $row
	player updateSyncParams $row [player getParameterMap]

	# Apply parameter modifiers (defined in param_mods.tcl)
	set param_names [read_params $vektor]
	update_param_modifiers $param_names $param_mods [player getParameterMap]

	win draw
}

puts "Demo ended"
cleanupSystem
exit
