function Effect4() {
	//init START
	renderer.setSize(WIDTH, HEIGHT);
	container.appendChild(renderer.domElement);				//linking rendering window to container on the DOM
	scene2D.add(camera2D);										//lets add our camera2D to the scene2D
	var vertShader = [
		'varying vec4 verpos;',
		'void main() {',
		'gl_Position = projectionMatrix *',
		'modelViewMatrix *',
		'vec4(position,1.0);',
		'}'
		].join('\n'); 
	var startTime = (new Date()).getTime();
	var fragShader = document.getElementById( 'effect4fs' ).innerHTML;

	var size = 256;
	var dataColor = new Float32Array( size * 4 );
		for(var i = 0; i < size; i++)
		{
			dataColor[ i * 4 + 0 ] = 0.0;
			dataColor[ i * 4 + 1 ] = 0.0;
			dataColor[ i * 4 + 2 ] = 0.0;
			dataColor[ i * 4 + 3 ] = 0.0;
			//console.log(result[i].end[0] +","+result[i].end[1])
		}
	var map = new THREE.DataTexture(dataColor, size, 1, THREE.RGBAFormat, THREE.FloatType );
	map.needsUpdate = true;
	var uniforms = {
		iResolution: {type: 'v2', value: new THREE.Vector2(WIDTH,HEIGHT)},
		globalTime: {type: 'f', value: (new Date()).getDate()},
		points: {type:'t', value:map},
        video: {type:'t', value:texture},
        pyora: {type:'t', value:pyora}
		}
	video.play();
	var shaderMaterial = new THREE.ShaderMaterial({
		vertexShader: vertShader, 
		fragmentShader: fragShader,
		uniforms: uniforms
		}
		);
	var geo = new THREE.Geometry();
	geo.vertices.push(new THREE.Vector3(-1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, -1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(1.0, 1.0, 0.0));
	geo.vertices.push(new THREE.Vector3(-1.0, 1.0, 0.0));
	geo.faces.push( new THREE.Face3(0,1,2));
	geo.faces.push( new THREE.Face3(0,2,3));
	var cube = new THREE.Mesh( geo, shaderMaterial);
	cube.position.z=-1;
	scene2D.add(cube);
	video.currentTime=0.0;
	video.loop=true;
  	video.defaultPlaybackRate = 0.4;
	video.play();
	//getters
	/*NONE :-)*/
	//setters
	/*
	 *updates screen!!!1111onenoneoneelevenelevenonehundredandaeleven
	 */
	this.updateScreen = function() {
		var time = ((new Date()).getTime() - startTime)*0.001
		var size = 256;
		var dataColor = new Float32Array( size * 4 );
		puutos.update(time);
		var result = puutos.get(time);

		imageContext.drawImage( video, 0, 0 );
		texture.needsUpdate = true;
		uniforms.video.needsUpdate = true;
		uniforms.video.value = texture;

		for(var i = 0; i < 80.0; i++)
		{
			dataColor[ i * 4 + 0 ] = result[i].start[0];
			dataColor[ i * 4 + 1 ] = result[i].start[1];
			dataColor[ i * 4 + 2 ] = result[i].end[0];
			dataColor[ i * 4 + 3 ] = result[i].end[1];
		}
		var map = new THREE.DataTexture(dataColor, size, 1, THREE.RGBAFormat, THREE.FloatType );
		map.needsUpdate = true;

		uniforms.points.value = map;
		uniforms.globalTime.value = time;
		renderer.render(scene2D, camera2D);
	};
};
