/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.output.EmptyOutput;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.log.Log;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class EasterEggDirective
extends AsmDirective {
    private static final Log log = new Log("EasterEgg");

    public EasterEggDirective(DebugInfo debugInfo) {
        super(debugInfo);
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) {
        String string = "/data/easteregg.prg";
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new AsmError("Can't find the resource " + string, this.debug);
        }
        try {
            log.println("Congratulations - You found the easter egg!!");
            String string2 = "easteregg.prg";
            log.println("Writing " + string2);
            FileOutputStream fileOutputStream = new FileOutputStream(string2);
            this.readDecodeAndWriteFile(inputStream, fileOutputStream);
            inputStream.close();
            ((OutputStream)fileOutputStream).close();
        }
        catch (Exception exception) {
            log.error("Error while writing the easteregg");
            log.error(exception);
        }
        return EmptyOutput.instance;
    }

    private void readDecodeAndWriteFile(InputStream inputStream, OutputStream outputStream) throws Exception {
        int n;
        int n2 = 0;
        while ((n = inputStream.read()) != -1) {
            outputStream.write(n ^ n2 & 0xFF);
            ++n2;
        }
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("easteregg", this.debug, new ExprNode[0]);
        return nodeTreeBuilder;
    }
}

