/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.directives.asmmode;

import cml.kickass.asmnode.AsmNode;
import cml.kickass.asmnode.NodeTreeBuilder;
import cml.kickass.asmnode.metanodes.ArgumentAssignmentNode;
import cml.kickass.asmnode.metanodes.AsmNodeList;
import cml.kickass.directives.Label;
import cml.kickass.directives.LabelConnector;
import cml.kickass.directives.asmmode.AsmDirective;
import cml.kickass.exceptions.AsmError;
import cml.kickass.exceptions.AsmException;
import cml.kickass.exceptions.ShouldNotBeHereException;
import cml.kickass.expressions.ExprNode;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.lexvalues.ExecutableDirectives;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.AsmCommandArgumentValue;
import cml.kickass.values.NameSpaceValue;
import java.util.List;

public class PseudoCommandExecution
extends AsmDirective
implements LabelConnector {
    private String name;
    private List<ExprNode> argumentExprs;
    private String nameSpaceId;

    public PseudoCommandExecution(String string, List<ExprNode> list, DebugInfo debugInfo) {
        super(debugInfo);
        this.name = string;
        this.argumentExprs = list;
    }

    @Override
    public boolean connectToLabel(Label label) {
        this.nameSpaceId = label.getName();
        return true;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode preParse(EvaluationState evaluationState) throws AsmException {
        ExecutableDirectives executableDirectives = evaluationState.getCurrentScope().getPseudoCommands().get(this.name);
        if (executableDirectives == null) {
            throw new AsmError("Pseudo command  '" + this.name + "' not defined", this.debug);
        }
        List<String> list = executableDirectives.getArgumentNames();
        if (list.size() < this.argumentExprs.size() && (list.size() != 0 || this.argumentExprs.size() != 1)) {
            throw new AsmError("Too many arguments for pseudo command", this.debug);
        }
        NameSpaceValue nameSpaceValue = this.nameSpaceId == null ? null : new NameSpaceValue(this.nameSpaceId, true);
        AsmNode asmNode = new AsmNodeList(executableDirectives.getCopyOfDirectives());
        asmNode = new ArgumentAssignmentNode(executableDirectives.getArgumentNames(), this.argumentExprs, asmNode, AsmCommandArgumentValue.noArgument, nameSpaceValue, this.debug);
        return asmNode.preParse(evaluationState);
    }

    @Override
    public AsmNode parse(EvaluationState evaluationState) throws AsmException {
        throw ShouldNotBeHereException.instance;
    }

    @Override
    public NodeTreeBuilder toNodeTreeString(NodeTreeBuilder nodeTreeBuilder) {
        nodeTreeBuilder.addNode("PseudoCmdExec", this.debug, this.name, "" + this.nameSpaceId, this.argumentExprs);
        return nodeTreeBuilder;
    }
}

