/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.misc;

import cml.kickass.exceptions.AsmError;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.plugins.interf.IMemoryBlock;
import cml.tools.collections.ByteArray;

public class MemoryBlock {
    private String name;
    private boolean virtual;
    private int maxMemoryAdress = 65535;
    private int startAdress;
    private int size = 0;
    private ByteArray memory;
    private IMemoryBlock pluginMemoryBlock = null;

    public MemoryBlock(int n, String string, boolean bl, int n2) {
        this.startAdress = n;
        this.name = string == null ? "unnamed" : string;
        this.virtual = bl;
        this.memory = bl ? null : new ByteArray(4096);
        this.maxMemoryAdress = n2;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void addByte(byte by, DebugInfo debugInfo) throws AsmError {
        if (this.maxMemoryAdress >= 0 && this.startAdress + this.size > this.maxMemoryAdress) {
            throw new AsmError("ERROR! Memory overflow. Memory exceeds the " + this.maxMemoryAdress + " bytes limit!", debugInfo);
        }
        if (!this.virtual) {
            this.memory.addByte(by);
        }
        ++this.size;
    }

    public void addBytes(byte[] byArray, DebugInfo debugInfo) throws AsmError {
        for (int i = 0; i < byArray.length; ++i) {
            this.addByte(byArray[i], debugInfo);
        }
    }

    public int getStartAdress() {
        return this.startAdress;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getMemory() {
        return this.memory.getBytes();
    }

    public boolean contentEquals(MemoryBlock memoryBlock) {
        boolean bl;
        boolean bl2 = bl = this.name.equals(memoryBlock.name) && this.startAdress == memoryBlock.startAdress && this.size == memoryBlock.size && this.virtual == memoryBlock.virtual;
        if (!bl) {
            return false;
        }
        byte[] byArray = this.getMemory();
        byte[] byArray2 = memoryBlock.getMemory();
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public IMemoryBlock getPluginMemoryBlock() {
        if (this.pluginMemoryBlock == null) {
            this.pluginMemoryBlock = new PluginMemoryBlock();
        }
        return this.pluginMemoryBlock;
    }

    private class PluginMemoryBlock
    implements IMemoryBlock {
        private PluginMemoryBlock() {
        }

        @Override
        public int getStartAddress() {
            return MemoryBlock.this.getStartAdress();
        }

        @Override
        public byte[] getBytes() {
            return MemoryBlock.this.getMemory();
        }

        @Override
        public String getName() {
            return MemoryBlock.this.getName();
        }
    }
}

