/*
 * Decompiled with CFR 0.152.
 */
package cml.kickass.values;

import cml.kickass.exceptions.AsmException;
import cml.kickass.function.Function;
import cml.kickass.function.table.FunctionTable;
import cml.kickass.function.table.StdFunctionTable;
import cml.kickass.lexvalues.DebugInfo;
import cml.kickass.state.EvaluationState;
import cml.kickass.values.BooleanValue;
import cml.kickass.values.InvalidValue;
import cml.kickass.values.ListValue;
import cml.kickass.values.LockableValue;
import cml.kickass.values.NullValue;
import cml.kickass.values.StringValue;
import cml.kickass.values.Value;
import java.util.HashMap;
import java.util.Map;

public class HashtableValue
extends LockableValue {
    private HashMap<String, Value> hashtable = new HashMap();
    private boolean hasInvalidContent = false;
    static FunctionTable functions = new StdFunctionTable(HashtableValue.getStandardFunctions());

    public HashtableValue addStringValues(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.putValue(entry.getKey(), new StringValue(entry.getValue()));
        }
        return this;
    }

    void putValue(String string, Value value) {
        if (value.isInvalidOrInvalidContent()) {
            this.hasInvalidContent = true;
        }
        this.hashtable.put(string, value);
    }

    @Override
    public String getType() {
        return "Hashtable";
    }

    @Override
    public boolean hasInvalidContent() {
        return this.hasInvalidContent;
    }

    @Override
    public Object getRepresentation(int n) throws AsmException {
        if (n == RP_STRINGVALUE) {
            if (this.isInvalid()) {
                return "<<Invalid HashTable>>";
            }
            return "Hashtable";
        }
        return null;
    }

    @Override
    public FunctionTable getFunctions() {
        return functions;
    }

    @Override
    public void lock(DebugInfo debugInfo) {
        if (this.isLocked) {
            return;
        }
        this.isLocked = true;
        for (Value value : this.hashtable.values()) {
            value.lock(debugInfo);
        }
    }

    static {
        functions.add(new HashTableFunction("put", 3, null){

            @Override
            protected Value f(HashtableValue hashtableValue, DebugInfo debugInfo, Value ... valueArray) {
                String string = valueArray[1].getString(debugInfo);
                Value value = valueArray[2];
                hashtableValue.putValue(string, value);
                if (value.isInvalidOrInvalidContent()) {
                    hashtableValue.hasInvalidContent = true;
                }
                return value;
            }
        });
        functions.add(new HashTableFunction("get", 2, (Value)InvalidValue.instance){

            @Override
            protected Value f(HashtableValue hashtableValue, DebugInfo debugInfo, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return InvalidValue.instance;
                }
                String string = valueArray[1].getString(debugInfo);
                Value value = (Value)hashtableValue.hashtable.get(string);
                if (value == null) {
                    value = NullValue.instance;
                }
                return value;
            }
        });
        functions.add(new HashTableFunction("keys", 1, (Value)ListValue.invalid){

            @Override
            protected Value f(HashtableValue hashtableValue, DebugInfo debugInfo, Value ... valueArray) {
                ListValue listValue = new ListValue(0);
                for (String string : hashtableValue.hashtable.keySet()) {
                    listValue.add((Value)new StringValue(string));
                }
                return listValue;
            }
        });
        functions.add(new HashTableFunction("containsKey", 2, (Value)BooleanValue.invalid){

            @Override
            protected Value f(HashtableValue hashtableValue, DebugInfo debugInfo, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return BooleanValue.invalid;
                }
                String string = valueArray[1].getString(debugInfo);
                return BooleanValue.get(hashtableValue.hashtable.containsKey(string));
            }
        });
        functions.add(new HashTableFunction("remove", 2, (Value)NullValue.instance){

            @Override
            protected Value f(HashtableValue hashtableValue, DebugInfo debugInfo, Value ... valueArray) {
                if (valueArray[1].isInvalid()) {
                    return NullValue.instance;
                }
                String string = valueArray[1].getString(debugInfo);
                Value value = (Value)hashtableValue.hashtable.remove(string);
                if (value == null) {
                    value = NullValue.instance;
                }
                return value;
            }
        });
    }

    private static abstract class HashTableFunction
    extends Function {
        public HashTableFunction(String string, int n, Value value) {
            super(string, n, value, true);
        }

        @Override
        public Value execute(Value[] valueArray, EvaluationState evaluationState, DebugInfo debugInfo) {
            HashtableValue hashtableValue = (HashtableValue)valueArray[0];
            if (hashtableValue.isInvalid()) {
                return this.getInvalidResult(valueArray);
            }
            return this.f(hashtableValue, debugInfo, valueArray);
        }

        protected abstract Value f(HashtableValue var1, DebugInfo var2, Value ... var3);
    }
}

